( function( $ ) {

	'use strict';

	if ( typeof wpcf7 === 'undefined' || wpcf7 === null ) {
		return;
	}

	wpcf7 = $.extend( {
		cached: 0,
		inputs: []
	}, wpcf7 );

	$( function() {
		wpcf7.supportHtml5 = ( function() {
			var features = {};
			var input = document.createElement( 'input' );

			features.placeholder = 'placeholder' in input;

			var inputTypes = [ 'email', 'url', 'tel', 'number', 'range', 'date' ];

			$.each( inputTypes, function( index, value ) {
				input.setAttribute( 'type', value );
				features[ value ] = input.type !== 'text';
			} );

			return features;
		} )();

		$( 'div.wpcf7 > form' ).each( function() {
			var $form = $( this );
			wpcf7.initForm( $form );

			if ( wpcf7.cached ) {
				wpcf7.refill( $form );
			}
		} );
	} );

	wpcf7.getId = function( form ) {
		return parseInt( $( 'input[name="_wpcf7"]', form ).val(), 10 );
	};

	wpcf7.initForm = function( form ) {
		var $form = $( form );

		wpcf7.setStatus( $form, 'init' );

		$form.submit( function( event ) {
			if ( ! wpcf7.supportHtml5.placeholder ) {
				$( '[placeholder].placeheld', $form ).each( function( i, n ) {
					$( n ).val( '' ).removeClass( 'placeheld' );
				} );
			}

			if ( typeof window.FormData === 'function' ) {
				wpcf7.submit( $form );
				event.preventDefault();
			}
		} );

		$( '.wpcf7-submit', $form ).after( '<span class="ajax-loader"></span>' );

		wpcf7.toggleSubmit( $form );

		$form.on( 'click', '.wpcf7-acceptance', function() {
			wpcf7.toggleSubmit( $form );
		} );

		// Exclusive Checkbox
		$( '.wpcf7-exclusive-checkbox', $form ).on( 'click', 'input:checkbox', function() {
			var name = $( this ).attr( 'name' );
			$form.find( 'input:checkbox[name="' + name + '"]' ).not( this ).prop( 'checked', false );
		} );

		// Free Text Option for Checkboxes and Radio Buttons
		$( '.wpcf7-list-item.has-free-text', $form ).each( function() {
			var $freetext = $( ':input.wpcf7-free-text', this );
			var $wrap = $( this ).closest( '.wpcf7-form-control' );

			if ( $( ':checkbox, :radio', this ).is( ':checked' ) ) {
				$freetext.prop( 'disabled', false );
			} else {
				$freetext.prop( 'disabled', true );
			}

			$wrap.on( 'change', ':checkbox, :radio', function() {
				var $cb = $( '.has-free-text', $wrap ).find( ':checkbox, :radio' );

				if ( $cb.is( ':checked' ) ) {
					$freetext.prop( 'disabled', false ).focus();
				} else {
					$freetext.prop( 'disabled', true );
				}
			} );
		} );

		// Placeholder Fallback
		if ( ! wpcf7.supportHtml5.placeholder ) {
			$( '[placeholder]', $form ).each( function() {
				$( this ).val( $( this ).attr( 'placeholder' ) );
				$( this ).addClass( 'placeheld' );

				$( this ).focus( function() {
					if ( $( this ).hasClass( 'placeheld' ) ) {
						$( this ).val( '' ).removeClass( 'placeheld' );
					}
				} );

				$( this ).blur( function() {
					if ( '' === $( this ).val() ) {
						$( this ).val( $( this ).attr( 'placeholder' ) );
						$( this ).addClass( 'placeheld' );
					}
				} );
			} );
		}

		if ( wpcf7.jqueryUi && ! wpcf7.supportHtml5.date ) {
			$form.find( 'input.wpcf7-date[type="date"]' ).each( function() {
				$( this ).datepicker( {
					dateFormat: 'yy-mm-dd',
					minDate: new Date( $( this ).attr( 'min' ) ),
					maxDate: new Date( $( this ).attr( 'max' ) )
				} );
			} );
		}

		if ( wpcf7.jqueryUi && ! wpcf7.supportHtml5.number ) {
			$form.find( 'input.wpcf7-number[type="number"]' ).each( function() {
				$( this ).spinner( {
					min: $( this ).attr( 'min' ),
					max: $( this ).attr( 'max' ),
					step: $( this ).attr( 'step' )
				} );
			} );
		}

		// Character Count
		wpcf7.resetCounter( $form );

		// URL Input Correction
		$form.on( 'change', '.wpcf7-validates-as-url', function() {
			var val = $.trim( $( this ).val() );

			if ( val
			&& ! val.match( /^[a-z][a-z0-9.+-]*:/i )
			&& -1 !== val.indexOf( '.' ) ) {
				val = val.replace( /^\/+/, '' );
				val = 'http://' + val;
			}

			$( this ).val( val );
		} );
	};

	wpcf7.submit = function( form ) {
		if ( typeof window.FormData !== 'function' ) {
			return;
		}

		var $form = $( form );

		$( '.ajax-loader', $form ).addClass( 'is-active' );
		wpcf7.clearResponse( $form );

		var formData = new FormData( $form.get( 0 ) );

		var detail = {
			id: $form.closest( 'div.wpcf7' ).attr( 'id' ),
			status: 'init',
			inputs: [],
			formData: formData
		};

		$.each( $form.serializeArray(), function( i, field ) {
			if ( '_wpcf7' == field.name ) {
				detail.contactFormId = field.value;
			} else if ( '_wpcf7_version' == field.name ) {
				detail.pluginVersion = field.value;
			} else if ( '_wpcf7_locale' == field.name ) {
				detail.contactFormLocale = field.value;
			} else if ( '_wpcf7_unit_tag' == field.name ) {
				detail.unitTag = field.value;
			} else if ( '_wpcf7_container_post' == field.name ) {
				detail.containerPostId = field.value;
			} else if ( field.name.match( /^_/ ) ) {
				// do nothing
			} else {
				detail.inputs.push( field );
			}
		} );

		wpcf7.triggerEvent( $form.closest( 'div.wpcf7' ), 'beforesubmit', detail );

		var ajaxSuccess = function( data, status, xhr, $form ) {
			detail.id = $( data.into ).attr( 'id' );
			detail.status = data.status;
			detail.apiResponse = data;

			switch ( data.status ) {
				case 'init':
					wpcf7.setStatus( $form, 'init' );
					break;
				case 'validation_failed':
					$.each( data.invalid_fields, function( i, n ) {
						$( n.into, $form ).each( function() {
							wpcf7.notValidTip( this, n.message );
							$( '.wpcf7-form-control', this ).addClass( 'wpcf7-not-valid' );
							$( '.wpcf7-form-control', this ).attr(
								'aria-describedby',
								n.error_id
							);
							$( '[aria-invalid]', this ).attr( 'aria-invalid', 'true' );
						} );
					} );

					wpcf7.setStatus( $form, 'invalid' );
					wpcf7.triggerEvent( data.into, 'invalid', detail );
					break;
				case 'acceptance_missing':
					wpcf7.setStatus( $form, 'unaccepted' );
					wpcf7.triggerEvent( data.into, 'unaccepted', detail );
					break;
				case 'spam':
					wpcf7.setStatus( $form, 'spam' );
					wpcf7.triggerEvent( data.into, 'spam', detail );
					break;
				case 'aborted':
					wpcf7.setStatus( $form, 'aborted' );
					wpcf7.triggerEvent( data.into, 'aborted', detail );
					break;
				case 'mail_sent':
					wpcf7.setStatus( $form, 'sent' );
					wpcf7.triggerEvent( data.into, 'mailsent', detail );
					break;
				case 'mail_failed':
					wpcf7.setStatus( $form, 'failed' );
					wpcf7.triggerEvent( data.into, 'mailfailed', detail );
					break;
				default:
					wpcf7.setStatus( $form,
						'custom-' + data.status.replace( /[^0-9a-z]+/i, '-' )
					);
			}

			wpcf7.refill( $form, data );

			wpcf7.triggerEvent( data.into, 'submit', detail );

			if ( 'mail_sent' == data.status ) {
				$form.each( function() {
					this.reset();
				} );

				wpcf7.toggleSubmit( $form );
				wpcf7.resetCounter( $form );
			}

			if ( ! wpcf7.supportHtml5.placeholder ) {
				$form.find( '[placeholder].placeheld' ).each( function( i, n ) {
					$( n ).val( $( n ).attr( 'placeholder' ) );
				} );
			}

			$( '.wpcf7-response-output', $form )
				.html( '' ).append( data.message ).slideDown( 'fast' );

			$( '.screen-reader-response', $form.closest( '.wpcf7' ) ).each( function() {
				var $response = $( this );
				$( '[role="status"]', $response ).html( data.message );

				if ( data.invalid_fields ) {
					$.each( data.invalid_fields, function( i, n ) {
						if ( n.idref ) {
							var $li = $( '<li></li>' ).append( $( '<a></a>' ).attr( 'href', '#' + n.idref ).append( n.message ) );
						} else {
							var $li = $( '<li></li>' ).append( n.message );
						}

						$li.attr( 'id', n.error_id );

						$( 'ul', $response ).append( $li );
					} );
				}
			} );

			if ( data.posted_data_hash ) {
				$form.find( 'input[name="_wpcf7_posted_data_hash"]' ).first()
					.val( data.posted_data_hash );
			}
		};

		$.ajax( {
			type: 'POST',
			url: wpcf7.apiSettings.getRoute(
				'/contact-forms/' + wpcf7.getId( $form ) + '/feedback' ),
			data: formData,
			dataType: 'json',
			processData: false,
			contentType: false
		} ).done( function( data, status, xhr ) {
			ajaxSuccess( data, status, xhr, $form );
			$( '.ajax-loader', $form ).removeClass( 'is-active' );
		} ).fail( function( xhr, status, error ) {
			var $e = $( '<div class="ajax-error"></div>' ).text( error.message );
			$form.after( $e );
		} );
	};

	wpcf7.triggerEvent = function( target, name, detail ) {
		var event = new CustomEvent( 'wpcf7' + name, {
			bubbles: true,
			detail: detail
		} );

		$( target ).get( 0 ).dispatchEvent( event );
	};

	wpcf7.setStatus = function( form, status ) {
		var $form = $( form );
		var prevStatus = $form.attr( 'data-status' );

		$form.data( 'status', status );
		$form.addClass( status );
		$form.attr( 'data-status', status );

		if ( prevStatus && prevStatus !== status ) {
			$form.removeClass( prevStatus );
		}
	}

	wpcf7.toggleSubmit = function( form, state ) {
		var $form = $( form );
		var $submit = $( 'input:submit', $form );

		if ( typeof state !== 'undefined' ) {
			$submit.prop( 'disabled', ! state );
			return;
		}

		if ( $form.hasClass( 'wpcf7-acceptance-as-validation' ) ) {
			return;
		}

		$submit.prop( 'disabled', false );

		$( '.wpcf7-acceptance', $form ).each( function() {
			var $span = $( this );
			var $input = $( 'input:checkbox', $span );

			if ( ! $span.hasClass( 'optional' ) ) {
				if ( $span.hasClass( 'invert' ) && $input.is( ':checked' )
				|| ! $span.hasClass( 'invert' ) && ! $input.is( ':checked' ) ) {
					$submit.prop( 'disabled', true );
					return false;
				}
			}
		} );
	};

	wpcf7.resetCounter = function( form ) {
		var $form = $( form );

		$( '.wpcf7-character-count', $form ).each( function() {
			var $count = $( this );
			var name = $count.attr( 'data-target-name' );
			var down = $count.hasClass( 'down' );
			var starting = parseInt( $count.attr( 'data-starting-value' ), 10 );
			var maximum = parseInt( $count.attr( 'data-maximum-value' ), 10 );
			var minimum = parseInt( $count.attr( 'data-minimum-value' ), 10 );

			var updateCount = function( target ) {
				var $target = $( target );
				var length = $target.val().length;
				var count = down ? starting - length : length;
				$count.attr( 'data-current-value', count );
				$count.text( count );

				if ( maximum && maximum < length ) {
					$count.addClass( 'too-long' );
				} else {
					$count.removeClass( 'too-long' );
				}

				if ( minimum && length < minimum ) {
					$count.addClass( 'too-short' );
				} else {
					$count.removeClass( 'too-short' );
				}
			};

			$( ':input[name="' + name + '"]', $form ).each( function() {
				updateCount( this );

				$( this ).keyup( function() {
					updateCount( this );
				} );
			} );
		} );
	};

	wpcf7.notValidTip = function( target, message ) {
		var $target = $( target );
		$( '.wpcf7-not-valid-tip', $target ).remove();

		$( '<span></span>' ).attr( {
			'class': 'wpcf7-not-valid-tip',
			'aria-hidden': 'true',
		} ).text( message ).appendTo( $target );

		if ( $target.is( '.use-floating-validation-tip *' ) ) {
			var fadeOut = function( target ) {
				$( target ).not( ':hidden' ).animate( {
					opacity: 0
				}, 'fast', function() {
					$( this ).css( { 'z-index': -100 } );
				} );
			};

			$target.on( 'mouseover', '.wpcf7-not-valid-tip', function() {
				fadeOut( this );
			} );

			$target.on( 'focus', ':input', function() {
				fadeOut( $( '.wpcf7-not-valid-tip', $target ) );
			} );
		}
	};

	wpcf7.refill = function( form, data ) {
		var $form = $( form );

		var refillCaptcha = function( $form, items ) {
			$.each( items, function( i, n ) {
				$form.find( ':input[name="' + i + '"]' ).val( '' );
				$form.find( 'img.wpcf7-captcha-' + i ).attr( 'src', n );
				var match = /([0-9]+)\.(png|gif|jpeg)$/.exec( n );
				$form.find( 'input:hidden[name="_wpcf7_captcha_challenge_' + i + '"]' ).attr( 'value', match[ 1 ] );
			} );
		};

		var refillQuiz = function( $form, items ) {
			$.each( items, function( i, n ) {
				$form.find( ':input[name="' + i + '"]' ).val( '' );
				$form.find( ':input[name="' + i + '"]' ).siblings( 'span.wpcf7-quiz-label' ).text( n[ 0 ] );
				$form.find( 'input:hidden[name="_wpcf7_quiz_answer_' + i + '"]' ).attr( 'value', n[ 1 ] );
			} );
		};

		if ( typeof data === 'undefined' ) {
			$.ajax( {
				type: 'GET',
				url: wpcf7.apiSettings.getRoute(
					'/contact-forms/' + wpcf7.getId( $form ) + '/refill' ),
				beforeSend: function( xhr ) {
					var nonce = $form.find( ':input[name="_wpnonce"]' ).val();

					if ( nonce ) {
						xhr.setRequestHeader( 'X-WP-Nonce', nonce );
					}
				},
				dataType: 'json'
			} ).done( function( data, status, xhr ) {
				if ( data.captcha ) {
					refillCaptcha( $form, data.captcha );
				}

				if ( data.quiz ) {
					refillQuiz( $form, data.quiz );
				}
			} );

		} else {
			if ( data.captcha ) {
				refillCaptcha( $form, data.captcha );
			}

			if ( data.quiz ) {
				refillQuiz( $form, data.quiz );
			}
		}
	};

	wpcf7.clearResponse = function( form ) {
		var $form = $( form );

		$form.siblings( '.screen-reader-response' ).each( function() {
			$( '[role="status"]', this ).html( '' );
			$( 'ul', this ).html( '' );
		} );

		$( '.wpcf7-not-valid-tip', $form ).remove();
		$( '[aria-invalid]', $form ).attr( 'aria-invalid', 'false' );
		$( '.wpcf7-form-control', $form ).removeClass( 'wpcf7-not-valid' );

		$( '.wpcf7-response-output', $form ).hide().empty();
	};

	wpcf7.apiSettings.getRoute = function( path ) {
		var url = wpcf7.apiSettings.root;

		url = url.replace(
			wpcf7.apiSettings.namespace,
			wpcf7.apiSettings.namespace + path );

		return url;
	};

} )( jQuery );

/*
 * Polyfill for Internet Explorer
 * See https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent/CustomEvent
 */
( function () {
	if ( typeof window.CustomEvent === "function" ) return false;

	function CustomEvent ( event, params ) {
		params = params || { bubbles: false, cancelable: false, detail: undefined };
		var evt = document.createEvent( 'CustomEvent' );
		evt.initCustomEvent( event,
			params.bubbles, params.cancelable, params.detail );
		return evt;
	}

	CustomEvent.prototype = window.Event.prototype;

	window.CustomEvent = CustomEvent;
} )();

!function(e){"use strict";"function"==typeof define&&define.amd?define(["jquery"],e):e("object"==typeof exports&&"function"==typeof require?require("jquery"):jQuery)}((function(e){"use strict";function t(n,o){var i=this;i.element=n,i.el=e(n),i.suggestions=[],i.badQueries=[],i.selectedIndex=-1,i.currentValue=i.element.value,i.timeoutId=null,i.cachedResponse={},i.onChangeTimeout=null,i.onChange=null,i.isLocal=!1,i.suggestionsContainer=null,i.noSuggestionsContainer=null,i.options=e.extend(!0,{},t.defaults,o),i.classes={selected:"autocomplete-selected",suggestion:"autocomplete-suggestion"},i.hint=null,i.hintValue="",i.selection=null,i.initialize(),i.setOptions(o)}var n={escapeRegExChars:function(e){return e.replace(/[|\\{}()[\]^$+*?.]/g,"\\$&")},createNode:function(e){var t=document.createElement("div");return t.className=e,t.style.position="absolute",t.style.display="none",t}},o=27,i=9,s=13,a=38,r=39,u=40,l=e.noop;t.utils=n,e.Autocomplete=t,t.defaults={ajaxSettings:{},autoSelectFirst:!1,appendTo:"body",serviceUrl:null,lookup:null,onSelect:null,width:"auto",minChars:1,maxHeight:300,deferRequestBy:0,params:{},formatResult:function(e,t){if(!t)return e.value;var o="("+n.escapeRegExChars(t)+")";return e.value.replace(new RegExp(o,"gi"),"<strong>$1</strong>").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/&lt;(\/?strong)&gt;/g,"<$1>")},formatGroup:function(e,t){return'<div class="autocomplete-group">'+t+"</div>"},delimiter:null,zIndex:9999,type:"GET",noCache:!1,onSearchStart:l,onSearchComplete:l,onSearchError:l,preserveInput:!1,containerClass:"autocomplete-suggestions",tabDisabled:!1,dataType:"text",currentRequest:null,triggerSelectOnValidInput:!0,preventBadQueries:!0,lookupFilter:function(e,t,n){return-1!==e.value.toLowerCase().indexOf(n)},paramName:"query",transformResult:function(e){return"string"==typeof e?JSON.parse(e):e},showNoSuggestionNotice:!1,noSuggestionNotice:"No results",orientation:"bottom",forceFixPosition:!1},t.prototype={initialize:function(){var n,o=this,i="."+o.classes.suggestion,s=o.classes.selected,a=o.options;o.element.setAttribute("autocomplete","off"),o.noSuggestionsContainer=e('<div class="autocomplete-no-suggestion"></div>').html(this.options.noSuggestionNotice).get(0),o.suggestionsContainer=t.utils.createNode(a.containerClass),(n=e(o.suggestionsContainer)).appendTo(a.appendTo||"body"),"auto"!==a.width&&n.css("width",a.width),n.on("mouseover.autocomplete",i,(function(){o.activate(e(this).data("index"))})),n.on("mouseout.autocomplete",(function(){o.selectedIndex=-1,n.children("."+s).removeClass(s)})),n.on("click.autocomplete",i,(function(){o.select(e(this).data("index"))})),n.on("click.autocomplete",(function(){clearTimeout(o.blurTimeoutId)})),o.fixPositionCapture=function(){o.visible&&o.fixPosition()},e(window).on("resize.autocomplete",o.fixPositionCapture),o.el.on("keydown.autocomplete",(function(e){o.onKeyPress(e)})),o.el.on("keyup.autocomplete",(function(e){o.onKeyUp(e)})),o.el.on("blur.autocomplete",(function(){o.onBlur()})),o.el.on("focus.autocomplete",(function(){o.onFocus()})),o.el.on("change.autocomplete",(function(e){o.onKeyUp(e)})),o.el.on("input.autocomplete",(function(e){o.onKeyUp(e)}))},onFocus:function(){var e=this;e.fixPosition(),e.el.val().length>=e.options.minChars&&e.onValueChange()},onBlur:function(){var e=this;e.blurTimeoutId=setTimeout((function(){e.hide()}),200)},abortAjax:function(){var e=this;e.currentRequest&&(e.currentRequest.abort(),e.currentRequest=null)},setOptions:function(t){var n=this,o=e.extend({},n.options,t);n.isLocal=Array.isArray(o.lookup),n.isLocal&&(o.lookup=n.verifySuggestionsFormat(o.lookup)),o.orientation=n.validateOrientation(o.orientation,"bottom"),e(n.suggestionsContainer).css({"max-height":o.maxHeight+"px",width:o.width+"px","z-index":o.zIndex}),this.options=o},clearCache:function(){this.cachedResponse={},this.badQueries=[]},clear:function(){this.clearCache(),this.currentValue="",this.suggestions=[]},disable:function(){var e=this;e.disabled=!0,clearTimeout(e.onChangeTimeout),e.abortAjax()},enable:function(){this.disabled=!1},fixPosition:function(){var t=this,n=e(t.suggestionsContainer),o=n.parent().get(0);if(o===document.body||t.options.forceFixPosition){var i=t.options.orientation,s=n.outerHeight(),a=t.el.outerHeight(),r=t.el.offset(),u={top:r.top,left:r.left};if("auto"===i){var l=e(window).height(),c=e(window).scrollTop(),g=-c+r.top-s,d=c+l-(r.top+a+s);i=Math.max(g,d)===g?"top":"bottom"}if(u.top+="top"===i?-s:a,o!==document.body){var p,h=n.css("opacity");t.visible||n.css("opacity",0).show(),p=n.offsetParent().offset(),u.top-=p.top,u.top+=o.scrollTop,u.left-=p.left,t.visible||n.css("opacity",h).hide()}"auto"===t.options.width&&(u.width=t.el.outerWidth()+"px"),n.css(u)}},isCursorAtEnd:function(){var e,t=this.el.val().length,n=this.element.selectionStart;return"number"==typeof n?n===t:!document.selection||((e=document.selection.createRange()).moveStart("character",-t),t===e.text.length)},onKeyPress:function(e){var t=this;if(t.disabled||t.visible||e.which!==u||!t.currentValue){if(!t.disabled&&t.visible){switch(e.which){case o:t.el.val(t.currentValue),t.hide();break;case r:if(t.hint&&t.options.onHint&&t.isCursorAtEnd()){t.selectHint();break}return;case i:if(t.hint&&t.options.onHint)return void t.selectHint();if(-1===t.selectedIndex)return void t.hide();if(t.select(t.selectedIndex),!1===t.options.tabDisabled)return;break;case s:if(-1===t.selectedIndex)return void t.hide();t.select(t.selectedIndex);break;case a:t.moveUp();break;case u:t.moveDown();break;default:return}e.stopImmediatePropagation(),e.preventDefault()}}else t.suggest()},onKeyUp:function(e){var t=this;if(!t.disabled){switch(e.which){case a:case u:return}clearTimeout(t.onChangeTimeout),t.currentValue!==t.el.val()&&(t.findBestHint(),t.options.deferRequestBy>0?t.onChangeTimeout=setTimeout((function(){t.onValueChange()}),t.options.deferRequestBy):t.onValueChange())}},onValueChange:function(){if(!this.ignoreValueChange){var t=this,n=t.options,o=t.el.val(),i=t.getQuery(o);return t.selection&&t.currentValue!==i&&(t.selection=null,(n.onInvalidateSelection||e.noop).call(t.element)),clearTimeout(t.onChangeTimeout),t.currentValue=o,t.selectedIndex=-1,n.triggerSelectOnValidInput&&t.isExactMatch(i)?void t.select(0):void(i.length<n.minChars?t.hide():t.getSuggestions(i))}this.ignoreValueChange=!1},isExactMatch:function(e){var t=this.suggestions;return 1===t.length&&t[0].value.toLowerCase()===e.toLowerCase()},getQuery:function(e){var t,n=this.options.delimiter;return n?(t=e.split(n))[t.length-1].trim():e},getSuggestionsLocal:function(t){var n,o=this.options,i=t.toLowerCase(),s=o.lookupFilter,a=parseInt(o.lookupLimit,10);return n={suggestions:e.grep(o.lookup,(function(e){return s(e,t,i)}))},a&&n.suggestions.length>a&&(n.suggestions=n.suggestions.slice(0,a)),n},getSuggestions:function(t){var n,o,i,s,a=this,r=a.options,u=r.serviceUrl;if(r.params[r.paramName]=t,!1!==r.onSearchStart.call(a.element,r.params)){if(o=r.ignoreParams?null:r.params,"function"==typeof r.lookup)return void r.lookup(t,(function(e){a.suggestions=e.suggestions,a.suggest(),r.onSearchComplete.call(a.element,t,e.suggestions)}));a.isLocal?n=a.getSuggestionsLocal(t):("function"==typeof u&&(u=u.call(a.element,t)),i=u+"?"+e.param(o||{}),n=a.cachedResponse[i]),n&&Array.isArray(n.suggestions)?(a.suggestions=n.suggestions,a.suggest(),r.onSearchComplete.call(a.element,t,n.suggestions)):a.isBadQuery(t)?r.onSearchComplete.call(a.element,t,[]):(a.abortAjax(),s={url:u,data:o,type:r.type,dataType:r.dataType},e.extend(s,r.ajaxSettings),a.currentRequest=e.ajax(s).done((function(e){var n;a.currentRequest=null,n=r.transformResult(e,t),a.processResponse(n,t,i),r.onSearchComplete.call(a.element,t,n.suggestions)})).fail((function(e,n,o){r.onSearchError.call(a.element,t,e,n,o)})))}},isBadQuery:function(e){if(!this.options.preventBadQueries)return!1;for(var t=this.badQueries,n=t.length;n--;)if(0===e.indexOf(t[n]))return!0;return!1},hide:function(){var t=this,n=e(t.suggestionsContainer);"function"==typeof t.options.onHide&&t.visible&&t.options.onHide.call(t.element,n),t.visible=!1,t.selectedIndex=-1,clearTimeout(t.onChangeTimeout),e(t.suggestionsContainer).hide(),t.signalHint(null)},suggest:function(){if(this.suggestions.length){var t,n=this,o=n.options,i=o.groupBy,s=o.formatResult,a=n.getQuery(n.currentValue),r=n.classes.suggestion,u=n.classes.selected,l=e(n.suggestionsContainer),c=e(n.noSuggestionsContainer),g=o.beforeRender,d="",p=function(e,n){var s=e.data[i];return t===s?"":(t=s,o.formatGroup(e,t))};return o.triggerSelectOnValidInput&&n.isExactMatch(a)?void n.select(0):(e.each(n.suggestions,(function(e,t){i&&(d+=p(t,0)),d+='<div class="'+r+'" data-index="'+e+'">'+s(t,a,e)+"</div>"})),this.adjustContainerWidth(),c.detach(),l.html(d),"function"==typeof g&&g.call(n.element,l,n.suggestions),n.fixPosition(),l.show(),o.autoSelectFirst&&(n.selectedIndex=0,l.scrollTop(0),l.children("."+r).first().addClass(u)),n.visible=!0,void n.findBestHint())}this.options.showNoSuggestionNotice?this.noSuggestions():this.hide()},noSuggestions:function(){var t=this,n=t.options.beforeRender,o=e(t.suggestionsContainer),i=e(t.noSuggestionsContainer);this.adjustContainerWidth(),i.detach(),o.empty(),o.append(i),"function"==typeof n&&n.call(t.element,o,t.suggestions),t.fixPosition(),o.show(),t.visible=!0},adjustContainerWidth:function(){var t,n=this,o=n.options,i=e(n.suggestionsContainer);"auto"===o.width?(t=n.el.outerWidth(),i.css("width",t>0?t:300)):"flex"===o.width&&i.css("width","")},findBestHint:function(){var t=this,n=t.el.val().toLowerCase(),o=null;n&&(e.each(t.suggestions,(function(e,t){var i=0===t.value.toLowerCase().indexOf(n);return i&&(o=t),!i})),t.signalHint(o))},signalHint:function(t){var n="",o=this;t&&(n=o.currentValue+t.value.substr(o.currentValue.length)),o.hintValue!==n&&(o.hintValue=n,o.hint=t,(this.options.onHint||e.noop)(n))},verifySuggestionsFormat:function(t){return t.length&&"string"==typeof t[0]?e.map(t,(function(e){return{value:e,data:null}})):t},validateOrientation:function(t,n){return t=(t||"").trim().toLowerCase(),-1===e.inArray(t,["auto","bottom","top"])&&(t=n),t},processResponse:function(e,t,n){var o=this,i=o.options;e.suggestions=o.verifySuggestionsFormat(e.suggestions),i.noCache||(o.cachedResponse[n]=e,i.preventBadQueries&&!e.suggestions.length&&o.badQueries.push(t)),t===o.getQuery(o.currentValue)&&(o.suggestions=e.suggestions,o.suggest())},activate:function(t){var n,o=this,i=o.classes.selected,s=e(o.suggestionsContainer),a=s.find("."+o.classes.suggestion);return s.find("."+i).removeClass(i),o.selectedIndex=t,-1!==o.selectedIndex&&a.length>o.selectedIndex?(n=a.get(o.selectedIndex),e(n).addClass(i),n):null},selectHint:function(){var t=this,n=e.inArray(t.hint,t.suggestions);t.select(n)},select:function(e){this.hide(),this.onSelect(e)},moveUp:function(){var t=this;if(-1!==t.selectedIndex)return 0===t.selectedIndex?(e(t.suggestionsContainer).children("."+t.classes.suggestion).first().removeClass(t.classes.selected),t.selectedIndex=-1,t.ignoreValueChange=!1,t.el.val(t.currentValue),void t.findBestHint()):void t.adjustScroll(t.selectedIndex-1)},moveDown:function(){var e=this;e.selectedIndex!==e.suggestions.length-1&&e.adjustScroll(e.selectedIndex+1)},adjustScroll:function(t){var n=this,o=n.activate(t);if(o){var i,s,a,r=e(o).outerHeight();i=o.offsetTop,a=(s=e(n.suggestionsContainer).scrollTop())+n.options.maxHeight-r,i<s?e(n.suggestionsContainer).scrollTop(i):i>a&&e(n.suggestionsContainer).scrollTop(i-n.options.maxHeight+r),n.options.preserveInput||(n.ignoreValueChange=!0,n.el.val(n.getValue(n.suggestions[t].value))),n.signalHint(null)}},onSelect:function(e){var t=this,n=t.options.onSelect,o=t.suggestions[e];t.currentValue=t.getValue(o.value),t.currentValue===t.el.val()||t.options.preserveInput||t.el.val(t.currentValue),t.signalHint(null),t.suggestions=[],t.selection=o,"function"==typeof n&&n.call(t.element,o)},getValue:function(e){var t,n,o=this.options.delimiter;return o?1===(n=(t=this.currentValue).split(o)).length?e:t.substr(0,t.length-n[n.length-1].length)+e:e},dispose:function(){var t=this;t.el.off(".autocomplete").removeData("autocomplete"),e(window).off("resize.autocomplete",t.fixPositionCapture),e(t.suggestionsContainer).remove()}},e.fn.devbridgeAutocomplete=function(n,o){var i="autocomplete";return arguments.length?this.each((function(){var s=e(this),a=s.data(i);"string"==typeof n?a&&"function"==typeof a[n]&&a[n](o):(a&&a.dispose&&a.dispose(),a=new t(this,n),s.data(i,a))})):this.first().data(i)},e.fn.autocomplete||(e.fn.autocomplete=e.fn.devbridgeAutocomplete)})),jQuery(document).ready((function(e){"use strict";e(".searchform").each((function(){var t=e(this),n=t.find(".live-search-list"),o=t.find("#cat"),i="undefined"!=typeof theme&&theme.ajax_url?theme.ajax_url:"undefined"!=typeof js_porto_vars&&js_porto_vars.ajax_url?js_porto_vars.ajax_url:ajaxurl,s=i+"?action=porto_ajax_search_posts&nonce="+porto_live_search.nonce;if(o.length&&o.val()&&"0"!=o.val()&&(s+="&cat="+o.val()),t.find('input[name="post_type"]').length&&t.find('input[name="post_type"]').val()&&(s+="&post_type="+t.find('input[name="post_type"]').val()),t.find('input[type="text"]').devbridgeAutocomplete({minChars:3,appendTo:n,triggerSelectOnValidInput:!1,serviceUrl:s,onSearchStart:function(){t.find("button").addClass("loading")},onSelect:function(e){-1!=e.id&&"undefined"!=typeof theme&&(window.location.href=e.url)},onSearchComplete:function(){t.find("button").removeClass("loading")},beforeRender:function(t){e(t).removeAttr("style")},formatResult:function(t,n){var o="("+e.Autocomplete.utils.escapeRegExChars(n)+")",i="";return t.img&&"undefined"!=typeof theme&&(i+='<img class="search-image" src="'+t.img+'">'),i+='<div class="search-name">'+t.value.replace(new RegExp(o,"gi"),"<strong>$1</strong>")+"</div>",t.price&&"undefined"!=typeof theme&&(i+='<span class="search-price">'+t.price+"<span>"),i}}),o.length){var a=t.find('input[type="text"]').devbridgeAutocomplete();o.on("change",(function(e){o.val()&&"0"!=o.val()?a.setOptions({serviceUrl:i+"?action=porto_ajax_search_posts&cat="+o.val()}):a.setOptions({serviceUrl:i+"?action=porto_ajax_search_posts"}),a.hide(),a.onValueChange()}))}}))}));
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(t="undefined"!=typeof globalThis?globalThis:t||self).bootstrap=e()}(this,(function(){"use strict";const t={find:(t,e=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(e,t)),findOne:(t,e=document.documentElement)=>Element.prototype.querySelector.call(e,t),children:(t,e)=>[].concat(...t.children).filter((t=>t.matches(e))),parents(t,e){const n=[];let i=t.parentNode;for(;i&&i.nodeType===Node.ELEMENT_NODE&&3!==i.nodeType;)i.matches(e)&&n.push(i),i=i.parentNode;return n},prev(t,e){let n=t.previousElementSibling;for(;n;){if(n.matches(e))return[n];n=n.previousElementSibling}return[]},next(t,e){let n=t.nextElementSibling;for(;n;){if(n.matches(e))return[n];n=n.nextElementSibling}return[]}},e="transitionend",n=t=>{do{t+=Math.floor(1e6*Math.random())}while(document.getElementById(t));return t},i=t=>{let e=t.getAttribute("data-bs-target");if(!e||"#"===e){let n=t.getAttribute("href");if(!n||!n.includes("#")&&!n.startsWith("."))return null;n.includes("#")&&!n.startsWith("#")&&(n=`#${n.split("#")[1]}`),e=n&&"#"!==n?n.trim():null}return e},s=t=>{const e=i(t);return e&&document.querySelector(e)?e:null},o=t=>{const e=i(t);return e?document.querySelector(e):null},r=t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:n}=window.getComputedStyle(t);const i=Number.parseFloat(e),s=Number.parseFloat(n);return i||s?(e=e.split(",")[0],n=n.split(",")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(n))):0},a=t=>!(!t||"object"!=typeof t)&&(void 0!==t.jquery&&(t=t[0]),void 0!==t.nodeType),l=e=>a(e)?e.jquery?e[0]:e:"string"==typeof e&&e.length>0?t.findOne(e):null,c=(t,n)=>{let i=!1;const s=n+5;t.addEventListener(e,(function n(){i=!0,t.removeEventListener(e,n)})),setTimeout((()=>{i||(t=>{t.dispatchEvent(new Event(e))})(t)}),s)},d=(t,e,n)=>{Object.keys(n).forEach((i=>{const s=n[i],o=e[i],r=o&&a(o)?"element":null==(l=o)?`${l}`:{}.toString.call(l).match(/\s([a-z]+)/i)[1].toLowerCase();var l;if(!new RegExp(s).test(r))throw new TypeError(`${t.toUpperCase()}: Option "${i}" provided type "${r}" but expected type "${s}".`)}))},h=t=>{if(!t)return!1;if(t.style&&t.parentNode&&t.parentNode.style){const e=getComputedStyle(t),n=getComputedStyle(t.parentNode);return"none"!==e.display&&"none"!==n.display&&"hidden"!==e.visibility}return!1},f=t=>!t||t.nodeType!==Node.ELEMENT_NODE||(!!t.classList.contains("disabled")||(void 0!==t.disabled?t.disabled:t.hasAttribute("disabled")&&"false"!==t.getAttribute("disabled"))),u=t=>{if(!document.documentElement.attachShadow)return null;if("function"==typeof t.getRootNode){const e=t.getRootNode();return e instanceof ShadowRoot?e:null}return t instanceof ShadowRoot?t:t.parentNode?u(t.parentNode):null},p=()=>{},m=t=>t.offsetHeight,g=()=>{const{jQuery:t}=window;return t&&!document.body.hasAttribute("data-bs-no-jquery")?t:null},_=()=>"rtl"===document.documentElement.dir,b=t=>{var e;e=()=>{const e=g();if(e){const n=t.NAME,i=e.fn[n];e.fn[n]=t.jQueryInterface,e.fn[n].Constructor=t,e.fn[n].noConflict=()=>(e.fn[n]=i,t.jQueryInterface)}},"loading"===document.readyState?document.addEventListener("DOMContentLoaded",e):e()},v=t=>{"function"==typeof t&&t()},y=new Map;var w={set(t,e,n){y.has(t)||y.set(t,new Map);const i=y.get(t);i.has(e)||0===i.size?i.set(e,n):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(i.keys())[0]}.`)},get:(t,e)=>y.has(t)&&y.get(t).get(e)||null,remove(t,e){if(!y.has(t))return;const n=y.get(t);n.delete(e),0===n.size&&y.delete(t)}};const E=/[^.]*(?=\..*)\.|.*/,T=/\..*/,A=/::\d+$/,O={};let L=1;const C={mouseenter:"mouseover",mouseleave:"mouseout"},k=/^(mouseenter|mouseleave)/i,D=new Set(["click","dblclick","mouseup","mousedown","contextmenu","mousewheel","DOMMouseScroll","mouseover","mouseout","mousemove","selectstart","selectend","keydown","keypress","keyup","orientationchange","touchstart","touchmove","touchend","touchcancel","pointerdown","pointermove","pointerup","pointerleave","pointercancel","gesturestart","gesturechange","gestureend","focus","blur","change","reset","select","submit","focusin","focusout","load","unload","beforeunload","resize","move","DOMContentLoaded","readystatechange","error","abort","scroll"]);function x(t,e){return e&&`${e}::${L++}`||t.uidEvent||L++}function N(t){const e=x(t);return t.uidEvent=e,O[e]=O[e]||{},O[e]}function S(t,e,n=null){const i=Object.keys(t);for(let s=0,o=i.length;s<o;s++){const o=t[i[s]];if(o.originalHandler===e&&o.delegationSelector===n)return o}return null}function j(t,e,n){const i="string"==typeof e,s=i?n:e;let o=I(t);return D.has(o)||(o=t),[i,s,o]}function M(t,e,n,i,s){if("string"!=typeof e||!t)return;if(n||(n=i,i=null),k.test(e)){const t=t=>function(e){if(!e.relatedTarget||e.relatedTarget!==e.delegateTarget&&!e.delegateTarget.contains(e.relatedTarget))return t.call(this,e)};i?i=t(i):n=t(n)}const[o,r,a]=j(e,n,i),l=N(t),c=l[a]||(l[a]={}),d=S(c,r,o?n:null);if(d)return void(d.oneOff=d.oneOff&&s);const h=x(r,e.replace(E,"")),f=o?function(t,e,n){return function i(s){const o=t.querySelectorAll(e);for(let{target:r}=s;r&&r!==this;r=r.parentNode)for(let a=o.length;a--;)if(o[a]===r)return s.delegateTarget=r,i.oneOff&&H.off(t,s.type,e,n),n.apply(r,[s]);return null}}(t,n,i):function(t,e){return function n(i){return i.delegateTarget=t,n.oneOff&&H.off(t,i.type,e),e.apply(t,[i])}}(t,n);f.delegationSelector=o?n:null,f.originalHandler=r,f.oneOff=s,f.uidEvent=h,c[h]=f,t.addEventListener(a,f,o)}function P(t,e,n,i,s){const o=S(e[n],i,s);o&&(t.removeEventListener(n,o,Boolean(s)),delete e[n][o.uidEvent])}function I(t){return t=t.replace(T,""),C[t]||t}const H={on(t,e,n,i){M(t,e,n,i,!1)},one(t,e,n,i){M(t,e,n,i,!0)},off(t,e,n,i){if("string"!=typeof e||!t)return;const[s,o,r]=j(e,n,i),a=r!==e,l=N(t),c=e.startsWith(".");if(void 0!==o){if(!l||!l[r])return;return void P(t,l,r,o,s?n:null)}c&&Object.keys(l).forEach((n=>{!function(t,e,n,i){const s=e[n]||{};Object.keys(s).forEach((o=>{if(o.includes(i)){const i=s[o];P(t,e,n,i.originalHandler,i.delegationSelector)}}))}(t,l,n,e.slice(1))}));const d=l[r]||{};Object.keys(d).forEach((n=>{const i=n.replace(A,"");if(!a||e.includes(i)){const e=d[n];P(t,l,r,e.originalHandler,e.delegationSelector)}}))},trigger(t,e,n){if("string"!=typeof e||!t)return null;const i=g(),s=I(e),o=e!==s,r=D.has(s);let a,l=!0,c=!0,d=!1,h=null;return o&&i&&(a=i.Event(e,n),i(t).trigger(a),l=!a.isPropagationStopped(),c=!a.isImmediatePropagationStopped(),d=a.isDefaultPrevented()),r?(h=document.createEvent("HTMLEvents"),h.initEvent(s,l,!0)):h=new CustomEvent(e,{bubbles:l,cancelable:!0}),void 0!==n&&Object.keys(n).forEach((t=>{Object.defineProperty(h,t,{get:()=>n[t]})})),d&&h.preventDefault(),c&&t.dispatchEvent(h),h.defaultPrevented&&void 0!==a&&a.preventDefault(),h}};class R{constructor(t){(t=l(t))&&(this._element=t,w.set(this._element,this.constructor.DATA_KEY,this))}dispose(){w.remove(this._element,this.constructor.DATA_KEY),H.off(this._element,this.constructor.EVENT_KEY),Object.getOwnPropertyNames(this).forEach((t=>{this[t]=null}))}_queueCallback(t,e,n=!0){if(!n)return void v(t);const i=r(e);H.one(e,"transitionend",(()=>v(t))),c(e,i)}static getInstance(t){return w.get(t,this.DATA_KEY)}static get VERSION(){return"5.0.1"}static get NAME(){throw new Error('You have to implement the static method "NAME", for each component!')}static get DATA_KEY(){return`bs.${this.NAME}`}static get EVENT_KEY(){return`.${this.DATA_KEY}`}}const $="bs.alert";class B extends R{static get NAME(){return"alert"}close(t){const e=t?this._getRootElement(t):this._element,n=this._triggerCloseEvent(e);null===n||n.defaultPrevented||this._removeElement(e)}_getRootElement(t){return o(t)||t.closest(".alert")}_triggerCloseEvent(t){return H.trigger(t,"close.bs.alert")}_removeElement(t){t.classList.remove("show");const e=t.classList.contains("fade");this._queueCallback((()=>this._destroyElement(t)),t,e)}_destroyElement(t){t.parentNode&&t.parentNode.removeChild(t),H.trigger(t,"closed.bs.alert")}static jQueryInterface(t){return this.each((function(){let e=w.get(this,$);e||(e=new B(this)),"close"===t&&e[t](this)}))}static handleDismiss(t){return function(e){e&&e.preventDefault(),t.close(this)}}}H.on(document,"click.bs.alert.data-api",'[data-bs-dismiss="alert"]',B.handleDismiss(new B)),b(B);const W="bs.button",q='[data-bs-toggle="button"]';class z extends R{static get NAME(){return"button"}toggle(){this._element.setAttribute("aria-pressed",this._element.classList.toggle("active"))}static jQueryInterface(t){return this.each((function(){let e=w.get(this,W);e||(e=new z(this)),"toggle"===t&&e[t]()}))}}function U(t){return"true"===t||"false"!==t&&(t===Number(t).toString()?Number(t):""===t||"null"===t?null:t)}function F(t){return t.replace(/[A-Z]/g,(t=>`-${t.toLowerCase()}`))}H.on(document,"click.bs.button.data-api",q,(t=>{t.preventDefault();const e=t.target.closest(q);let n=w.get(e,W);n||(n=new z(e)),n.toggle()})),b(z);const V={setDataAttribute(t,e,n){t.setAttribute(`data-bs-${F(e)}`,n)},removeDataAttribute(t,e){t.removeAttribute(`data-bs-${F(e)}`)},getDataAttributes(t){if(!t)return{};const e={};return Object.keys(t.dataset).filter((t=>t.startsWith("bs"))).forEach((n=>{let i=n.replace(/^bs/,"");i=i.charAt(0).toLowerCase()+i.slice(1,i.length),e[i]=U(t.dataset[n])})),e},getDataAttribute:(t,e)=>U(t.getAttribute(`data-bs-${F(e)}`)),offset(t){const e=t.getBoundingClientRect();return{top:e.top+document.body.scrollTop,left:e.left+document.body.scrollLeft}},position:t=>({top:t.offsetTop,left:t.offsetLeft})},K="collapse",Y="bs.collapse",Q={toggle:!0,parent:""},G={toggle:"boolean",parent:"(string|element)"},X="show",Z="collapse",J="collapsing",tt="collapsed",et="width",nt='[data-bs-toggle="collapse"]';class it extends R{constructor(e,n){super(e),this._isTransitioning=!1,this._config=this._getConfig(n),this._triggerArray=t.find(`${nt}[href="#${this._element.id}"],${nt}[data-bs-target="#${this._element.id}"]`);const i=t.find(nt);for(let e=0,n=i.length;e<n;e++){const n=i[e],o=s(n),r=t.find(o).filter((t=>t===this._element));null!==o&&r.length&&(this._selector=o,this._triggerArray.push(n))}this._parent=this._config.parent?this._getParent():null,this._config.parent||this._addAriaAndCollapsedClass(this._element,this._triggerArray),this._config.toggle&&this.toggle()}static get Default(){return Q}static get NAME(){return K}toggle(){this._element.classList.contains(X)?this.hide():this.show()}show(){if(this._isTransitioning||this._element.classList.contains(X))return;let e,n;this._parent&&(e=t.find(".show, .collapsing",this._parent).filter((t=>"string"==typeof this._config.parent?t.getAttribute("data-bs-parent")===this._config.parent:t.classList.contains(Z))),0===e.length&&(e=null));const i=t.findOne(this._selector);if(e){const t=e.find((t=>i!==t));if(n=t?w.get(t,Y):null,n&&n._isTransitioning)return}if(H.trigger(this._element,"show.bs.collapse").defaultPrevented)return;e&&e.forEach((t=>{i!==t&&it.collapseInterface(t,"hide"),n||w.set(t,Y,null)}));const s=this._getDimension();this._element.classList.remove(Z),this._element.classList.add(J),this._element.style[s]=0,this._triggerArray.length&&this._triggerArray.forEach((t=>{t.classList.remove(tt),t.setAttribute("aria-expanded",!0)})),this.setTransitioning(!0);const o=`scroll${s[0].toUpperCase()+s.slice(1)}`;this._queueCallback((()=>{this._element.classList.remove(J),this._element.classList.add(Z,X),this._element.style[s]="",this.setTransitioning(!1),H.trigger(this._element,"shown.bs.collapse")}),this._element,!0),this._element.style[s]=`${this._element[o]}px`}hide(){if(this._isTransitioning||!this._element.classList.contains(X))return;if(H.trigger(this._element,"hide.bs.collapse").defaultPrevented)return;const t=this._getDimension();this._element.style[t]=`${this._element.getBoundingClientRect()[t]}px`,m(this._element),this._element.classList.add(J),this._element.classList.remove(Z,X);const e=this._triggerArray.length;if(e>0)for(let t=0;t<e;t++){const e=this._triggerArray[t],n=o(e);n&&!n.classList.contains(X)&&(e.classList.add(tt),e.setAttribute("aria-expanded",!1))}this.setTransitioning(!0);this._element.style[t]="",this._queueCallback((()=>{this.setTransitioning(!1),this._element.classList.remove(J),this._element.classList.add(Z),H.trigger(this._element,"hidden.bs.collapse")}),this._element,!0)}setTransitioning(t){this._isTransitioning=t}_getConfig(t){return(t={...Q,...t}).toggle=Boolean(t.toggle),d(K,t,G),t}_getDimension(){return this._element.classList.contains(et)?et:"height"}_getParent(){let{parent:e}=this._config;e=l(e);const n=`${nt}[data-bs-parent="${e}"]`;return t.find(n,e).forEach((t=>{const e=o(t);this._addAriaAndCollapsedClass(e,[t])})),e}_addAriaAndCollapsedClass(t,e){if(!t||!e.length)return;const n=t.classList.contains(X);e.forEach((t=>{n?t.classList.remove(tt):t.classList.add(tt),t.setAttribute("aria-expanded",n)}))}static collapseInterface(t,e){let n=w.get(t,Y);const i={...Q,...V.getDataAttributes(t),..."object"==typeof e&&e?e:{}};if(!n&&i.toggle&&"string"==typeof e&&/show|hide/.test(e)&&(i.toggle=!1),n||(n=new it(t,i)),"string"==typeof e){if(void 0===n[e])throw new TypeError(`No method named "${e}"`);n[e]()}}static jQueryInterface(t){return this.each((function(){it.collapseInterface(this,t)}))}}H.on(document,"click.bs.collapse.data-api",nt,(function(e){("A"===e.target.tagName||e.delegateTarget&&"A"===e.delegateTarget.tagName)&&e.preventDefault();const n=V.getDataAttributes(this),i=s(this);t.find(i).forEach((t=>{const e=w.get(t,Y);let i;e?(null===e._parent&&"string"==typeof n.parent&&(e._config.parent=n.parent,e._parent=e._getParent()),i="toggle"):i=n,it.collapseInterface(t,i)}))})),b(it);var st="top",ot="bottom",rt="right",at="left",lt="auto",ct=[st,ot,rt,at],dt="start",ht="end",ft="clippingParents",ut="viewport",pt="popper",mt="reference",gt=ct.reduce((function(t,e){return t.concat([e+"-"+dt,e+"-"+ht])}),[]),_t=[].concat(ct,[lt]).reduce((function(t,e){return t.concat([e,e+"-"+dt,e+"-"+ht])}),[]),bt="beforeRead",vt="read",yt="afterRead",wt="beforeMain",Et="main",Tt="afterMain",At="beforeWrite",Ot="write",Lt="afterWrite",Ct=[bt,vt,yt,wt,Et,Tt,At,Ot,Lt];function kt(t){return t?(t.nodeName||"").toLowerCase():null}function Dt(t){if(null==t)return window;if("[object Window]"!==t.toString()){var e=t.ownerDocument;return e&&e.defaultView||window}return t}function xt(t){return t instanceof Dt(t).Element||t instanceof Element}function Nt(t){return t instanceof Dt(t).HTMLElement||t instanceof HTMLElement}function St(t){return"undefined"!=typeof ShadowRoot&&(t instanceof Dt(t).ShadowRoot||t instanceof ShadowRoot)}var jt={name:"applyStyles",enabled:!0,phase:"write",fn:function(t){var e=t.state;Object.keys(e.elements).forEach((function(t){var n=e.styles[t]||{},i=e.attributes[t]||{},s=e.elements[t];Nt(s)&&kt(s)&&(Object.assign(s.style,n),Object.keys(i).forEach((function(t){var e=i[t];!1===e?s.removeAttribute(t):s.setAttribute(t,!0===e?"":e)})))}))},effect:function(t){var e=t.state,n={popper:{position:e.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(e.elements.popper.style,n.popper),e.styles=n,e.elements.arrow&&Object.assign(e.elements.arrow.style,n.arrow),function(){Object.keys(e.elements).forEach((function(t){var i=e.elements[t],s=e.attributes[t]||{},o=Object.keys(e.styles.hasOwnProperty(t)?e.styles[t]:n[t]).reduce((function(t,e){return t[e]="",t}),{});Nt(i)&&kt(i)&&(Object.assign(i.style,o),Object.keys(s).forEach((function(t){i.removeAttribute(t)})))}))}},requires:["computeStyles"]};function Mt(t){return t.split("-")[0]}function Pt(t){var e=t.getBoundingClientRect();return{width:e.width,height:e.height,top:e.top,right:e.right,bottom:e.bottom,left:e.left,x:e.left,y:e.top}}function It(t){var e=Pt(t),n=t.offsetWidth,i=t.offsetHeight;return Math.abs(e.width-n)<=1&&(n=e.width),Math.abs(e.height-i)<=1&&(i=e.height),{x:t.offsetLeft,y:t.offsetTop,width:n,height:i}}function Ht(t,e){var n=e.getRootNode&&e.getRootNode();if(t.contains(e))return!0;if(n&&St(n)){var i=e;do{if(i&&t.isSameNode(i))return!0;i=i.parentNode||i.host}while(i)}return!1}function Rt(t){return Dt(t).getComputedStyle(t)}function $t(t){return["table","td","th"].indexOf(kt(t))>=0}function Bt(t){return((xt(t)?t.ownerDocument:t.document)||window.document).documentElement}function Wt(t){return"html"===kt(t)?t:t.assignedSlot||t.parentNode||(St(t)?t.host:null)||Bt(t)}function qt(t){return Nt(t)&&"fixed"!==Rt(t).position?t.offsetParent:null}function zt(t){for(var e=Dt(t),n=qt(t);n&&$t(n)&&"static"===Rt(n).position;)n=qt(n);return n&&("html"===kt(n)||"body"===kt(n)&&"static"===Rt(n).position)?e:n||function(t){var e=-1!==navigator.userAgent.toLowerCase().indexOf("firefox");if(-1!==navigator.userAgent.indexOf("Trident")&&Nt(t)&&"fixed"===Rt(t).position)return null;for(var n=Wt(t);Nt(n)&&["html","body"].indexOf(kt(n))<0;){var i=Rt(n);if("none"!==i.transform||"none"!==i.perspective||"paint"===i.contain||-1!==["transform","perspective"].indexOf(i.willChange)||e&&"filter"===i.willChange||e&&i.filter&&"none"!==i.filter)return n;n=n.parentNode}return null}(t)||e}function Ut(t){return["top","bottom"].indexOf(t)>=0?"x":"y"}var Ft=Math.max,Vt=Math.min,Kt=Math.round;function Yt(t,e,n){return Ft(t,Vt(e,n))}function Qt(t){return Object.assign({},{top:0,right:0,bottom:0,left:0},t)}function Gt(t,e){return e.reduce((function(e,n){return e[n]=t,e}),{})}var Xt={name:"arrow",enabled:!0,phase:"main",fn:function(t){var e,n=t.state,i=t.name,s=t.options,o=n.elements.arrow,r=n.modifiersData.popperOffsets,a=Mt(n.placement),l=Ut(a),c=[at,rt].indexOf(a)>=0?"height":"width";if(o&&r){var d=function(t,e){return Qt("number"!=typeof(t="function"==typeof t?t(Object.assign({},e.rects,{placement:e.placement})):t)?t:Gt(t,ct))}(s.padding,n),h=It(o),f="y"===l?st:at,u="y"===l?ot:rt,p=n.rects.reference[c]+n.rects.reference[l]-r[l]-n.rects.popper[c],m=r[l]-n.rects.reference[l],g=zt(o),_=g?"y"===l?g.clientHeight||0:g.clientWidth||0:0,b=p/2-m/2,v=d[f],y=_-h[c]-d[u],w=_/2-h[c]/2+b,E=Yt(v,w,y),T=l;n.modifiersData[i]=((e={})[T]=E,e.centerOffset=E-w,e)}},effect:function(t){var e=t.state,n=t.options.element,i=void 0===n?"[data-popper-arrow]":n;null!=i&&("string"!=typeof i||(i=e.elements.popper.querySelector(i)))&&Ht(e.elements.popper,i)&&(e.elements.arrow=i)},requires:["popperOffsets"],requiresIfExists:["preventOverflow"]},Zt={top:"auto",right:"auto",bottom:"auto",left:"auto"};function Jt(t){var e,n=t.popper,i=t.popperRect,s=t.placement,o=t.offsets,r=t.position,a=t.gpuAcceleration,l=t.adaptive,c=t.roundOffsets,d=!0===c?function(t){var e=t.x,n=t.y,i=window.devicePixelRatio||1;return{x:Kt(Kt(e*i)/i)||0,y:Kt(Kt(n*i)/i)||0}}(o):"function"==typeof c?c(o):o,h=d.x,f=void 0===h?0:h,u=d.y,p=void 0===u?0:u,m=o.hasOwnProperty("x"),g=o.hasOwnProperty("y"),_=at,b=st,v=window;if(l){var y=zt(n),w="clientHeight",E="clientWidth";y===Dt(n)&&"static"!==Rt(y=Bt(n)).position&&(w="scrollHeight",E="scrollWidth"),y=y,s===st&&(b=ot,p-=y[w]-i.height,p*=a?1:-1),s===at&&(_=rt,f-=y[E]-i.width,f*=a?1:-1)}var T,A=Object.assign({position:r},l&&Zt);return a?Object.assign({},A,((T={})[b]=g?"0":"",T[_]=m?"0":"",T.transform=(v.devicePixelRatio||1)<2?"translate("+f+"px, "+p+"px)":"translate3d("+f+"px, "+p+"px, 0)",T)):Object.assign({},A,((e={})[b]=g?p+"px":"",e[_]=m?f+"px":"",e.transform="",e))}var te={name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:function(t){var e=t.state,n=t.options,i=n.gpuAcceleration,s=void 0===i||i,o=n.adaptive,r=void 0===o||o,a=n.roundOffsets,l=void 0===a||a,c={placement:Mt(e.placement),popper:e.elements.popper,popperRect:e.rects.popper,gpuAcceleration:s};null!=e.modifiersData.popperOffsets&&(e.styles.popper=Object.assign({},e.styles.popper,Jt(Object.assign({},c,{offsets:e.modifiersData.popperOffsets,position:e.options.strategy,adaptive:r,roundOffsets:l})))),null!=e.modifiersData.arrow&&(e.styles.arrow=Object.assign({},e.styles.arrow,Jt(Object.assign({},c,{offsets:e.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:l})))),e.attributes.popper=Object.assign({},e.attributes.popper,{"data-popper-placement":e.placement})},data:{}},ee={passive:!0};var ne={name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:function(t){var e=t.state,n=t.instance,i=t.options,s=i.scroll,o=void 0===s||s,r=i.resize,a=void 0===r||r,l=Dt(e.elements.popper),c=[].concat(e.scrollParents.reference,e.scrollParents.popper);return o&&c.forEach((function(t){t.addEventListener("scroll",n.update,ee)})),a&&l.addEventListener("resize",n.update,ee),function(){o&&c.forEach((function(t){t.removeEventListener("scroll",n.update,ee)})),a&&l.removeEventListener("resize",n.update,ee)}},data:{}},ie={left:"right",right:"left",bottom:"top",top:"bottom"};function se(t){return t.replace(/left|right|bottom|top/g,(function(t){return ie[t]}))}var oe={start:"end",end:"start"};function re(t){return t.replace(/start|end/g,(function(t){return oe[t]}))}function ae(t){var e=Dt(t);return{scrollLeft:e.pageXOffset,scrollTop:e.pageYOffset}}function le(t){return Pt(Bt(t)).left+ae(t).scrollLeft}function ce(t){var e=Rt(t),n=e.overflow,i=e.overflowX,s=e.overflowY;return/auto|scroll|overlay|hidden/.test(n+s+i)}function de(t){return["html","body","#document"].indexOf(kt(t))>=0?t.ownerDocument.body:Nt(t)&&ce(t)?t:de(Wt(t))}function he(t,e){var n;void 0===e&&(e=[]);var i=de(t),s=i===(null==(n=t.ownerDocument)?void 0:n.body),o=Dt(i),r=s?[o].concat(o.visualViewport||[],ce(i)?i:[]):i,a=e.concat(r);return s?a:a.concat(he(Wt(r)))}function fe(t){return Object.assign({},t,{left:t.x,top:t.y,right:t.x+t.width,bottom:t.y+t.height})}function ue(t,e){return e===ut?fe(function(t){var e=Dt(t),n=Bt(t),i=e.visualViewport,s=n.clientWidth,o=n.clientHeight,r=0,a=0;return i&&(s=i.width,o=i.height,/^((?!chrome|android).)*safari/i.test(navigator.userAgent)||(r=i.offsetLeft,a=i.offsetTop)),{width:s,height:o,x:r+le(t),y:a}}(t)):Nt(e)?function(t){var e=Pt(t);return e.top=e.top+t.clientTop,e.left=e.left+t.clientLeft,e.bottom=e.top+t.clientHeight,e.right=e.left+t.clientWidth,e.width=t.clientWidth,e.height=t.clientHeight,e.x=e.left,e.y=e.top,e}(e):fe(function(t){var e,n=Bt(t),i=ae(t),s=null==(e=t.ownerDocument)?void 0:e.body,o=Ft(n.scrollWidth,n.clientWidth,s?s.scrollWidth:0,s?s.clientWidth:0),r=Ft(n.scrollHeight,n.clientHeight,s?s.scrollHeight:0,s?s.clientHeight:0),a=-i.scrollLeft+le(t),l=-i.scrollTop;return"rtl"===Rt(s||n).direction&&(a+=Ft(n.clientWidth,s?s.clientWidth:0)-o),{width:o,height:r,x:a,y:l}}(Bt(t)))}function pe(t,e,n){var i="clippingParents"===e?function(t){var e=he(Wt(t)),n=["absolute","fixed"].indexOf(Rt(t).position)>=0&&Nt(t)?zt(t):t;return xt(n)?e.filter((function(t){return xt(t)&&Ht(t,n)&&"body"!==kt(t)})):[]}(t):[].concat(e),s=[].concat(i,[n]),o=s[0],r=s.reduce((function(e,n){var i=ue(t,n);return e.top=Ft(i.top,e.top),e.right=Vt(i.right,e.right),e.bottom=Vt(i.bottom,e.bottom),e.left=Ft(i.left,e.left),e}),ue(t,o));return r.width=r.right-r.left,r.height=r.bottom-r.top,r.x=r.left,r.y=r.top,r}function me(t){return t.split("-")[1]}function ge(t){var e,n=t.reference,i=t.element,s=t.placement,o=s?Mt(s):null,r=s?me(s):null,a=n.x+n.width/2-i.width/2,l=n.y+n.height/2-i.height/2;switch(o){case st:e={x:a,y:n.y-i.height};break;case ot:e={x:a,y:n.y+n.height};break;case rt:e={x:n.x+n.width,y:l};break;case at:e={x:n.x-i.width,y:l};break;default:e={x:n.x,y:n.y}}var c=o?Ut(o):null;if(null!=c){var d="y"===c?"height":"width";switch(r){case dt:e[c]=e[c]-(n[d]/2-i[d]/2);break;case ht:e[c]=e[c]+(n[d]/2-i[d]/2)}}return e}function _e(t,e){void 0===e&&(e={});var n=e,i=n.placement,s=void 0===i?t.placement:i,o=n.boundary,r=void 0===o?ft:o,a=n.rootBoundary,l=void 0===a?ut:a,c=n.elementContext,d=void 0===c?pt:c,h=n.altBoundary,f=void 0!==h&&h,u=n.padding,p=void 0===u?0:u,m=Qt("number"!=typeof p?p:Gt(p,ct)),g=d===pt?mt:pt,_=t.elements.reference,b=t.rects.popper,v=t.elements[f?g:d],y=pe(xt(v)?v:v.contextElement||Bt(t.elements.popper),r,l),w=Pt(_),E=ge({reference:w,element:b,strategy:"absolute",placement:s}),T=fe(Object.assign({},b,E)),A=d===pt?T:w,O={top:y.top-A.top+m.top,bottom:A.bottom-y.bottom+m.bottom,left:y.left-A.left+m.left,right:A.right-y.right+m.right},L=t.modifiersData.offset;if(d===pt&&L){var C=L[s];Object.keys(O).forEach((function(t){var e=[rt,ot].indexOf(t)>=0?1:-1,n=[st,ot].indexOf(t)>=0?"y":"x";O[t]+=C[n]*e}))}return O}function be(t,e){void 0===e&&(e={});var n=e,i=n.placement,s=n.boundary,o=n.rootBoundary,r=n.padding,a=n.flipVariations,l=n.allowedAutoPlacements,c=void 0===l?_t:l,d=me(i),h=d?a?gt:gt.filter((function(t){return me(t)===d})):ct,f=h.filter((function(t){return c.indexOf(t)>=0}));0===f.length&&(f=h);var u=f.reduce((function(e,n){return e[n]=_e(t,{placement:n,boundary:s,rootBoundary:o,padding:r})[Mt(n)],e}),{});return Object.keys(u).sort((function(t,e){return u[t]-u[e]}))}var ve={name:"flip",enabled:!0,phase:"main",fn:function(t){var e=t.state,n=t.options,i=t.name;if(!e.modifiersData[i]._skip){for(var s=n.mainAxis,o=void 0===s||s,r=n.altAxis,a=void 0===r||r,l=n.fallbackPlacements,c=n.padding,d=n.boundary,h=n.rootBoundary,f=n.altBoundary,u=n.flipVariations,p=void 0===u||u,m=n.allowedAutoPlacements,g=e.options.placement,_=Mt(g),b=l||(_===g||!p?[se(g)]:function(t){if(Mt(t)===lt)return[];var e=se(t);return[re(t),e,re(e)]}(g)),v=[g].concat(b).reduce((function(t,n){return t.concat(Mt(n)===lt?be(e,{placement:n,boundary:d,rootBoundary:h,padding:c,flipVariations:p,allowedAutoPlacements:m}):n)}),[]),y=e.rects.reference,w=e.rects.popper,E=new Map,T=!0,A=v[0],O=0;O<v.length;O++){var L=v[O],C=Mt(L),k=me(L)===dt,D=[st,ot].indexOf(C)>=0,x=D?"width":"height",N=_e(e,{placement:L,boundary:d,rootBoundary:h,altBoundary:f,padding:c}),S=D?k?rt:at:k?ot:st;y[x]>w[x]&&(S=se(S));var j=se(S),M=[];if(o&&M.push(N[C]<=0),a&&M.push(N[S]<=0,N[j]<=0),M.every((function(t){return t}))){A=L,T=!1;break}E.set(L,M)}if(T)for(var P=function(t){var e=v.find((function(e){var n=E.get(e);if(n)return n.slice(0,t).every((function(t){return t}))}));if(e)return A=e,"break"},I=p?3:1;I>0;I--){if("break"===P(I))break}e.placement!==A&&(e.modifiersData[i]._skip=!0,e.placement=A,e.reset=!0)}},requiresIfExists:["offset"],data:{_skip:!1}};function ye(t,e,n){return void 0===n&&(n={x:0,y:0}),{top:t.top-e.height-n.y,right:t.right-e.width+n.x,bottom:t.bottom-e.height+n.y,left:t.left-e.width-n.x}}function we(t){return[st,rt,ot,at].some((function(e){return t[e]>=0}))}var Ee={name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:function(t){var e=t.state,n=t.name,i=e.rects.reference,s=e.rects.popper,o=e.modifiersData.preventOverflow,r=_e(e,{elementContext:"reference"}),a=_e(e,{altBoundary:!0}),l=ye(r,i),c=ye(a,s,o),d=we(l),h=we(c);e.modifiersData[n]={referenceClippingOffsets:l,popperEscapeOffsets:c,isReferenceHidden:d,hasPopperEscaped:h},e.attributes.popper=Object.assign({},e.attributes.popper,{"data-popper-reference-hidden":d,"data-popper-escaped":h})}};var Te={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:function(t){var e=t.state,n=t.options,i=t.name,s=n.offset,o=void 0===s?[0,0]:s,r=_t.reduce((function(t,n){return t[n]=function(t,e,n){var i=Mt(t),s=[at,st].indexOf(i)>=0?-1:1,o="function"==typeof n?n(Object.assign({},e,{placement:t})):n,r=o[0],a=o[1];return r=r||0,a=(a||0)*s,[at,rt].indexOf(i)>=0?{x:a,y:r}:{x:r,y:a}}(n,e.rects,o),t}),{}),a=r[e.placement],l=a.x,c=a.y;null!=e.modifiersData.popperOffsets&&(e.modifiersData.popperOffsets.x+=l,e.modifiersData.popperOffsets.y+=c),e.modifiersData[i]=r}};var Ae={name:"popperOffsets",enabled:!0,phase:"read",fn:function(t){var e=t.state,n=t.name;e.modifiersData[n]=ge({reference:e.rects.reference,element:e.rects.popper,strategy:"absolute",placement:e.placement})},data:{}};var Oe={name:"preventOverflow",enabled:!0,phase:"main",fn:function(t){var e=t.state,n=t.options,i=t.name,s=n.mainAxis,o=void 0===s||s,r=n.altAxis,a=void 0!==r&&r,l=n.boundary,c=n.rootBoundary,d=n.altBoundary,h=n.padding,f=n.tether,u=void 0===f||f,p=n.tetherOffset,m=void 0===p?0:p,g=_e(e,{boundary:l,rootBoundary:c,padding:h,altBoundary:d}),_=Mt(e.placement),b=me(e.placement),v=!b,y=Ut(_),w="x"===y?"y":"x",E=e.modifiersData.popperOffsets,T=e.rects.reference,A=e.rects.popper,O="function"==typeof m?m(Object.assign({},e.rects,{placement:e.placement})):m,L={x:0,y:0};if(E){if(o||a){var C="y"===y?st:at,k="y"===y?ot:rt,D="y"===y?"height":"width",x=E[y],N=E[y]+g[C],S=E[y]-g[k],j=u?-A[D]/2:0,M=b===dt?T[D]:A[D],P=b===dt?-A[D]:-T[D],I=e.elements.arrow,H=u&&I?It(I):{width:0,height:0},R=e.modifiersData["arrow#persistent"]?e.modifiersData["arrow#persistent"].padding:{top:0,right:0,bottom:0,left:0},$=R[C],B=R[k],W=Yt(0,T[D],H[D]),q=v?T[D]/2-j-W-$-O:M-W-$-O,z=v?-T[D]/2+j+W+B+O:P+W+B+O,U=e.elements.arrow&&zt(e.elements.arrow),F=U?"y"===y?U.clientTop||0:U.clientLeft||0:0,V=e.modifiersData.offset?e.modifiersData.offset[e.placement][y]:0,K=E[y]+q-V-F,Y=E[y]+z-V;if(o){var Q=Yt(u?Vt(N,K):N,x,u?Ft(S,Y):S);E[y]=Q,L[y]=Q-x}if(a){var G="x"===y?st:at,X="x"===y?ot:rt,Z=E[w],J=Z+g[G],tt=Z-g[X],et=Yt(u?Vt(J,K):J,Z,u?Ft(tt,Y):tt);E[w]=et,L[w]=et-Z}}e.modifiersData[i]=L}},requiresIfExists:["offset"]};function Le(t,e,n){void 0===n&&(n=!1);var i,s,o=Bt(e),r=Pt(t),a=Nt(e),l={scrollLeft:0,scrollTop:0},c={x:0,y:0};return(a||!a&&!n)&&(("body"!==kt(e)||ce(o))&&(l=(i=e)!==Dt(i)&&Nt(i)?{scrollLeft:(s=i).scrollLeft,scrollTop:s.scrollTop}:ae(i)),Nt(e)?((c=Pt(e)).x+=e.clientLeft,c.y+=e.clientTop):o&&(c.x=le(o))),{x:r.left+l.scrollLeft-c.x,y:r.top+l.scrollTop-c.y,width:r.width,height:r.height}}function Ce(t){var e=new Map,n=new Set,i=[];function s(t){n.add(t.name),[].concat(t.requires||[],t.requiresIfExists||[]).forEach((function(t){if(!n.has(t)){var i=e.get(t);i&&s(i)}})),i.push(t)}return t.forEach((function(t){e.set(t.name,t)})),t.forEach((function(t){n.has(t.name)||s(t)})),i}var ke={placement:"bottom",modifiers:[],strategy:"absolute"};function De(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return!e.some((function(t){return!(t&&"function"==typeof t.getBoundingClientRect)}))}function xe(t){void 0===t&&(t={});var e=t,n=e.defaultModifiers,i=void 0===n?[]:n,s=e.defaultOptions,o=void 0===s?ke:s;return function(t,e,n){void 0===n&&(n=o);var s,r,a={placement:"bottom",orderedModifiers:[],options:Object.assign({},ke,o),modifiersData:{},elements:{reference:t,popper:e},attributes:{},styles:{}},l=[],c=!1,d={state:a,setOptions:function(n){h(),a.options=Object.assign({},o,a.options,n),a.scrollParents={reference:xt(t)?he(t):t.contextElement?he(t.contextElement):[],popper:he(e)};var s,r,c=function(t){var e=Ce(t);return Ct.reduce((function(t,n){return t.concat(e.filter((function(t){return t.phase===n})))}),[])}((s=[].concat(i,a.options.modifiers),r=s.reduce((function(t,e){var n=t[e.name];return t[e.name]=n?Object.assign({},n,e,{options:Object.assign({},n.options,e.options),data:Object.assign({},n.data,e.data)}):e,t}),{}),Object.keys(r).map((function(t){return r[t]}))));return a.orderedModifiers=c.filter((function(t){return t.enabled})),a.orderedModifiers.forEach((function(t){var e=t.name,n=t.options,i=void 0===n?{}:n,s=t.effect;if("function"==typeof s){var o=s({state:a,name:e,instance:d,options:i}),r=function(){};l.push(o||r)}})),d.update()},forceUpdate:function(){if(!c){var t=a.elements,e=t.reference,n=t.popper;if(De(e,n)){a.rects={reference:Le(e,zt(n),"fixed"===a.options.strategy),popper:It(n)},a.reset=!1,a.placement=a.options.placement,a.orderedModifiers.forEach((function(t){return a.modifiersData[t.name]=Object.assign({},t.data)}));for(var i=0;i<a.orderedModifiers.length;i++)if(!0!==a.reset){var s=a.orderedModifiers[i],o=s.fn,r=s.options,l=void 0===r?{}:r,h=s.name;"function"==typeof o&&(a=o({state:a,options:l,name:h,instance:d})||a)}else a.reset=!1,i=-1}}},update:(s=function(){return new Promise((function(t){d.forceUpdate(),t(a)}))},function(){return r||(r=new Promise((function(t){Promise.resolve().then((function(){r=void 0,t(s())}))}))),r}),destroy:function(){h(),c=!0}};if(!De(t,e))return d;function h(){l.forEach((function(t){return t()})),l=[]}return d.setOptions(n).then((function(t){!c&&n.onFirstUpdate&&n.onFirstUpdate(t)})),d}}var Ne=xe(),Se=xe({defaultModifiers:[ne,Ae,te,jt]}),je=xe({defaultModifiers:[ne,Ae,te,jt,Te,ve,Oe,Xt,Ee]}),Me=Object.freeze({__proto__:null,popperGenerator:xe,detectOverflow:_e,createPopperBase:Ne,createPopper:je,createPopperLite:Se,top:st,bottom:ot,right:rt,left:at,auto:lt,basePlacements:ct,start:dt,end:ht,clippingParents:ft,viewport:ut,popper:pt,reference:mt,variationPlacements:gt,placements:_t,beforeRead:bt,read:vt,afterRead:yt,beforeMain:wt,main:Et,afterMain:Tt,beforeWrite:At,write:Ot,afterWrite:Lt,modifierPhases:Ct,applyStyles:jt,arrow:Xt,computeStyles:te,eventListeners:ne,flip:ve,hide:Ee,offset:Te,popperOffsets:Ae,preventOverflow:Oe});const Pe="dropdown",Ie="bs.dropdown",He="Escape",Re="Space",$e="ArrowUp",Be="ArrowDown",We=new RegExp("ArrowUp|ArrowDown|Escape"),qe="click.bs.dropdown.data-api",ze="keydown.bs.dropdown.data-api",Ue="show",Fe='[data-bs-toggle="dropdown"]',Ve=".dropdown-menu",Ke=_()?"top-end":"top-start",Ye=_()?"top-start":"top-end",Qe=_()?"bottom-end":"bottom-start",Ge=_()?"bottom-start":"bottom-end",Xe=_()?"left-start":"right-start",Ze=_()?"right-start":"left-start",Je={offset:[0,2],boundary:"clippingParents",reference:"toggle",display:"dynamic",popperConfig:null,autoClose:!0},tn={offset:"(array|string|function)",boundary:"(string|element)",reference:"(string|element|object)",display:"string",popperConfig:"(null|object|function)",autoClose:"(boolean|string)"};class en extends R{constructor(t,e){super(t),this._popper=null,this._config=this._getConfig(e),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar(),this._addEventListeners()}static get Default(){return Je}static get DefaultType(){return tn}static get NAME(){return Pe}toggle(){if(f(this._element))return;this._element.classList.contains(Ue)?this.hide():this.show()}show(){if(f(this._element)||this._menu.classList.contains(Ue))return;const t=en.getParentFromElement(this._element),e={relatedTarget:this._element};if(!H.trigger(this._element,"show.bs.dropdown",e).defaultPrevented){if(this._inNavbar)V.setDataAttribute(this._menu,"popper","none");else{if(void 0===Me)throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org)");let e=this._element;"parent"===this._config.reference?e=t:a(this._config.reference)?e=l(this._config.reference):"object"==typeof this._config.reference&&(e=this._config.reference);const n=this._getPopperConfig(),i=n.modifiers.find((t=>"applyStyles"===t.name&&!1===t.enabled));this._popper=je(e,this._menu,n),i&&V.setDataAttribute(this._menu,"popper","static")}"ontouchstart"in document.documentElement&&!t.closest(".navbar-nav")&&[].concat(...document.body.children).forEach((t=>H.on(t,"mouseover",p))),this._element.focus(),this._element.setAttribute("aria-expanded",!0),this._menu.classList.toggle(Ue),this._element.classList.toggle(Ue),H.trigger(this._element,"shown.bs.dropdown",e)}}hide(){if(f(this._element)||!this._menu.classList.contains(Ue))return;const t={relatedTarget:this._element};this._completeHide(t)}dispose(){this._popper&&this._popper.destroy(),super.dispose()}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update()}_addEventListeners(){H.on(this._element,"click.bs.dropdown",(t=>{t.preventDefault(),this.toggle()}))}_completeHide(t){H.trigger(this._element,"hide.bs.dropdown",t).defaultPrevented||("ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((t=>H.off(t,"mouseover",p))),this._popper&&this._popper.destroy(),this._menu.classList.remove(Ue),this._element.classList.remove(Ue),this._element.setAttribute("aria-expanded","false"),V.removeDataAttribute(this._menu,"popper"),H.trigger(this._element,"hidden.bs.dropdown",t))}_getConfig(t){if(t={...this.constructor.Default,...V.getDataAttributes(this._element),...t},d(Pe,t,this.constructor.DefaultType),"object"==typeof t.reference&&!a(t.reference)&&"function"!=typeof t.reference.getBoundingClientRect)throw new TypeError(`${Pe.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.`);return t}_getMenuElement(){return t.next(this._element,Ve)[0]}_getPlacement(){const t=this._element.parentNode;if(t.classList.contains("dropend"))return Xe;if(t.classList.contains("dropstart"))return Ze;const e="end"===getComputedStyle(this._menu).getPropertyValue("--bs-position").trim();return t.classList.contains("dropup")?e?Ye:Ke:e?Ge:Qe}_detectNavbar(){return null!==this._element.closest(".navbar")}_getOffset(){const{offset:t}=this._config;return"string"==typeof t?t.split(",").map((t=>Number.parseInt(t,10))):"function"==typeof t?e=>t(e,this._element):t}_getPopperConfig(){const t={placement:this._getPlacement(),modifiers:[{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"offset",options:{offset:this._getOffset()}}]};return"static"===this._config.display&&(t.modifiers=[{name:"applyStyles",enabled:!1}]),{...t,..."function"==typeof this._config.popperConfig?this._config.popperConfig(t):this._config.popperConfig}}_selectMenuItem(e){const n=t.find(".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)",this._menu).filter(h);if(!n.length)return;let i=n.indexOf(e.target);e.key===$e&&i>0&&i--,e.key===Be&&i<n.length-1&&i++,i=-1===i?0:i,n[i].focus()}static dropdownInterface(t,e){let n=w.get(t,Ie);if(n||(n=new en(t,"object"==typeof e?e:null)),"string"==typeof e){if(void 0===n[e])throw new TypeError(`No method named "${e}"`);n[e]()}}static jQueryInterface(t){return this.each((function(){en.dropdownInterface(this,t)}))}static clearMenus(e){if(e&&(2===e.button||"keyup"===e.type&&"Tab"!==e.key))return;const n=t.find(Fe);for(let t=0,i=n.length;t<i;t++){const i=w.get(n[t],Ie);if(!i||!1===i._config.autoClose)continue;if(!i._element.classList.contains(Ue))continue;const s={relatedTarget:i._element};if(e){const t=e.composedPath(),n=t.includes(i._menu);if(t.includes(i._element)||"inside"===i._config.autoClose&&!n||"outside"===i._config.autoClose&&n)continue;if(i._menu.contains(e.target)&&("keyup"===e.type&&"Tab"===e.key||/input|select|option|textarea|form/i.test(e.target.tagName)))continue;"click"===e.type&&(s.clickEvent=e)}i._completeHide(s)}}static getParentFromElement(t){return o(t)||t.parentNode}static dataApiKeydownHandler(e){if(/input|textarea/i.test(e.target.tagName)?e.key===Re||e.key!==He&&(e.key!==Be&&e.key!==$e||e.target.closest(Ve)):!We.test(e.key))return;const n=this.classList.contains(Ue);if(!n&&e.key===He)return;if(e.preventDefault(),e.stopPropagation(),f(this))return;const i=()=>this.matches(Fe)?this:t.prev(this,Fe)[0];if(e.key===He)return i().focus(),void en.clearMenus();n||e.key!==$e&&e.key!==Be?n&&e.key!==Re?en.getInstance(i())._selectMenuItem(e):en.clearMenus():i().click()}}H.on(document,ze,Fe,en.dataApiKeydownHandler),H.on(document,ze,Ve,en.dataApiKeydownHandler),H.on(document,qe,en.clearMenus),H.on(document,"keyup.bs.dropdown.data-api",en.clearMenus),H.on(document,qe,Fe,(function(t){t.preventDefault(),en.dropdownInterface(this)})),b(en);const nn=".fixed-top, .fixed-bottom, .is-fixed, .sticky-top",sn=".sticky-top",on=()=>{const t=document.documentElement.clientWidth;return Math.abs(window.innerWidth-t)},rn=(t=on())=>{an(),ln("body","paddingRight",(e=>e+t)),ln(nn,"paddingRight",(e=>e+t)),ln(sn,"marginRight",(e=>e-t))},an=()=>{const t=document.body.style.overflow;t&&V.setDataAttribute(document.body,"overflow",t),document.body.style.overflow="hidden"},ln=(e,n,i)=>{const s=on();t.find(e).forEach((t=>{if(t!==document.body&&window.innerWidth>t.clientWidth+s)return;const e=t.style[n],o=window.getComputedStyle(t)[n];V.setDataAttribute(t,n,e),t.style[n]=`${i(Number.parseFloat(o))}px`}))},cn=()=>{dn("body","overflow"),dn("body","paddingRight"),dn(nn,"paddingRight"),dn(sn,"marginRight")},dn=(e,n)=>{t.find(e).forEach((t=>{const e=V.getDataAttribute(t,n);void 0===e?t.style.removeProperty(n):(V.removeDataAttribute(t,n),t.style[n]=e)}))},hn={isVisible:!0,isAnimated:!1,rootElement:document.body,clickCallback:null},fn={isVisible:"boolean",isAnimated:"boolean",rootElement:"element",clickCallback:"(function|null)"},un="backdrop",pn="show",mn="mousedown.bs.backdrop";class gn{constructor(t){this._config=this._getConfig(t),this._isAppended=!1,this._element=null}show(t){this._config.isVisible?(this._append(),this._config.isAnimated&&m(this._getElement()),this._getElement().classList.add(pn),this._emulateAnimation((()=>{v(t)}))):v(t)}hide(t){this._config.isVisible?(this._getElement().classList.remove(pn),this._emulateAnimation((()=>{this.dispose(),v(t)}))):v(t)}_getElement(){if(!this._element){const t=document.createElement("div");t.className="modal-backdrop",this._config.isAnimated&&t.classList.add("fade"),this._element=t}return this._element}_getConfig(t){return(t={...hn,..."object"==typeof t?t:{}}).rootElement=t.rootElement||document.body,d(un,t,fn),t}_append(){this._isAppended||(this._config.rootElement.appendChild(this._getElement()),H.on(this._getElement(),mn,(()=>{v(this._config.clickCallback)})),this._isAppended=!0)}dispose(){this._isAppended&&(H.off(this._element,mn),this._getElement().parentNode.removeChild(this._element),this._isAppended=!1)}_emulateAnimation(t){if(!this._config.isAnimated)return void v(t);const e=r(this._getElement());H.one(this._getElement(),"transitionend",(()=>v(t))),c(this._getElement(),e)}}const _n="modal",bn=".bs.modal",vn="Escape",yn={backdrop:!0,keyboard:!0,focus:!0},wn={backdrop:"(boolean|string)",keyboard:"boolean",focus:"boolean"},En="hidden.bs.modal",Tn="show.bs.modal",An="focusin.bs.modal",On="resize.bs.modal",Ln="click.dismiss.bs.modal",Cn="keydown.dismiss.bs.modal",kn="mousedown.dismiss.bs.modal",Dn="modal-open",xn="show",Nn="modal-static";class Sn extends R{constructor(e,n){super(e),this._config=this._getConfig(n),this._dialog=t.findOne(".modal-dialog",this._element),this._backdrop=this._initializeBackDrop(),this._isShown=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1}static get Default(){return yn}static get NAME(){return _n}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){if(this._isShown||this._isTransitioning)return;this._isAnimated()&&(this._isTransitioning=!0);const e=H.trigger(this._element,Tn,{relatedTarget:t});this._isShown||e.defaultPrevented||(this._isShown=!0,rn(),document.body.classList.add(Dn),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),H.on(this._element,Ln,'[data-bs-dismiss="modal"]',(t=>this.hide(t))),H.on(this._dialog,kn,(()=>{H.one(this._element,"mouseup.dismiss.bs.modal",(t=>{t.target===this._element&&(this._ignoreBackdropClick=!0)}))})),this._showBackdrop((()=>this._showElement(t))))}hide(t){if(t&&t.preventDefault(),!this._isShown||this._isTransitioning)return;if(H.trigger(this._element,"hide.bs.modal").defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),H.off(document,An),this._element.classList.remove(xn),H.off(this._element,Ln),H.off(this._dialog,kn),this._queueCallback((()=>this._hideModal()),this._element,e)}dispose(){[window,this._dialog].forEach((t=>H.off(t,bn))),this._backdrop.dispose(),super.dispose(),H.off(document,An)}handleUpdate(){this._adjustDialog()}_initializeBackDrop(){return new gn({isVisible:Boolean(this._config.backdrop),isAnimated:this._isAnimated()})}_getConfig(t){return t={...yn,...V.getDataAttributes(this._element),...t},d(_n,t,wn),t}_showElement(e){const n=this._isAnimated(),i=t.findOne(".modal-body",this._dialog);this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||document.body.appendChild(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.scrollTop=0,i&&(i.scrollTop=0),n&&m(this._element),this._element.classList.add(xn),this._config.focus&&this._enforceFocus();this._queueCallback((()=>{this._config.focus&&this._element.focus(),this._isTransitioning=!1,H.trigger(this._element,"shown.bs.modal",{relatedTarget:e})}),this._dialog,n)}_enforceFocus(){H.off(document,An),H.on(document,An,(t=>{document===t.target||this._element===t.target||this._element.contains(t.target)||this._element.focus()}))}_setEscapeEvent(){this._isShown?H.on(this._element,Cn,(t=>{this._config.keyboard&&t.key===vn?(t.preventDefault(),this.hide()):this._config.keyboard||t.key!==vn||this._triggerBackdropTransition()})):H.off(this._element,Cn)}_setResizeEvent(){this._isShown?H.on(window,On,(()=>this._adjustDialog())):H.off(window,On)}_hideModal(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._isTransitioning=!1,this._backdrop.hide((()=>{document.body.classList.remove(Dn),this._resetAdjustments(),cn(),H.trigger(this._element,En)}))}_showBackdrop(t){H.on(this._element,Ln,(t=>{this._ignoreBackdropClick?this._ignoreBackdropClick=!1:t.target===t.currentTarget&&(!0===this._config.backdrop?this.hide():"static"===this._config.backdrop&&this._triggerBackdropTransition())})),this._backdrop.show(t)}_isAnimated(){return this._element.classList.contains("fade")}_triggerBackdropTransition(){if(H.trigger(this._element,"hidePrevented.bs.modal").defaultPrevented)return;const t=this._element.scrollHeight>document.documentElement.clientHeight;t||(this._element.style.overflowY="hidden"),this._element.classList.add(Nn);const e=r(this._dialog);H.off(this._element,"transitionend"),H.one(this._element,"transitionend",(()=>{this._element.classList.remove(Nn),t||(H.one(this._element,"transitionend",(()=>{this._element.style.overflowY=""})),c(this._element,e))})),c(this._element,e),this._element.focus()}_adjustDialog(){const t=this._element.scrollHeight>document.documentElement.clientHeight,e=on(),n=e>0;(!n&&t&&!_()||n&&!t&&_())&&(this._element.style.paddingLeft=`${e}px`),(n&&!t&&!_()||!n&&t&&_())&&(this._element.style.paddingRight=`${e}px`)}_resetAdjustments(){this._element.style.paddingLeft="",this._element.style.paddingRight=""}static jQueryInterface(t,e){return this.each((function(){const n=Sn.getInstance(this)||new Sn(this,"object"==typeof t?t:{});if("string"==typeof t){if(void 0===n[t])throw new TypeError(`No method named "${t}"`);n[t](e)}}))}}H.on(document,"click.bs.modal.data-api",'[data-bs-toggle="modal"]',(function(t){const e=o(this);["A","AREA"].includes(this.tagName)&&t.preventDefault(),H.one(e,Tn,(t=>{t.defaultPrevented||H.one(e,En,(()=>{h(this)&&this.focus()}))}));(Sn.getInstance(e)||new Sn(e)).toggle(this)})),b(Sn);const jn="offcanvas",Mn="bs.offcanvas",Pn={backdrop:!0,keyboard:!0,scroll:!1},In={backdrop:"boolean",keyboard:"boolean",scroll:"boolean"},Hn="show",Rn=".offcanvas.show",$n="hidden.bs.offcanvas",Bn="focusin.bs.offcanvas";class Wn extends R{constructor(t,e){super(t),this._config=this._getConfig(e),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._addEventListeners()}static get NAME(){return jn}static get Default(){return Pn}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){if(this._isShown)return;if(H.trigger(this._element,"show.bs.offcanvas",{relatedTarget:t}).defaultPrevented)return;this._isShown=!0,this._element.style.visibility="visible",this._backdrop.show(),this._config.scroll||(rn(),this._enforceFocusOnElement(this._element)),this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.classList.add(Hn);this._queueCallback((()=>{H.trigger(this._element,"shown.bs.offcanvas",{relatedTarget:t})}),this._element,!0)}hide(){if(!this._isShown)return;if(H.trigger(this._element,"hide.bs.offcanvas").defaultPrevented)return;H.off(document,Bn),this._element.blur(),this._isShown=!1,this._element.classList.remove(Hn),this._backdrop.hide();this._queueCallback((()=>{this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._element.style.visibility="hidden",this._config.scroll||cn(),H.trigger(this._element,$n)}),this._element,!0)}dispose(){this._backdrop.dispose(),super.dispose(),H.off(document,Bn)}_getConfig(t){return t={...Pn,...V.getDataAttributes(this._element),..."object"==typeof t?t:{}},d(jn,t,In),t}_initializeBackDrop(){return new gn({isVisible:this._config.backdrop,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:()=>this.hide()})}_enforceFocusOnElement(t){H.off(document,Bn),H.on(document,Bn,(e=>{document===e.target||t===e.target||t.contains(e.target)||t.focus()})),t.focus()}_addEventListeners(){H.on(this._element,"click.dismiss.bs.offcanvas",'[data-bs-dismiss="offcanvas"]',(()=>this.hide())),H.on(this._element,"keydown.dismiss.bs.offcanvas",(t=>{this._config.keyboard&&"Escape"===t.key&&this.hide()}))}static jQueryInterface(t){return this.each((function(){const e=w.get(this,Mn)||new Wn(this,"object"==typeof t?t:{});if("string"==typeof t){if(void 0===e[t]||t.startsWith("_")||"constructor"===t)throw new TypeError(`No method named "${t}"`);e[t](this)}}))}}H.on(document,"click.bs.offcanvas.data-api",'[data-bs-toggle="offcanvas"]',(function(e){const n=o(this);if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),f(this))return;H.one(n,$n,(()=>{h(this)&&this.focus()}));const i=t.findOne(Rn);i&&i!==n&&Wn.getInstance(i).hide();(w.get(n,Mn)||new Wn(n)).toggle(this)})),H.on(window,"load.bs.offcanvas.data-api",(()=>{t.find(Rn).forEach((t=>(w.get(t,Mn)||new Wn(t)).show()))})),b(Wn);const qn=new Set(["background","cite","href","itemtype","longdesc","poster","src","xlink:href"]),zn=/^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/i,Un=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i,Fn=(t,e)=>{const n=t.nodeName.toLowerCase();if(e.includes(n))return!qn.has(n)||Boolean(zn.test(t.nodeValue)||Un.test(t.nodeValue));const i=e.filter((t=>t instanceof RegExp));for(let t=0,e=i.length;t<e;t++)if(i[t].test(n))return!0;return!1},Vn={"*":["class","dir","id","lang","role",/^aria-[\w-]*$/i],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","srcset","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]};function Kn(t,e,n){if(!t.length)return t;if(n&&"function"==typeof n)return n(t);const i=(new window.DOMParser).parseFromString(t,"text/html"),s=Object.keys(e),o=[].concat(...i.body.querySelectorAll("*"));for(let t=0,n=o.length;t<n;t++){const n=o[t],i=n.nodeName.toLowerCase();if(!s.includes(i)){n.parentNode.removeChild(n);continue}const r=[].concat(...n.attributes),a=[].concat(e["*"]||[],e[i]||[]);r.forEach((t=>{Fn(t,a)||n.removeAttribute(t.nodeName)}))}return i.body.innerHTML}const Yn="tooltip",Qn="bs.tooltip",Gn=new RegExp("(^|\\s)bs-tooltip\\S+","g"),Xn=new Set(["sanitize","allowList","sanitizeFn"]),Zn={animation:"boolean",template:"string",title:"(string|element|function)",trigger:"string",delay:"(number|object)",html:"boolean",selector:"(string|boolean)",placement:"(string|function)",offset:"(array|string|function)",container:"(string|element|boolean)",fallbackPlacements:"array",boundary:"(string|element)",customClass:"(string|function)",sanitize:"boolean",sanitizeFn:"(null|function)",allowList:"object",popperConfig:"(null|object|function)"},Jn={AUTO:"auto",TOP:"top",RIGHT:_()?"left":"right",BOTTOM:"bottom",LEFT:_()?"right":"left"},ti={animation:!0,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,selector:!1,placement:"top",offset:[0,0],container:!1,fallbackPlacements:["top","right","bottom","left"],boundary:"clippingParents",customClass:"",sanitize:!0,sanitizeFn:null,allowList:Vn,popperConfig:null},ei={HIDE:"hide.bs.tooltip",HIDDEN:"hidden.bs.tooltip",SHOW:"show.bs.tooltip",SHOWN:"shown.bs.tooltip",INSERTED:"inserted.bs.tooltip",CLICK:"click.bs.tooltip",FOCUSIN:"focusin.bs.tooltip",FOCUSOUT:"focusout.bs.tooltip",MOUSEENTER:"mouseenter.bs.tooltip",MOUSELEAVE:"mouseleave.bs.tooltip"},ni="fade",ii="show",si="show",oi="out",ri="hover",ai="focus";class li extends R{constructor(t,e){if(void 0===Me)throw new TypeError("Bootstrap's tooltips require Popper (https://popper.js.org)");super(t),this._isEnabled=!0,this._timeout=0,this._hoverState="",this._activeTrigger={},this._popper=null,this._config=this._getConfig(e),this.tip=null,this._setListeners()}static get Default(){return ti}static get NAME(){return Yn}static get Event(){return ei}static get DefaultType(){return Zn}enable(){this._isEnabled=!0}disable(){this._isEnabled=!1}toggleEnabled(){this._isEnabled=!this._isEnabled}toggle(t){if(this._isEnabled)if(t){const e=this._initializeOnDelegatedTarget(t);e._activeTrigger.click=!e._activeTrigger.click,e._isWithActiveTrigger()?e._enter(null,e):e._leave(null,e)}else{if(this.getTipElement().classList.contains(ii))return void this._leave(null,this);this._enter(null,this)}}dispose(){clearTimeout(this._timeout),H.off(this._element.closest(".modal"),"hide.bs.modal",this._hideModalHandler),this.tip&&this.tip.parentNode&&this.tip.parentNode.removeChild(this.tip),this._popper&&this._popper.destroy(),super.dispose()}show(){if("none"===this._element.style.display)throw new Error("Please use show on visible elements");if(!this.isWithContent()||!this._isEnabled)return;const t=H.trigger(this._element,this.constructor.Event.SHOW),e=u(this._element),i=null===e?this._element.ownerDocument.documentElement.contains(this._element):e.contains(this._element);if(t.defaultPrevented||!i)return;const s=this.getTipElement(),o=n(this.constructor.NAME);s.setAttribute("id",o),this._element.setAttribute("aria-describedby",o),this.setContent(),this._config.animation&&s.classList.add(ni);const r="function"==typeof this._config.placement?this._config.placement.call(this,s,this._element):this._config.placement,a=this._getAttachment(r);this._addAttachmentClass(a);const{container:l}=this._config;w.set(s,this.constructor.DATA_KEY,this),this._element.ownerDocument.documentElement.contains(this.tip)||(l.appendChild(s),H.trigger(this._element,this.constructor.Event.INSERTED)),this._popper?this._popper.update():this._popper=je(this._element,s,this._getPopperConfig(a)),s.classList.add(ii);const c="function"==typeof this._config.customClass?this._config.customClass():this._config.customClass;c&&s.classList.add(...c.split(" ")),"ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((t=>{H.on(t,"mouseover",p)}));const d=this.tip.classList.contains(ni);this._queueCallback((()=>{const t=this._hoverState;this._hoverState=null,H.trigger(this._element,this.constructor.Event.SHOWN),t===oi&&this._leave(null,this)}),this.tip,d)}hide(){if(!this._popper)return;const t=this.getTipElement();if(H.trigger(this._element,this.constructor.Event.HIDE).defaultPrevented)return;t.classList.remove(ii),"ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((t=>H.off(t,"mouseover",p))),this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1;const e=this.tip.classList.contains(ni);this._queueCallback((()=>{this._isWithActiveTrigger()||(this._hoverState!==si&&t.parentNode&&t.parentNode.removeChild(t),this._cleanTipClass(),this._element.removeAttribute("aria-describedby"),H.trigger(this._element,this.constructor.Event.HIDDEN),this._popper&&(this._popper.destroy(),this._popper=null))}),this.tip,e),this._hoverState=""}update(){null!==this._popper&&this._popper.update()}isWithContent(){return Boolean(this.getTitle())}getTipElement(){if(this.tip)return this.tip;const t=document.createElement("div");return t.innerHTML=this._config.template,this.tip=t.children[0],this.tip}setContent(){const e=this.getTipElement();this.setElementContent(t.findOne(".tooltip-inner",e),this.getTitle()),e.classList.remove(ni,ii)}setElementContent(t,e){if(null!==t)return a(e)?(e=l(e),void(this._config.html?e.parentNode!==t&&(t.innerHTML="",t.appendChild(e)):t.textContent=e.textContent)):void(this._config.html?(this._config.sanitize&&(e=Kn(e,this._config.allowList,this._config.sanitizeFn)),t.innerHTML=e):t.textContent=e)}getTitle(){let t=this._element.getAttribute("data-bs-original-title");return t||(t="function"==typeof this._config.title?this._config.title.call(this._element):this._config.title),t}updateAttachment(t){return"right"===t?"end":"left"===t?"start":t}_initializeOnDelegatedTarget(t,e){const n=this.constructor.DATA_KEY;return(e=e||w.get(t.delegateTarget,n))||(e=new this.constructor(t.delegateTarget,this._getDelegateConfig()),w.set(t.delegateTarget,n,e)),e}_getOffset(){const{offset:t}=this._config;return"string"==typeof t?t.split(",").map((t=>Number.parseInt(t,10))):"function"==typeof t?e=>t(e,this._element):t}_getPopperConfig(t){const e={placement:t,modifiers:[{name:"flip",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:"offset",options:{offset:this._getOffset()}},{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"arrow",options:{element:`.${this.constructor.NAME}-arrow`}},{name:"onChange",enabled:!0,phase:"afterWrite",fn:t=>this._handlePopperPlacementChange(t)}],onFirstUpdate:t=>{t.options.placement!==t.placement&&this._handlePopperPlacementChange(t)}};return{...e,..."function"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_addAttachmentClass(t){this.getTipElement().classList.add(`bs-tooltip-${this.updateAttachment(t)}`)}_getAttachment(t){return Jn[t.toUpperCase()]}_setListeners(){this._config.trigger.split(" ").forEach((t=>{if("click"===t)H.on(this._element,this.constructor.Event.CLICK,this._config.selector,(t=>this.toggle(t)));else if("manual"!==t){const e=t===ri?this.constructor.Event.MOUSEENTER:this.constructor.Event.FOCUSIN,n=t===ri?this.constructor.Event.MOUSELEAVE:this.constructor.Event.FOCUSOUT;H.on(this._element,e,this._config.selector,(t=>this._enter(t))),H.on(this._element,n,this._config.selector,(t=>this._leave(t)))}})),this._hideModalHandler=()=>{this._element&&this.hide()},H.on(this._element.closest(".modal"),"hide.bs.modal",this._hideModalHandler),this._config.selector?this._config={...this._config,trigger:"manual",selector:""}:this._fixTitle()}_fixTitle(){const t=this._element.getAttribute("title"),e=typeof this._element.getAttribute("data-bs-original-title");(t||"string"!==e)&&(this._element.setAttribute("data-bs-original-title",t||""),!t||this._element.getAttribute("aria-label")||this._element.textContent||this._element.setAttribute("aria-label",t),this._element.setAttribute("title",""))}_enter(t,e){e=this._initializeOnDelegatedTarget(t,e),t&&(e._activeTrigger["focusin"===t.type?ai:ri]=!0),e.getTipElement().classList.contains(ii)||e._hoverState===si?e._hoverState=si:(clearTimeout(e._timeout),e._hoverState=si,e._config.delay&&e._config.delay.show?e._timeout=setTimeout((()=>{e._hoverState===si&&e.show()}),e._config.delay.show):e.show())}_leave(t,e){e=this._initializeOnDelegatedTarget(t,e),t&&(e._activeTrigger["focusout"===t.type?ai:ri]=e._element.contains(t.relatedTarget)),e._isWithActiveTrigger()||(clearTimeout(e._timeout),e._hoverState=oi,e._config.delay&&e._config.delay.hide?e._timeout=setTimeout((()=>{e._hoverState===oi&&e.hide()}),e._config.delay.hide):e.hide())}_isWithActiveTrigger(){for(const t in this._activeTrigger)if(this._activeTrigger[t])return!0;return!1}_getConfig(t){const e=V.getDataAttributes(this._element);return Object.keys(e).forEach((t=>{Xn.has(t)&&delete e[t]})),(t={...this.constructor.Default,...e,..."object"==typeof t&&t?t:{}}).container=!1===t.container?document.body:l(t.container),"number"==typeof t.delay&&(t.delay={show:t.delay,hide:t.delay}),"number"==typeof t.title&&(t.title=t.title.toString()),"number"==typeof t.content&&(t.content=t.content.toString()),d(Yn,t,this.constructor.DefaultType),t.sanitize&&(t.template=Kn(t.template,t.allowList,t.sanitizeFn)),t}_getDelegateConfig(){const t={};if(this._config)for(const e in this._config)this.constructor.Default[e]!==this._config[e]&&(t[e]=this._config[e]);return t}_cleanTipClass(){const t=this.getTipElement(),e=t.getAttribute("class").match(Gn);null!==e&&e.length>0&&e.map((t=>t.trim())).forEach((e=>t.classList.remove(e)))}_handlePopperPlacementChange(t){const{state:e}=t;e&&(this.tip=e.elements.popper,this._cleanTipClass(),this._addAttachmentClass(this._getAttachment(e.placement)))}static jQueryInterface(t){return this.each((function(){let e=w.get(this,Qn);const n="object"==typeof t&&t;if((e||!/dispose|hide/.test(t))&&(e||(e=new li(this,n)),"string"==typeof t)){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t]()}}))}}b(li);const ci="bs.popover",di=new RegExp("(^|\\s)bs-popover\\S+","g"),hi={...li.Default,placement:"right",offset:[0,8],trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>'},fi={...li.DefaultType,content:"(string|element|function)"},ui={HIDE:"hide.bs.popover",HIDDEN:"hidden.bs.popover",SHOW:"show.bs.popover",SHOWN:"shown.bs.popover",INSERTED:"inserted.bs.popover",CLICK:"click.bs.popover",FOCUSIN:"focusin.bs.popover",FOCUSOUT:"focusout.bs.popover",MOUSEENTER:"mouseenter.bs.popover",MOUSELEAVE:"mouseleave.bs.popover"};class pi extends li{static get Default(){return hi}static get NAME(){return"popover"}static get Event(){return ui}static get DefaultType(){return fi}isWithContent(){return this.getTitle()||this._getContent()}setContent(){const e=this.getTipElement();this.setElementContent(t.findOne(".popover-header",e),this.getTitle());let n=this._getContent();"function"==typeof n&&(n=n.call(this._element)),this.setElementContent(t.findOne(".popover-body",e),n),e.classList.remove("fade","show")}_addAttachmentClass(t){this.getTipElement().classList.add(`bs-popover-${this.updateAttachment(t)}`)}_getContent(){return this._element.getAttribute("data-bs-content")||this._config.content}_cleanTipClass(){const t=this.getTipElement(),e=t.getAttribute("class").match(di);null!==e&&e.length>0&&e.map((t=>t.trim())).forEach((e=>t.classList.remove(e)))}static jQueryInterface(t){return this.each((function(){let e=w.get(this,ci);const n="object"==typeof t?t:null;if((e||!/dispose|hide/.test(t))&&(e||(e=new pi(this,n),w.set(this,ci,e)),"string"==typeof t)){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t]()}}))}}b(pi);const mi="scrollspy",gi=".bs.scrollspy",_i={offset:10,method:"auto",target:""},bi={offset:"number",method:"string",target:"(string|element)"},vi="dropdown-item",yi="active",wi=".nav-link",Ei="position";class Ti extends R{constructor(t,e){super(t),this._scrollElement="BODY"===this._element.tagName?window:this._element,this._config=this._getConfig(e),this._selector=`${this._config.target} .nav-link, ${this._config.target} .list-group-item, ${this._config.target} .dropdown-item`,this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,H.on(this._scrollElement,"scroll.bs.scrollspy",(()=>this._process())),this.refresh(),this._process()}static get Default(){return _i}static get NAME(){return mi}refresh(){const e=this._scrollElement===this._scrollElement.window?"offset":Ei,n="auto"===this._config.method?e:this._config.method,i=n===Ei?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight();t.find(this._selector).map((e=>{const o=s(e),r=o?t.findOne(o):null;if(r){const t=r.getBoundingClientRect();if(t.width||t.height)return this._scrollElement===this._scrollElement.window&&"offset"==n?[t.top+this._scrollElement.window.pageYOffset+i,o]:[V[n](r).top+i,o]}return null})).filter((t=>t)).sort(((t,e)=>t[0]-e[0])).forEach((t=>{this._offsets.push(t[0]),this._targets.push(t[1])}))}dispose(){H.off(this._scrollElement,gi),super.dispose()}_getConfig(t){if("string"!=typeof(t={..._i,...V.getDataAttributes(this._element),..."object"==typeof t&&t?t:{}}).target&&a(t.target)){let{id:e}=t.target;e||(e=n(mi),t.target.id=e),t.target=`#${e}`}return d(mi,t,bi),t}_getScrollTop(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop}_getScrollHeight(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)}_getOffsetHeight(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height}_process(){const t=this._getScrollTop()+this._config.offset,e=this._getScrollHeight(),n=this._config.offset+e-this._getOffsetHeight();if(this._scrollHeight!==e&&this.refresh(),t>=n){const t=this._targets[this._targets.length-1];this._activeTarget!==t&&this._activate(t)}else{if(this._activeTarget&&t<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(let e=this._offsets.length;e--;){this._activeTarget!==this._targets[e]&&t>=this._offsets[e]&&(void 0===this._offsets[e+1]||t<this._offsets[e+1])&&this._activate(this._targets[e])}}}_activate(e){this._activeTarget=e,this._clear();const n=this._selector.split(",").map((t=>`${t}[data-bs-target="${e}"],${t}[href="${e}"]`)),i=t.findOne(n.join(","));i.classList.contains(vi)?(t.findOne(".dropdown-toggle",i.closest(".dropdown")).classList.add(yi),i.classList.add(yi)):(i.classList.add(yi),t.parents(i,".nav, .list-group").forEach((e=>{t.prev(e,".nav-link, .list-group-item").forEach((t=>t.classList.add(yi))),t.prev(e,".nav-item").forEach((e=>{t.children(e,wi).forEach((t=>t.classList.add(yi)))}))}))),H.trigger(this._scrollElement,"activate.bs.scrollspy",{relatedTarget:e})}_clear(){t.find(this._selector).filter((t=>t.classList.contains(yi))).forEach((t=>t.classList.remove(yi)))}static jQueryInterface(t){return this.each((function(){const e=Ti.getInstance(this)||new Ti(this,"object"==typeof t?t:{});if("string"==typeof t){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t]()}}))}}H.on(window,"load.bs.scrollspy.data-api",(()=>{t.find('[data-bs-spy="scroll"]').forEach((t=>new Ti(t)))})),b(Ti);const Ai="bs.tab",Oi="active",Li="fade",Ci="show",ki=".active",Di=":scope > li > .active";class xi extends R{static get NAME(){return"tab"}show(){if(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&this._element.classList.contains(Oi))return;let e;const n=o(this._element),i=this._element.closest(".nav, .list-group");if(i){const n="UL"===i.nodeName||"OL"===i.nodeName?Di:ki;e=t.find(n,i),e=e[e.length-1]}const s=e?H.trigger(e,"hide.bs.tab",{relatedTarget:this._element}):null;if(H.trigger(this._element,"show.bs.tab",{relatedTarget:e}).defaultPrevented||null!==s&&s.defaultPrevented)return;this._activate(this._element,i);const r=()=>{H.trigger(e,"hidden.bs.tab",{relatedTarget:this._element}),H.trigger(this._element,"shown.bs.tab",{relatedTarget:e})};n?this._activate(n,n.parentNode,r):r()}_activate(e,n,i){const s=(!n||"UL"!==n.nodeName&&"OL"!==n.nodeName?t.children(n,ki):t.find(Di,n))[0],o=i&&s&&s.classList.contains(Li),r=()=>this._transitionComplete(e,s,i);s&&o?(s.classList.remove(Ci),this._queueCallback(r,e,!0)):r()}_transitionComplete(e,n,i){if(n){n.classList.remove(Oi);const e=t.findOne(":scope > .dropdown-menu .active",n.parentNode);e&&e.classList.remove(Oi),"tab"===n.getAttribute("role")&&n.setAttribute("aria-selected",!1)}e.classList.add(Oi),"tab"===e.getAttribute("role")&&e.setAttribute("aria-selected",!0),m(e),e.classList.contains(Li)&&e.classList.add(Ci);let s=e.parentNode;if(s&&"LI"===s.nodeName&&(s=s.parentNode),s&&s.classList.contains("dropdown-menu")){const n=e.closest(".dropdown");n&&t.find(".dropdown-toggle",n).forEach((t=>t.classList.add(Oi))),e.setAttribute("aria-expanded",!0)}i&&i()}static jQueryInterface(t){return this.each((function(){const e=w.get(this,Ai)||new xi(this);if("string"==typeof t){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t]()}}))}}H.on(document,"click.bs.tab.data-api",'[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]',(function(t){if(["A","AREA"].includes(this.tagName)&&t.preventDefault(),f(this))return;(w.get(this,Ai)||new xi(this)).show()})),b(xi);const Ni="toast",Si="bs.toast",ji="hide",Mi="show",Pi="showing",Ii={animation:"boolean",autohide:"boolean",delay:"number"},Hi={animation:!0,autohide:!0,delay:5e3};class Ri extends R{constructor(t,e){super(t),this._config=this._getConfig(e),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners()}static get DefaultType(){return Ii}static get Default(){return Hi}static get NAME(){return Ni}show(){if(H.trigger(this._element,"show.bs.toast").defaultPrevented)return;this._clearTimeout(),this._config.animation&&this._element.classList.add("fade");this._element.classList.remove(ji),m(this._element),this._element.classList.add(Pi),this._queueCallback((()=>{this._element.classList.remove(Pi),this._element.classList.add(Mi),H.trigger(this._element,"shown.bs.toast"),this._maybeScheduleHide()}),this._element,this._config.animation)}hide(){if(!this._element.classList.contains(Mi))return;if(H.trigger(this._element,"hide.bs.toast").defaultPrevented)return;this._element.classList.remove(Mi),this._queueCallback((()=>{this._element.classList.add(ji),H.trigger(this._element,"hidden.bs.toast")}),this._element,this._config.animation)}dispose(){this._clearTimeout(),this._element.classList.contains(Mi)&&this._element.classList.remove(Mi),super.dispose()}_getConfig(t){return t={...Hi,...V.getDataAttributes(this._element),..."object"==typeof t&&t?t:{}},d(Ni,t,this.constructor.DefaultType),t}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout((()=>{this.hide()}),this._config.delay)))}_onInteraction(t,e){switch(t.type){case"mouseover":case"mouseout":this._hasMouseInteraction=e;break;case"focusin":case"focusout":this._hasKeyboardInteraction=e}if(e)return void this._clearTimeout();const n=t.relatedTarget;this._element===n||this._element.contains(n)||this._maybeScheduleHide()}_setListeners(){H.on(this._element,"click.dismiss.bs.toast",'[data-bs-dismiss="toast"]',(()=>this.hide())),H.on(this._element,"mouseover.bs.toast",(t=>this._onInteraction(t,!0))),H.on(this._element,"mouseout.bs.toast",(t=>this._onInteraction(t,!1))),H.on(this._element,"focusin.bs.toast",(t=>this._onInteraction(t,!0))),H.on(this._element,"focusout.bs.toast",(t=>this._onInteraction(t,!1)))}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null}static jQueryInterface(t){return this.each((function(){let e=w.get(this,Si);if(e||(e=new Ri(this,"object"==typeof t&&t)),"string"==typeof t){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t](this)}}))}}return b(Ri),{Alert:B,Button:z,Collapse:it,Dropdown:en,Modal:Sn,Offcanvas:Wn,Popover:pi,ScrollSpy:Ti,Tab:xi,Toast:Ri,Tooltip:li}}));
!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof exports?module.exports=e(require("jquery")):e(jQuery)}(function(e){function n(e){return r.raw?e:encodeURIComponent(e)}function o(e){return r.raw?e:decodeURIComponent(e)}function t(e,n){var o=r.raw?e:function(e){0===e.indexOf('"')&&(e=e.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\"));try{return e=decodeURIComponent(e.replace(i," ")),r.json?JSON.parse(e):e}catch(e){}}(e);return"function"==typeof n?n(o):o}var i=/\+/g,r=e.cookie=function(i,c,u){if(arguments.length>1&&"function"!=typeof c){if("number"==typeof(u=e.extend({},r.defaults,u)).expires){var f=u.expires,p=u.expires=new Date;p.setMilliseconds(p.getMilliseconds()+864e5*f)}return document.cookie=[n(i),"=",function(e){return n(r.json?JSON.stringify(e):String(e))}(c),u.expires?"; expires="+u.expires.toUTCString():"",u.path?"; path="+u.path:"",u.domain?"; domain="+u.domain:"",u.secure?"; secure":""].join("")}for(var s=i?void 0:{},d=document.cookie?document.cookie.split("; "):[],a=0,l=d.length;a<l;a++){var m=d[a].split("="),x=o(m.shift()),y=m.join("=");if(i===x){s=t(y,c);break}i||void 0===(y=t(y))||(s[x]=y)}return s};r.defaults={},e.removeCookie=function(n,o){return e.cookie(n,"",e.extend({},o,{expires:-1})),!e.cookie(n)}});
/*! Magnific Popup - v1.1.0 - 2016-02-20
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2016 Dmitry Semenov; */
!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a("object"==typeof exports?require("jquery"):window.jQuery||window.Zepto)}(function(a){var b,c,d,e,f,g,h="Close",i="BeforeClose",j="AfterClose",k="BeforeAppend",l="MarkupParse",m="Open",n="Change",o="mfp",p="."+o,q="mfp-ready",r="mfp-removing",s="mfp-prevent-close",t=function(){},u=!!window.jQuery,v=a(window),w=function(a,c){b.ev.on(o+a+p,c)},x=function(b,c,d,e){var f=document.createElement("div");return f.className="mfp-"+b,d&&(f.innerHTML=d),e?c&&c.appendChild(f):(f=a(f),c&&f.appendTo(c)),f},y=function(c,d){b.ev.triggerHandler(o+c,d),b.st.callbacks&&(c=c.charAt(0).toLowerCase()+c.slice(1),b.st.callbacks[c]&&b.st.callbacks[c].apply(b,Array.isArray(d)?d:[d]))},z=function(c){return c===g&&b.currTemplate.closeBtn||(b.currTemplate.closeBtn=a(b.st.closeMarkup.replace("%title%",b.st.tClose)),g=c),b.currTemplate.closeBtn},A=function(){a.magnificPopup.instance||(b=new t,b.init(),a.magnificPopup.instance=b)},B=function(){var a=document.createElement("p").style,b=["ms","O","Moz","Webkit"];if(void 0!==a.transition)return!0;for(;b.length;)if(b.pop()+"Transition"in a)return!0;return!1};t.prototype={constructor:t,init:function(){var c=navigator.appVersion;b.isLowIE=b.isIE8=document.all&&!document.addEventListener,b.isAndroid=/android/gi.test(c),b.isIOS=/iphone|ipad|ipod/gi.test(c),b.supportsTransition=B(),b.probablyMobile=b.isAndroid||b.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),d=a(document),b.popupsCache={}},open:function(c){var e;if(c.isObj===!1){b.items=c.items.toArray(),b.index=0;var g,h=c.items;for(e=0;e<h.length;e++)if(g=h[e],g.parsed&&(g=g.el[0]),g===c.el[0]){b.index=e;break}}else b.items=Array.isArray(c.items)?c.items:[c.items],b.index=c.index||0;if(b.isOpen)return void b.updateItemHTML();b.types=[],f="",c.mainEl&&c.mainEl.length?b.ev=c.mainEl.eq(0):b.ev=d,c.key?(b.popupsCache[c.key]||(b.popupsCache[c.key]={}),b.currTemplate=b.popupsCache[c.key]):b.currTemplate={},b.st=a.extend(!0,{},a.magnificPopup.defaults,c),b.fixedContentPos="auto"===b.st.fixedContentPos?!b.probablyMobile:b.st.fixedContentPos,b.st.modal&&(b.st.closeOnContentClick=!1,b.st.closeOnBgClick=!1,b.st.showCloseBtn=!1,b.st.enableEscapeKey=!1),b.bgOverlay||(b.bgOverlay=x("bg").on("click"+p,function(){b.close()}),b.wrap=x("wrap").attr("tabindex",-1).on("click"+p,function(a){b._checkIfClose(a.target)&&b.close()}),b.container=x("container",b.wrap)),b.contentContainer=x("content"),b.st.preloader&&(b.preloader=x("preloader",b.container,b.st.tLoading));var i=a.magnificPopup.modules;for(e=0;e<i.length;e++){var j=i[e];j=j.charAt(0).toUpperCase()+j.slice(1),b["init"+j].call(b)}y("BeforeOpen"),b.st.showCloseBtn&&(b.st.closeBtnInside?(w(l,function(a,b,c,d){c.close_replaceWith=z(d.type)}),f+=" mfp-close-btn-in"):b.wrap.append(z())),b.st.alignTop&&(f+=" mfp-align-top"),b.fixedContentPos?b.wrap.css({overflow:b.st.overflowY,overflowX:"hidden",overflowY:b.st.overflowY}):b.wrap.css({top:v.scrollTop(),position:"absolute"}),(b.st.fixedBgPos===!1||"auto"===b.st.fixedBgPos&&!b.fixedContentPos)&&b.bgOverlay.css({height:d.height(),position:"absolute"}),b.st.enableEscapeKey&&d.on("keyup"+p,function(a){27===a.keyCode&&b.close()}),v.on("resize"+p,function(){b.updateSize()}),b.st.closeOnContentClick||(f+=" mfp-auto-cursor"),f&&b.wrap.addClass(f);var k=b.wH=v.height(),n={};if(b.fixedContentPos&&b._hasScrollBar(k)){var o=b._getScrollbarSize();o&&(n.marginRight=o)}b.fixedContentPos&&(b.isIE7?a("body, html").css("overflow","hidden"):n.overflow="hidden");var r=b.st.mainClass;return b.isIE7&&(r+=" mfp-ie7"),r&&b._addClassToMFP(r),b.updateItemHTML(),y("BuildControls"),a("html").css(n),b.bgOverlay.add(b.wrap).prependTo(b.st.prependTo||a(document.body)),b._lastFocusedEl=document.activeElement,setTimeout(function(){b.content?(b._addClassToMFP(q),b._setFocus()):b.bgOverlay.addClass(q),d.on("focusin"+p,b._onFocusIn)},16),b.isOpen=!0,b.updateSize(k),y(m),c},close:function(){b.isOpen&&(y(i),b.isOpen=!1,b.st.removalDelay&&!b.isLowIE&&b.supportsTransition?(b._addClassToMFP(r),setTimeout(function(){b._close()},b.st.removalDelay)):b._close())},_close:function(){y(h);var c=r+" "+q+" ";if(b.bgOverlay.detach(),b.wrap.detach(),b.container.empty(),b.st.mainClass&&(c+=b.st.mainClass+" "),b._removeClassFromMFP(c),b.fixedContentPos){var e={marginRight:""};b.isIE7?a("body, html").css("overflow",""):e.overflow="",a("html").css(e)}d.off("keyup"+p+" focusin"+p),b.ev.off(p),b.wrap.attr("class","mfp-wrap").removeAttr("style"),b.bgOverlay.attr("class","mfp-bg"),b.container.attr("class","mfp-container"),!b.st.showCloseBtn||b.st.closeBtnInside&&b.currTemplate[b.currItem.type]!==!0||b.currTemplate.closeBtn&&b.currTemplate.closeBtn.detach(),b.st.autoFocusLast&&b._lastFocusedEl&&a(b._lastFocusedEl).trigger('focus'),b.currItem=null,b.content=null,b.currTemplate=null,b.prevHeight=0,y(j)},updateSize:function(a){if(b.isIOS){var c=document.documentElement.clientWidth/window.innerWidth,d=window.innerHeight*c;b.wrap.css("height",d),b.wH=d}else b.wH=a||v.height();b.fixedContentPos||b.wrap.css("height",b.wH),y("Resize")},updateItemHTML:function(){var c=b.items[b.index];b.contentContainer.detach(),b.content&&b.content.detach(),c.parsed||(c=b.parseEl(b.index));var d=c.type;if(y("BeforeChange",[b.currItem?b.currItem.type:"",d]),b.currItem=c,!b.currTemplate[d]){var f=b.st[d]?b.st[d].markup:!1;y("FirstMarkupParse",f),f?b.currTemplate[d]=a(f):b.currTemplate[d]=!0}e&&e!==c.type&&b.container.removeClass("mfp-"+e+"-holder");var g=b["get"+d.charAt(0).toUpperCase()+d.slice(1)](c,b.currTemplate[d]);b.appendContent(g,d),c.preloaded=!0,y(n,c),e=c.type,b.container.prepend(b.contentContainer),y("AfterChange")},appendContent:function(a,c){b.content=a,a?b.st.showCloseBtn&&b.st.closeBtnInside&&b.currTemplate[c]===!0?b.content.find(".mfp-close").length||b.content.append(z()):b.content=a:b.content="",y(k),b.container.addClass("mfp-"+c+"-holder"),b.contentContainer.append(b.content)},parseEl:function(c){var d,e=b.items[c];if(e.tagName?e={el:a(e)}:(d=e.type,e={data:e,src:e.src}),e.el){for(var f=b.types,g=0;g<f.length;g++)if(e.el.hasClass("mfp-"+f[g])){d=f[g];break}e.src=e.el.attr("data-mfp-src"),e.src||(e.src=e.el.attr("href"))}return e.type=d||b.st.type||"inline",e.index=c,e.parsed=!0,b.items[c]=e,y("ElementParse",e),b.items[c]},addGroup:function(a,c){var d=function(d){d.mfpEl=this,b._openClick(d,a,c)};c||(c={});var e="click.magnificPopup";c.mainEl=a,c.items?(c.isObj=!0,a.off(e).on(e,d)):(c.isObj=!1,c.delegate?a.off(e).on(e,c.delegate,d):(c.items=a,a.off(e).on(e,d)))},_openClick:function(c,d,e){var f=void 0!==e.midClick?e.midClick:a.magnificPopup.defaults.midClick;if(f||!(2===c.which||c.ctrlKey||c.metaKey||c.altKey||c.shiftKey)){var g=void 0!==e.disableOn?e.disableOn:a.magnificPopup.defaults.disableOn;if(g)if(a.isFunction(g)){if(!g.call(b))return!0}else if(v.width()<g)return!0;c.type&&(c.preventDefault(),b.isOpen&&c.stopPropagation()),e.el=a(c.mfpEl),e.delegate&&(e.items=d.find(e.delegate)),b.open(e)}},updateStatus:function(a,d){if(b.preloader){c!==a&&b.container.removeClass("mfp-s-"+c),d||"loading"!==a||(d=b.st.tLoading);var e={status:a,text:d};y("UpdateStatus",e),a=e.status,d=e.text,b.preloader.html(d),b.preloader.find("a").on("click",function(a){a.stopImmediatePropagation()}),b.container.addClass("mfp-s-"+a),c=a}},_checkIfClose:function(c){if(!a(c).hasClass(s)){var d=b.st.closeOnContentClick,e=b.st.closeOnBgClick;if(d&&e)return!0;if(!b.content||a(c).hasClass("mfp-close")||b.preloader&&c===b.preloader[0])return!0;if(c===b.content[0]||a.contains(b.content[0],c)){if(d)return!0}else if(e&&a.contains(document,c))return!0;return!1}},_addClassToMFP:function(a){b.bgOverlay.addClass(a),b.wrap.addClass(a)},_removeClassFromMFP:function(a){this.bgOverlay.removeClass(a),b.wrap.removeClass(a)},_hasScrollBar:function(a){return(b.isIE7?d.height():document.body.scrollHeight)>(a||v.height())},_setFocus:function(){(b.st.focus?b.content.find(b.st.focus).eq(0):b.wrap).trigger('focus')},_onFocusIn:function(c){return c.target===b.wrap[0]||a.contains(b.wrap[0],c.target)?void 0:(b._setFocus(),!1)},_parseMarkup:function(b,c,d){var e;d.data&&(c=a.extend(d.data,c)),y(l,[b,c,d]),a.each(c,function(c,d){if(void 0===d||d===!1)return!0;if(e=c.split("_"),e.length>1){var f=b.find(p+"-"+e[0]);if(f.length>0){var g=e[1];"replaceWith"===g?f[0]!==d[0]&&f.replaceWith(d):"img"===g?f.is("img")?f.attr("src",d):f.replaceWith(a("<img>").attr("src",d).attr("class",f.attr("class"))):f.attr(e[1],d)}}else b.find(p+"-"+c).html(d)})},_getScrollbarSize:function(){if(void 0===b.scrollbarSize){var a=document.createElement("div");a.style.cssText="width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;",document.body.appendChild(a),b.scrollbarSize=a.offsetWidth-a.clientWidth,document.body.removeChild(a)}return b.scrollbarSize}},a.magnificPopup={instance:null,proto:t.prototype,modules:[],open:function(b,c){return A(),b=b?a.extend(!0,{},b):{},b.isObj=!0,b.index=c||0,this.instance.open(b)},close:function(){return a.magnificPopup.instance&&a.magnificPopup.instance.close()},registerModule:function(b,c){c.options&&(a.magnificPopup.defaults[b]=c.options),a.extend(this.proto,c.proto),this.modules.push(b)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:"",preloader:!0,focus:"",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:"auto",fixedBgPos:"auto",overflowY:"auto",closeMarkup:'<button title="%title%" type="button" class="mfp-close">&#215;</button>',tClose:"Close (Esc)",tLoading:"Loading...",autoFocusLast:!0}},a.fn.magnificPopup=function(c){A();var d=a(this);if("string"==typeof c)if("open"===c){var e,f=u?d.data("magnificPopup"):d[0].magnificPopup,g=parseInt(arguments[1],10)||0;f.items?e=f.items[g]:(e=d,f.delegate&&(e=e.find(f.delegate)),e=e.eq(g)),b._openClick({mfpEl:e},d,f)}else b.isOpen&&b[c].apply(b,Array.prototype.slice.call(arguments,1));else c=a.extend(!0,{},c),u?d.data("magnificPopup",c):d[0].magnificPopup=c,b.addGroup(d,c);return d};var C,D,E,F="inline",G=function(){E&&(D.after(E.addClass(C)).detach(),E=null)};a.magnificPopup.registerModule(F,{options:{hiddenClass:"hide",markup:"",tNotFound:"Content not found"},proto:{initInline:function(){b.types.push(F),w(h+"."+F,function(){G()})},getInline:function(c,d){if(G(),c.src){var e=b.st.inline,f=a(c.src);if(f.length){var g=f[0].parentNode;g&&g.tagName&&(D||(C=e.hiddenClass,D=x(C),C="mfp-"+C),E=f.after(D).detach().removeClass(C)),b.updateStatus("ready")}else b.updateStatus("error",e.tNotFound),f=a("<div>");return c.inlineElement=f,f}return b.updateStatus("ready"),b._parseMarkup(d,{},c),d}}});var H,I="ajax",J=function(){H&&a(document.body).removeClass(H)},K=function(){J(),b.req&&b.req.abort()};a.magnificPopup.registerModule(I,{options:{settings:null,cursor:"mfp-ajax-cur",tError:'<a href="%url%">The content</a> could not be loaded.'},proto:{initAjax:function(){b.types.push(I),H=b.st.ajax.cursor,w(h+"."+I,K),w("BeforeChange."+I,K)},getAjax:function(c){H&&a(document.body).addClass(H),b.updateStatus("loading");var d=a.extend({url:c.src,success:function(d,e,f){var g={data:d,xhr:f};y("ParseAjax",g),b.appendContent(a(g.data),I),c.finished=!0,J(),b._setFocus(),setTimeout(function(){b.wrap.addClass(q)},16),b.updateStatus("ready"),y("AjaxContentAdded")},error:function(){J(),c.finished=c.loadError=!0,b.updateStatus("error",b.st.ajax.tError.replace("%url%",c.src))}},b.st.ajax.settings);return b.req=a.ajax(d),""}}});var L,M=function(c){if(c.data&&void 0!==c.data.title)return c.data.title;var d=b.st.image.titleSrc;if(d){if(a.isFunction(d))return d.call(b,c);if(c.el)return c.el.attr(d)||""}return""};a.magnificPopup.registerModule("image",{options:{markup:'<div class="mfp-figure"><div class="mfp-close"></div><figure><div class="mfp-img"></div><figcaption><div class="mfp-bottom-bar"><div class="mfp-title"></div><div class="mfp-counter"></div></div></figcaption></figure></div>',cursor:"mfp-zoom-out-cur",titleSrc:"title",verticalFit:!0,tError:'<a href="%url%">The image</a> could not be loaded.'},proto:{initImage:function(){var c=b.st.image,d=".image";b.types.push("image"),w(m+d,function(){"image"===b.currItem.type&&c.cursor&&a(document.body).addClass(c.cursor)}),w(h+d,function(){c.cursor&&a(document.body).removeClass(c.cursor),v.off("resize"+p)}),w("Resize"+d,b.resizeImage),b.isLowIE&&w("AfterChange",b.resizeImage)},resizeImage:function(){var a=b.currItem;if(a&&a.img&&b.st.image.verticalFit){var c=0;b.isLowIE&&(c=parseInt(a.img.css("padding-top"),10)+parseInt(a.img.css("padding-bottom"),10)),a.img.css("max-height",b.wH-c)}},_onImageHasSize:function(a){a.img&&(a.hasSize=!0,L&&clearInterval(L),a.isCheckingImgSize=!1,y("ImageHasSize",a),a.imgHidden&&(b.content&&b.content.removeClass("mfp-loading"),a.imgHidden=!1))},findImageSize:function(a){var c=0,d=a.img[0],e=function(f){L&&clearInterval(L),L=setInterval(function(){return d.naturalWidth>0?void b._onImageHasSize(a):(c>200&&clearInterval(L),c++,void(3===c?e(10):40===c?e(50):100===c&&e(500)))},f)};e(1)},getImage:function(c,d){var e=0,f=function(){c&&(c.img[0].complete?(c.img.off(".mfploader"),c===b.currItem&&(b._onImageHasSize(c),b.updateStatus("ready")),c.hasSize=!0,c.loaded=!0,y("ImageLoadComplete")):(e++,200>e?setTimeout(f,100):g()))},g=function(){c&&(c.img.off(".mfploader"),c===b.currItem&&(b._onImageHasSize(c),b.updateStatus("error",h.tError.replace("%url%",c.src))),c.hasSize=!0,c.loaded=!0,c.loadError=!0)},h=b.st.image,i=d.find(".mfp-img");if(i.length){var j=document.createElement("img");j.className="mfp-img",c.el&&c.el.find("img").length&&(j.alt=c.el.find("img").attr("alt")),c.img=a(j).on("load.mfploader",f).on("error.mfploader",g),j.src=c.src,i.is("img")&&(c.img=c.img.clone()),j=c.img[0],j.naturalWidth>0?c.hasSize=!0:j.width||(c.hasSize=!1)}return b._parseMarkup(d,{title:M(c),img_replaceWith:c.img},c),b.resizeImage(),c.hasSize?(L&&clearInterval(L),c.loadError?(d.addClass("mfp-loading"),b.updateStatus("error",h.tError.replace("%url%",c.src))):(d.removeClass("mfp-loading"),b.updateStatus("ready")),d):(b.updateStatus("loading"),c.loading=!0,c.hasSize||(c.imgHidden=!0,d.addClass("mfp-loading"),b.findImageSize(c)),d)}}});var N,O=function(){return void 0===N&&(N=void 0!==document.createElement("p").style.MozTransform),N};a.magnificPopup.registerModule("zoom",{options:{enabled:!1,easing:"ease-in-out",duration:300,opener:function(a){return a.is("img")?a:a.find("img")}},proto:{initZoom:function(){var a,c=b.st.zoom,d=".zoom";if(c.enabled&&b.supportsTransition){var e,f,g=c.duration,j=function(a){var b=a.clone().removeAttr("style").removeAttr("class").addClass("mfp-animated-image"),d="all "+c.duration/1e3+"s "+c.easing,e={position:"fixed",zIndex:9999,left:0,top:0,"-webkit-backface-visibility":"hidden"},f="transition";return e["-webkit-"+f]=e["-moz-"+f]=e["-o-"+f]=e[f]=d,b.css(e),b},k=function(){b.content.css("visibility","visible")};w("BuildControls"+d,function(){if(b._allowZoom()){if(clearTimeout(e),b.content.css("visibility","hidden"),a=b._getItemToZoom(),!a)return void k();f=j(a),f.css(b._getOffset()),b.wrap.append(f),e=setTimeout(function(){f.css(b._getOffset(!0)),e=setTimeout(function(){k(),setTimeout(function(){f.remove(),a=f=null,y("ZoomAnimationEnded")},16)},g)},16)}}),w(i+d,function(){if(b._allowZoom()){if(clearTimeout(e),b.st.removalDelay=g,!a){if(a=b._getItemToZoom(),!a)return;f=j(a)}f.css(b._getOffset(!0)),b.wrap.append(f),b.content.css("visibility","hidden"),setTimeout(function(){f.css(b._getOffset())},16)}}),w(h+d,function(){b._allowZoom()&&(k(),f&&f.remove(),a=null)})}},_allowZoom:function(){return"image"===b.currItem.type},_getItemToZoom:function(){return b.currItem.hasSize?b.currItem.img:!1},_getOffset:function(c){var d;d=c?b.currItem.img:b.st.zoom.opener(b.currItem.el||b.currItem);var e=d.offset(),f=parseInt(d.css("padding-top"),10),g=parseInt(d.css("padding-bottom"),10);e.top-=a(window).scrollTop()-f;var h={width:d.width(),height:(u?d.innerHeight():d[0].offsetHeight)-g-f};return O()?h["-moz-transform"]=h.transform="translate("+e.left+"px,"+e.top+"px)":(h.left=e.left,h.top=e.top),h}}});var P="iframe",Q="//about:blank",R=function(a){if(b.currTemplate[P]){var c=b.currTemplate[P].find("iframe");c.length&&(a||(c[0].src=Q),b.isIE8&&c.css("display",a?"block":"none"))}};a.magnificPopup.registerModule(P,{options:{markup:'<div class="mfp-iframe-scaler"><div class="mfp-close"></div><iframe class="mfp-iframe" src="//about:blank" frameborder="0" allowfullscreen></iframe></div>',srcAction:"iframe_src",patterns:{youtube:{index:"youtube.com",id:"v=",src:"//www.youtube.com/embed/%id%?autoplay=1"},vimeo:{index:"vimeo.com/",id:"/",src:"//player.vimeo.com/video/%id%?autoplay=1"},gmaps:{index:"//maps.google.",src:"%id%&output=embed"}}},proto:{initIframe:function(){b.types.push(P),w("BeforeChange",function(a,b,c){b!==c&&(b===P?R():c===P&&R(!0))}),w(h+"."+P,function(){R()})},getIframe:function(c,d){var e=c.src,f=b.st.iframe;a.each(f.patterns,function(){return e.indexOf(this.index)>-1?(this.id&&(e="string"==typeof this.id?e.substr(e.lastIndexOf(this.id)+this.id.length,e.length):this.id.call(this,e)),e=this.src.replace("%id%",e),!1):void 0});var g={};return f.srcAction&&(g[f.srcAction]=e),b._parseMarkup(d,g,c),b.updateStatus("ready"),d}}});var S=function(a){var c=b.items.length;return a>c-1?a-c:0>a?c+a:a},T=function(a,b,c){return a.replace(/%curr%/gi,b+1).replace(/%total%/gi,c)};a.magnificPopup.registerModule("gallery",{options:{enabled:!1,arrowMarkup:'<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:"Previous (Left arrow key)",tNext:"Next (Right arrow key)",tCounter:"%curr% of %total%"},proto:{initGallery:function(){var c=b.st.gallery,e=".mfp-gallery";return b.direction=!0,c&&c.enabled?(f+=" mfp-gallery",w(m+e,function(){c.navigateByImgClick&&b.wrap.on("click"+e,".mfp-img",function(){return b.items.length>1?(b.next(),!1):void 0}),d.on("keydown"+e,function(a){37===a.keyCode?b.prev():39===a.keyCode&&b.next()})}),w("UpdateStatus"+e,function(a,c){c.text&&(c.text=T(c.text,b.currItem.index,b.items.length))}),w(l+e,function(a,d,e,f){var g=b.items.length;e.counter=g>1?T(c.tCounter,f.index,g):""}),w("BuildControls"+e,function(){if(b.items.length>1&&c.arrows&&!b.arrowLeft){var d=c.arrowMarkup,e=b.arrowLeft=a(d.replace(/%title%/gi,c.tPrev).replace(/%dir%/gi,"left")).addClass(s),f=b.arrowRight=a(d.replace(/%title%/gi,c.tNext).replace(/%dir%/gi,"right")).addClass(s);e.click(function(){b.prev()}),f.click(function(){b.next()}),b.container.append(e.add(f))}}),w(n+e,function(){b._preloadTimeout&&clearTimeout(b._preloadTimeout),b._preloadTimeout=setTimeout(function(){b.preloadNearbyImages(),b._preloadTimeout=null},16)}),void w(h+e,function(){d.off(e),b.wrap.off("click"+e),b.arrowRight=b.arrowLeft=null})):!1},next:function(){b.direction=!0,b.index=S(b.index+1),b.updateItemHTML()},prev:function(){b.direction=!1,b.index=S(b.index-1),b.updateItemHTML()},goTo:function(a){b.direction=a>=b.index,b.index=a,b.updateItemHTML()},preloadNearbyImages:function(){var a,c=b.st.gallery.preload,d=Math.min(c[0],b.items.length),e=Math.min(c[1],b.items.length);for(a=1;a<=(b.direction?e:d);a++)b._preloadItem(b.index+a);for(a=1;a<=(b.direction?d:e);a++)b._preloadItem(b.index-a)},_preloadItem:function(c){if(c=S(c),!b.items[c].preloaded){var d=b.items[c];d.parsed||(d=b.parseEl(c)),y("LazyLoad",d),"image"===d.type&&(d.img=a('<img class="mfp-img" />').on("load.mfploader",function(){d.hasSize=!0}).on("error.mfploader",function(){d.hasSize=!0,d.loadError=!0,y("LazyLoadError",d)}).attr("src",d.src)),d.preloaded=!0}}}});var U="retina";a.magnificPopup.registerModule(U,{options:{replaceSrc:function(a){return a.src.replace(/\.\w+$/,function(a){return"@2x"+a})},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var a=b.st.retina,c=a.ratio;c=isNaN(c)?c():c,c>1&&(w("ImageHasSize."+U,function(a,b){b.img.css({"max-width":b.img[0].naturalWidth/c,width:"100%"})}),w("ElementParse."+U,function(b,d){d.src=a.replaceSrc(d,c)}))}}}}),A()});
String.prototype.endsWith||(String.prototype.endsWith=function(t,e){return(void 0===e||e>this.length)&&(e=this.length),this.substring(e-t.length,e)===t}),window.NodeList&&!NodeList.prototype.forEach&&(NodeList.prototype.forEach=Array.prototype.forEach),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")}),function(t,e){"use strict";jQuery.fn[e]=function(t){return t?this.on("resize",(i=t,function(){var t=this,e=arguments;function a(){n||i.apply(t,e),s=null}s&&s.val?theme.deleteTimeout(s):n&&i.apply(t,e),s=theme.requestTimeout(a,o||100)})):this.trigger(e);var i,o,n,s}}(jQuery,"smartresize"),jQuery.extend(jQuery.easing,{def:"easeOutQuad",swing:function(t,e,i,o,n){return jQuery.easing[jQuery.easing.def](t,e,i,o,n)},easeOutQuad:function(t,e,i,o,n){return-o*(e/=n)*(e-2)+i},easeInOutQuart:function(t,e,i,o,n){return(e/=n/2)<1?o/2*e*e*e*e+i:-o/2*((e-=2)*e*e*e-2)+i},easeOutQuint:function(t,e,i,o,n){return o*((e=e/n-1)*e*e*e*e+1)+i}}),function(t){t.fn.visible=function(e,i,o,n){if(!(this.length<1)){var s=this.length>1?this.eq(0):this,a=null!=n,r=t(a?n:window),l=a?r.position():0,d=s.get(0),h=r.outerWidth(),c=r.outerHeight(),u=(o=o||"both",!0!==i||d.offsetWidth*d.offsetHeight);if("function"==typeof d.getBoundingClientRect){var p=d.getBoundingClientRect(),f=a?p.top-l.top>=0&&p.top<c+l.top:p.top>=0&&p.top<c,m=a?p.bottom-l.top>0&&p.bottom<=c+l.top:p.bottom>0&&p.bottom<=c,g=a?p.left-l.left>=0&&p.left<h+l.left:p.left>=0&&p.left<h,v=a?p.right-l.left>0&&p.right<h+l.left:p.right>0&&p.right<=h,w=e?f||m:f&&m,y=e?g||v:g&&v;if("both"===o)return u&&w&&y;if("vertical"===o)return u&&w;if("horizontal"===o)return u&&y}else{var b=a?0:l,_=b+c,C=r.scrollLeft(),k=C+h,x=s.position(),$=x.top,T=$+s.height(),j=x.left,z=j+s.width(),S=!0===e?T:$,I=!0===e?$:T,O=!0===e?z:j,H=!0===e?j:z;if("both"===o)return!!u&&I<=_&&S>=b&&H<=k&&O>=C;if("vertical"===o)return!!u&&I<=_&&S>=b;if("horizontal"===o)return!!u&&H<=k&&O>=C}}}}(jQuery),window.theme={},function(t,e){"use strict";t=t||{},e.extend(t,{rtl:"1"==js_porto_vars.rtl,rtl_browser:e("html").hasClass("browser-rtl"),ajax_url:js_porto_vars.ajax_url,request_error:js_porto_vars.request_error,change_logo:"1"==js_porto_vars.change_logo,show_sticky_header:"1"==js_porto_vars.show_sticky_header,show_sticky_header_tablet:"1"==js_porto_vars.show_sticky_header_tablet,show_sticky_header_mobile:"1"==js_porto_vars.show_sticky_header_mobile,category_ajax:"1"==js_porto_vars.category_ajax,prdctfltr_ajax:"1"==js_porto_vars.prdctfltr_ajax,container_width:parseInt(js_porto_vars.container_width),grid_gutter_width:parseInt(js_porto_vars.grid_gutter_width),screen_lg:parseInt(js_porto_vars.screen_lg),slider_loop:"1"==js_porto_vars.slider_loop,slider_autoplay:"1"==js_porto_vars.slider_autoplay,slider_autoheight:"1"==js_porto_vars.slider_autoheight,slider_speed:js_porto_vars.slider_speed?js_porto_vars.slider_speed:5e3,slider_nav:"1"==js_porto_vars.slider_nav,slider_nav_hover:"1"==js_porto_vars.slider_nav_hover,slider_margin:"1"==js_porto_vars.slider_margin?40:0,slider_dots:"1"==js_porto_vars.slider_dots,slider_animatein:js_porto_vars.slider_animatein?js_porto_vars.slider_animatein:"",slider_animateout:js_porto_vars.slider_animateout?js_porto_vars.slider_animateout:"",product_thumbs_count:js_porto_vars.product_thumbs_count?js_porto_vars.product_thumbs_count:4,product_zoom:"1"==js_porto_vars.product_zoom,product_zoom_mobile:"1"==js_porto_vars.product_zoom_mobile,product_image_popup:"1"==js_porto_vars.product_image_popup&&"fadeOut",animation_support:!e("html").hasClass("no-csstransitions")&&window.innerWidth>767,owlConfig:{rtl:"1"==js_porto_vars.rtl,loop:"1"==js_porto_vars.slider_loop,autoplay:"1"==js_porto_vars.slider_autoplay,autoHeight:"1"==js_porto_vars.slider_autoheight,autoplayTimeout:js_porto_vars.slider_speed?js_porto_vars.slider_speed:7e3,autoplayHoverPause:!0,lazyLoad:!0,nav:"1"==js_porto_vars.slider_nav,navText:["",""],dots:"1"==js_porto_vars.slider_dots,stagePadding:"1"!=js_porto_vars.slider_nav_hover&&"1"==js_porto_vars.slider_margin?40:0,animateOut:js_porto_vars.slider_animateout?js_porto_vars.slider_animateout:"",animateIn:js_porto_vars.slider_animatein?js_porto_vars.slider_animatein:""},sticky_nav_height:0,is_device_mobile:/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent||navigator.vendor||window.opera)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test((navigator.userAgent||navigator.vendor||window.opera).substr(0,4)),getScrollbarWidth:function(){return void 0===this.scrollbarSize&&(this.scrollbarSize=window.innerWidth-document.documentElement.clientWidth),this.scrollbarSize},isTablet:function(){return window.innerWidth<992},isMobile:function(){return window.innerWidth<=480},isIOS:function(){return["iPad Simulator","iPhone Simulator","iPod Simulator","iPad","iPhone","iPod"].includes(navigator.platform)||navigator.userAgent.includes("Mac")&&"ontouchend"in document},refreshVCContent:function(i){(i||e(document.body).hasClass("elementor-page"))&&e(window).trigger("resize"),t.refreshStickySidebar(!0),"function"==typeof window.vc_js&&window.vc_js(),e(document.body).trigger("porto_refresh_vc_content",[i])},adminBarHeight:function(){if(t.adminBarHeightNum||0===t.adminBarHeightNum)return t.adminBarHeightNum;var i=document.getElementById("wpadminbar"),o=e(".porto-scroll-progress.fixed-top");return o.length?t.adminBarHeightNum=o.height():t.adminBarHeightNum=0,i&&i.offsetHeight&&window.innerWidth>600&&(t.adminBarHeightNum+=i.offsetHeight),t.adminBarHeightNum},refreshStickySidebar:function(i){var o=e(".sidebar [data-plugin-sticky]");o.get(0)&&(i?t.requestTimeout((function(){o.trigger("recalc.pin")}),400):o.trigger("recalc.pin"))},scrolltoContainer:function(i,o){i.get(0)&&(window.innerWidth<992&&e(".sidebar-overlay").trigger("click"),o||(o=600),e("html, body").stop().animate({scrollTop:i.offset().top-t.StickyHeader.sticky_height-t.adminBarHeight()-t.sticky_nav_height-18},o,"easeOutQuad"))},requestFrame:function(t){var e=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame;if(!e)return setTimeout(t,1e3/60);var i=new Object;return i.val=e(t),i},requestTimeout:function(t,e){var i=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame;if(!i)return setTimeout(t,e);var o,n=new Object;return n.val=i((function s(a){o||(o=a),a-o>=e?t.call():n.val=i(s)})),n},deleteTimeout:function(t){if(t){var e=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame;return e?t.val?e(t.val):void 0:clearTimeout(t)}},execPluginFunction:function(t,e){for(var i=Array.prototype.slice.call(arguments,2),o=t.split("."),n=o.pop(),s=0;s<o.length;s++)e=e[o[s]];return e[n].apply(e,i)},getOptions:function(t){if("object"==typeof t)return t;if("string"!=typeof t)return{};try{return JSON.parse(t.replace(/'/g,'"').replace(";",""))}catch(t){return{}}},mergeOptions:function(t,e){var i={};for(var o in t)i[o]=t[o];for(var o in e)i[o]=e[o];return i},intObs:function(i,o,n){var s;s="string"==typeof i?document.querySelectorAll(i):i;var a={rootMargin:"200px"};void 0!==n&&(a.rootMargin="0px 0px "+Number(n)+"px 0px");var r=new IntersectionObserver((function(i){for(var n=0;n<i.length;n++){var s=i[n];if(s.intersectionRatio>0){var a,l=e(s.target);if("string"==typeof o){var d=t.getOptions(l.data("plugin-options"));d&&(a=d),t.execPluginFunction(o,l,a)}else{o.call(l)}r.unobserve(s.target)}}}),a);Array.prototype.forEach.call(s,(function(t){r.observe(t)}))},dynIntObsInit:function(i,o,n){var s;s="string"==typeof i?document.querySelectorAll(i):i,Array.prototype.forEach.call(s,(function(i){var s,a=e(i);if(!a.data("observer-init")){var r=t.getOptions(a.data("plugin-options"));r&&(s=r);var l=t.mergeOptions(n,s),d={rootMargin:"0px 0px 200px 0px",thresholds:0};l.accY&&(d.rootMargin="0px 0px "+Number(l.accY)+"px 0px");var h=new IntersectionObserver((function(e){for(var i=0;i<e.length;i++){var n=e[i];n.intersectionRatio>0&&(t.execPluginFunction(o,a,l),h.unobserve(n.target))}}),d);h.observe(i),a.data("observer-init",!0)}}))}}),t.isIOS()&&document.body.classList.add("ios")}.apply(this,[window.theme,jQuery]),function(){"use strict";if("object"==typeof window)if("IntersectionObserver"in window&&"IntersectionObserverEntry"in window&&"intersectionRatio"in window.IntersectionObserverEntry.prototype)"isIntersecting"in window.IntersectionObserverEntry.prototype||Object.defineProperty(window.IntersectionObserverEntry.prototype,"isIntersecting",{get:function(){return this.intersectionRatio>0}});else{var t=function(t){for(var e=window.document,i=n(e);i;)i=n(e=i.ownerDocument);return e}(),e=[],i=null,o=null;a.prototype.THROTTLE_TIMEOUT=100,a.prototype.POLL_INTERVAL=null,a.prototype.USE_MUTATION_OBSERVER=!0,a._setupCrossOriginUpdater=function(){return i||(i=function(t,i){o=t&&i?c(t,i):{top:0,bottom:0,left:0,right:0,width:0,height:0},e.forEach((function(t){t._checkForIntersections()}))}),i},a._resetCrossOriginUpdater=function(){i=null,o=null},a.prototype.observe=function(t){if(!this._observationTargets.some((function(e){return e.element==t}))){if(!t||1!=t.nodeType)throw new Error("target must be an Element");this._registerInstance(),this._observationTargets.push({element:t,entry:null}),this._monitorIntersections(t.ownerDocument),this._checkForIntersections()}},a.prototype.unobserve=function(t){this._observationTargets=this._observationTargets.filter((function(e){return e.element!=t})),this._unmonitorIntersections(t.ownerDocument),0==this._observationTargets.length&&this._unregisterInstance()},a.prototype.disconnect=function(){this._observationTargets=[],this._unmonitorAllIntersections(),this._unregisterInstance()},a.prototype.takeRecords=function(){var t=this._queuedEntries.slice();return this._queuedEntries=[],t},a.prototype._initThresholds=function(t){var e=t||[0];return Array.isArray(e)||(e=[e]),e.sort().filter((function(t,e,i){if("number"!=typeof t||isNaN(t)||t<0||t>1)throw new Error("threshold must be a number between 0 and 1 inclusively");return t!==i[e-1]}))},a.prototype._parseRootMargin=function(t){var e=(t||"0px").split(/\s+/).map((function(t){var e=/^(-?\d*\.?\d+)(px|%)$/.exec(t);if(!e)throw new Error("rootMargin must be specified in pixels or percent");return{value:parseFloat(e[1]),unit:e[2]}}));return e[1]=e[1]||e[0],e[2]=e[2]||e[0],e[3]=e[3]||e[1],e},a.prototype._monitorIntersections=function(e){var i=e.defaultView;if(i&&-1==this._monitoringDocuments.indexOf(e)){var o=this._checkForIntersections,s=null,a=null;this.POLL_INTERVAL?s=i.setInterval(o,this.POLL_INTERVAL):(r(i,"resize",o,!0),r(e,"scroll",o,!0),this.USE_MUTATION_OBSERVER&&"MutationObserver"in i&&(a=new i.MutationObserver(o)).observe(e,{attributes:!0,childList:!0,characterData:!0,subtree:!0})),this._monitoringDocuments.push(e),this._monitoringUnsubscribes.push((function(){var t=e.defaultView;t&&(s&&t.clearInterval(s),l(t,"resize",o,!0)),l(e,"scroll",o,!0),a&&a.disconnect()}));var d=this.root&&(this.root.ownerDocument||this.root)||t;if(e!=d){var h=n(e);h&&this._monitorIntersections(h.ownerDocument)}}},a.prototype._unmonitorIntersections=function(e){var i=this._monitoringDocuments.indexOf(e);if(-1!=i){var o=this.root&&(this.root.ownerDocument||this.root)||t;if(!this._observationTargets.some((function(t){var i=t.element.ownerDocument;if(i==e)return!0;for(;i&&i!=o;){var s=n(i);if((i=s&&s.ownerDocument)==e)return!0}return!1}))){var s=this._monitoringUnsubscribes[i];if(this._monitoringDocuments.splice(i,1),this._monitoringUnsubscribes.splice(i,1),s(),e!=o){var a=n(e);a&&this._unmonitorIntersections(a.ownerDocument)}}}},a.prototype._unmonitorAllIntersections=function(){var t=this._monitoringUnsubscribes.slice(0);this._monitoringDocuments.length=0,this._monitoringUnsubscribes.length=0;for(var e=0;e<t.length;e++)t[e]()},a.prototype._checkForIntersections=function(){if(this.root||!i||o){var t=this._rootIsInDom(),e=t?this._getRootRect():{top:0,bottom:0,left:0,right:0,width:0,height:0};this._observationTargets.forEach((function(o){var n=o.element,a=d(n),r=this._rootContainsTarget(n),l=o.entry,h=t&&r&&this._computeTargetAndRootIntersection(n,a,e),c=null;this._rootContainsTarget(n)?i&&!this.root||(c=e):c={top:0,bottom:0,left:0,right:0,width:0,height:0};var u=o.entry=new s({time:window.performance&&performance.now&&performance.now(),target:n,boundingClientRect:a,rootBounds:c,intersectionRect:h});l?t&&r?this._hasCrossedThreshold(l,u)&&this._queuedEntries.push(u):l&&l.isIntersecting&&this._queuedEntries.push(u):this._queuedEntries.push(u)}),this),this._queuedEntries.length&&this._callback(this.takeRecords(),this)}},a.prototype._computeTargetAndRootIntersection=function(e,n,s){if("none"!=window.getComputedStyle(e).display){for(var a,r,l,h,u,f,m,g,v=n,w=p(e),y=!1;!y&&w;){var b=null,_=1==w.nodeType?window.getComputedStyle(w):{};if("none"==_.display)return null;if(w==this.root||9==w.nodeType)if(y=!0,w==this.root||w==t)i&&!this.root?!o||0==o.width&&0==o.height?(w=null,b=null,v=null):b=o:b=s;else{var C=p(w),k=C&&d(C),x=C&&this._computeTargetAndRootIntersection(C,k,s);k&&x?(w=C,b=c(k,x)):(w=null,v=null)}else{var $=w.ownerDocument;w!=$.body&&w!=$.documentElement&&"visible"!=_.overflow&&(b=d(w))}if(b&&(a=b,r=v,void 0,void 0,void 0,void 0,void 0,void 0,l=Math.max(a.top,r.top),h=Math.min(a.bottom,r.bottom),u=Math.max(a.left,r.left),g=h-l,v=(m=(f=Math.min(a.right,r.right))-u)>=0&&g>=0&&{top:l,bottom:h,left:u,right:f,width:m,height:g}||null),!v)break;w=w&&p(w)}return v}},a.prototype._getRootRect=function(){var e;if(this.root&&!f(this.root))e=d(this.root);else{var i=f(this.root)?this.root:t,o=i.documentElement,n=i.body;e={top:0,left:0,right:o.clientWidth||n.clientWidth,width:o.clientWidth||n.clientWidth,bottom:o.clientHeight||n.clientHeight,height:o.clientHeight||n.clientHeight}}return this._expandRectByRootMargin(e)},a.prototype._expandRectByRootMargin=function(t){var e=this._rootMarginValues.map((function(e,i){return"px"==e.unit?e.value:e.value*(i%2?t.width:t.height)/100})),i={top:t.top-e[0],right:t.right+e[1],bottom:t.bottom+e[2],left:t.left-e[3]};return i.width=i.right-i.left,i.height=i.bottom-i.top,i},a.prototype._hasCrossedThreshold=function(t,e){var i=t&&t.isIntersecting?t.intersectionRatio||0:-1,o=e.isIntersecting?e.intersectionRatio||0:-1;if(i!==o)for(var n=0;n<this.thresholds.length;n++){var s=this.thresholds[n];if(s==i||s==o||s<i!=s<o)return!0}},a.prototype._rootIsInDom=function(){return!this.root||u(t,this.root)},a.prototype._rootContainsTarget=function(e){var i=this.root&&(this.root.ownerDocument||this.root)||t;return u(i,e)&&(!this.root||i==e.ownerDocument)},a.prototype._registerInstance=function(){e.indexOf(this)<0&&e.push(this)},a.prototype._unregisterInstance=function(){var t=e.indexOf(this);-1!=t&&e.splice(t,1)},window.IntersectionObserver=a,window.IntersectionObserverEntry=s}function n(t){try{return t.defaultView&&t.defaultView.frameElement||null}catch(t){return null}}function s(t){this.time=t.time,this.target=t.target,this.rootBounds=h(t.rootBounds),this.boundingClientRect=h(t.boundingClientRect),this.intersectionRect=h(t.intersectionRect||{top:0,bottom:0,left:0,right:0,width:0,height:0}),this.isIntersecting=!!t.intersectionRect;var e=this.boundingClientRect,i=e.width*e.height,o=this.intersectionRect,n=o.width*o.height;this.intersectionRatio=i?Number((n/i).toFixed(4)):this.isIntersecting?1:0}function a(t,e){var i,o,n,s=e||{};if("function"!=typeof t)throw new Error("callback must be a function");if(s.root&&1!=s.root.nodeType&&9!=s.root.nodeType)throw new Error("root must be a Document or Element");this._checkForIntersections=(i=this._checkForIntersections.bind(this),o=this.THROTTLE_TIMEOUT,n=null,function(){n||(n=setTimeout((function(){i(),n=null}),o))}),this._callback=t,this._observationTargets=[],this._queuedEntries=[],this._rootMarginValues=this._parseRootMargin(s.rootMargin),this.thresholds=this._initThresholds(s.threshold),this.root=s.root||null,this.rootMargin=this._rootMarginValues.map((function(t){return t.value+t.unit})).join(" "),this._monitoringDocuments=[],this._monitoringUnsubscribes=[]}function r(t,e,i,o){"function"==typeof t.addEventListener?t.addEventListener(e,i,o||!1):"function"==typeof t.attachEvent&&t.attachEvent("on"+e,i)}function l(t,e,i,o){"function"==typeof t.removeEventListener?t.removeEventListener(e,i,o||!1):"function"==typeof t.detatchEvent&&t.detatchEvent("on"+e,i)}function d(t){var e;try{e=t.getBoundingClientRect()}catch(t){}return e?(e.width&&e.height||(e={top:e.top,right:e.right,bottom:e.bottom,left:e.left,width:e.right-e.left,height:e.bottom-e.top}),e):{top:0,bottom:0,left:0,right:0,width:0,height:0}}function h(t){return!t||"x"in t?t:{top:t.top,y:t.top,bottom:t.bottom,left:t.left,x:t.left,right:t.right,width:t.width,height:t.height}}function c(t,e){var i=e.top-t.top,o=e.left-t.left;return{top:i,left:o,height:e.height,width:e.width,bottom:i+e.height,right:o+e.width}}function u(t,e){for(var i=e;i;){if(i==t)return!0;i=p(i)}return!1}function p(e){var i=e.parentNode;return 9==e.nodeType&&e!=t?n(e):(i&&i.assignedSlot&&(i=i.assignedSlot.parentNode),i&&11==i.nodeType&&i.host?i.host:i)}function f(t){return t&&9===t.nodeType}}(),function(t){"use strict";t.extend({browserSelector:function(){var e="ontouchstart"in window||navigator.msMaxTouchPoints,i=navigator.userAgent.toLowerCase(),o=function(t){return i.indexOf(t)>-1},n="gecko",s="webkit",a="safari",r="opera",l=document.documentElement,d=[!/opera|webtv/i.test(i)&&/msie\s(\d)/.test(i)?"ie ie"+parseFloat(navigator.appVersion.split("MSIE")[1]):o("firefox/2")?n+" ff2":o("firefox/3.5")?n+" ff3 ff3_5":o("firefox/3")?n+" ff3":o("gecko/")?n:o("opera")?r+(/version\/(\d+)/.test(i)?" "+r+RegExp.jQuery1:/opera(\s|\/)(\d+)/.test(i)?" "+r+RegExp.jQuery2:""):o("konqueror")?"konqueror":o("chrome")?s+" chrome":o("iron")?s+" iron":o("applewebkit/")?s+" "+a+(/version\/(\d+)/.test(i)?" "+a+RegExp.jQuery1:""):o("mozilla/")?n:"",o("j2me")?"mobile":o("iphone")?"iphone":o("ipod")?"ipod":o("mac")||o("darwin")?"mac":o("webtv")?"webtv":o("win")?"win":o("freebsd")?"freebsd":o("x11")||o("linux")?"linux":"","js"].join(" ");theme.is_device_mobile&&(d+=" mobile"),e&&(d+=" touch"),l.className+=" "+d,!window.ActiveXObject&&"ActiveXObject"in window&&t("html").removeClass("gecko").addClass("ie ie11")}}),t.browserSelector()}(jQuery),function(t,e){"use strict";t=t||{};var i="__accordion",o=function(t,e){return this.initialize(t,e)};o.defaults={},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){if(!e.fn.collapse)return this;var t=this.options.wrapper,i=t.find(".collapse"),o=t.data("collapsible"),n=t.data("active-tab");return i.length>0&&(t.data("use-accordion")&&"yes"==t.data("use-accordion")&&t.find(".collapse").attr("data-parent","#"+t.attr("id")),"yes"==o?i.collapse({toggle:!1,parent:"#"+t.attr("id")}):!isNaN(n)&&n==parseInt(n)&&t.find(".collapse").length>n?(t.find(".collapse").collapse({toggle:!1,parent:"#"+t.attr("id")}),t.find(".collapse").eq(n-1).collapse("toggle")):t.find(".collapse").collapse({parent:"#"+t.attr("id")})),this}},e.extend(t,{Accordion:o}),e.fn.themeAccordion=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.Accordion(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__accordionMenu",o=function(t,e){return this.initialize(t,e)};o.defaults={},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){var t=this,i=this.options.wrapper;return i.find("li.menu-item.active").each((function(){var t=e(this);t.find("> .arrow").get(0)&&t.find("> .arrow").trigger("click")})),i.on("click",".arrow",(function(i){i.preventDefault(),i.stopPropagation();var o=e(this),n=o.closest("li");return void 0!==t.options.open_one?(n.siblings(".open").children(".arrow").next().hide(),n.siblings(".open").removeClass("open"),o.next().stop().toggle()):o.next().stop().slideToggle(),n.hasClass("open")?n.removeClass("open"):n.addClass("open"),!1})),this}},e.extend(t,{AccordionMenu:o}),e.fn.themeAccordionMenu=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.AccordionMenu(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{lazyload_menu:function(i,o){if((js_porto_vars.lazyload_menu||"mobile_menu"==o)&&o){var n=!1,s=function(a){if(a){var r=e(a);if("mobile_menu"!=o&&i.each((function(i){var o=e(this),n=r.children(".mega-menu, .sidebar-menu").eq(i);n.length||(n=r.find(".mega-menu, .sidebar-menu").eq(i)),o.children("li.menu-item-has-children").each((function(t){var i=n.children("li.menu-item-has-children").eq(t).children(".popup, .sub-menu");i.hasClass("popup")&&(i=i.children(".inner")),i.length&&(e(this).children(".popup").length?e(this).children(".popup").children(".inner").replaceWith(i):o.hasClass("overlay")?(e(this).children(".sub-menu").remove(),e(this).append(i)):e(this).children(".sub-menu").replaceWith(i))})),o.hasClass("mega-menu")?t.MegaMenu.build(o):o.hasClass("side-menu-accordion")?o.themeAccordionMenu({open_one:!0}):t.SidebarMenu.build(o),o.addClass("sub-ready").trigger("sub-loaded")})),r.find("#nav-panel, #side-nav-panel").length||"mobile_menu"==o){var l=!1;if(e("#nav-panel").length)(d=r.find(".mobile-nav-wrap > *")).length?(e("#nav-panel .mobile-nav-wrap > *").replaceWith(d),e("#nav-panel .mobile-nav-wrap").removeClass("skeleton-body porto-ajax-loading"),e("#nav-panel .accordion-menu").themeAccordionMenu()):l=!0;else if(e("#side-nav-panel").length){var d;(d=r.find(".side-nav-panel-close")).length?(e("#side-nav-panel").replaceWith(d.parent()),e("#side-nav-panel .accordion-menu").themeAccordionMenu()):l=!0}l&&!n&&(n=!0,l=!1,e.post(window.location.href,{action:"porto_lazyload_menu",porto_lazyload_menu_2:1,menu_type:o,nonce:js_porto_vars.porto_nonce},s))}}};e.post(window.location.href,{action:"porto_lazyload_menu",menu_type:o,nonce:js_porto_vars.porto_nonce},s)}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__chartCircular",o=function(t,e){return this.initialize(t,e)};o.defaults={accX:0,accY:-150,delay:1,barColor:"#0088CC",trackColor:"#f2f2f2",scaleColor:!1,scaleLength:5,lineCap:"round",lineWidth:13,size:175,rotate:0,animate:{duration:2500,enabled:!0}},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){if(!e.fn.easyPieChart)return this;var i=this,o=this.options.wrapper,n=this.options.percentValue?parseInt(this.options.percentValue):parseInt(o.attr("data-percent"),10),s=o.find(".percent");n||(n=1);var a=this.options.labelValue?parseInt(this.options.labelValue,10):n;return e.extend(!0,i.options,{onStep:function(t,e,i){s.html(parseInt(a*i/n))}}),o.attr("data-percent",0).easyPieChart(i.options),(Number(i.options.delay)<=1e3/60?t.requestFrame:t.requestTimeout)((function(){o.data("easyPieChart")&&(o.data("easyPieChart").update(n),o.attr("data-percent",n))}),i.options.delay),this}},e.extend(t,{ChartCircular:o}),e.fn.themeChartCircular=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.ChartCircular(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__fitVideo",o=function(t,e){return this.initialize(t,e)};o.defaults={},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){if(!e.fn.fitVids)return this;var t=this.options.wrapper;return t.fitVids(),e(window).on("resize",(function(){t.fitVids()})),this}},e.extend(t,{FitVideo:o}),e.fn.themeFitVideo=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.FitVideo(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__videobackground",o=function(t,e){return this.initialize(t,e)};o.defaults={overlay:!0,volume:1,playbackRate:1,muted:!0,loop:!0,autoplay:!0,position:"50% 50%",posterType:"detect"},o.prototype={initialize:function(t,e){return this.$el=t,this.setData().setOptions(e).build(),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{path:this.$el.data("video-path"),wrapper:this.$el}),this},build:function(){return e.fn.vide&&this.options.path?(this.options.overlay&&this.options.wrapper.prepend(e("<div />").addClass("video-overlay")),this.options.wrapper.vide(this.options.path,this.options),this):this}},e.extend(t,{PluginVideoBackground:o}),e.fn.themePluginVideoBackground=function(t){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new o(n,t)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__flickrZoom",o=function(t,e){return this.initialize(t,e)};o.defaults={},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){var i=this.options.wrapper,o=[],n=0,s=i.find(".flickr_badge_image > a");return s.each((function(){var t={},i=e(this).find("> img");t.src=i.attr("src").replace("_s.","_b."),t.title=i.attr("title"),o[n]=t,n++})),s.on("click",(function(i){i.preventDefault(),e.fn.magnificPopup&&(e.magnificPopup.close(),e.magnificPopup.open(e.extend(!0,{},t.mfpConfig,{items:o,gallery:{enabled:!0},type:"image"}),s.index(e(this))))})),this}},e.extend(t,{FlickrZoom:o}),e.fn.themeFlickrZoom=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.FlickrZoom(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__lazyload",o=function(t,e){return this.initialize(t,e)};o.defaults={effect:"show",appearEffect:"",appear:function(t,e){},load:function(t,i){e(this).addClass("lazy-load-loaded")}},o.prototype={initialize:function(t,i){if(!t.length)return this;if(!e.fn.lazyload)return this;var n=e.extend(!0,{},o.defaults,i,{});return lazyload(t,n)}},e.extend(t,{PluginLazyLoad:o}),e.fn.themePluginLazyLoad=function(t){var n=e(this);if(n.data(i))return this;var s=new o(e.makeArray(this),t);return n.data(i,s),this}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i=['<div class="loading-overlay">','<div class="loader"></div>',"</div>"].join(""),o=function(t,e){return this.initialize(t,e)};o.prototype={options:{css:{}},initialize:function(t,e){this.$wrapper=t,this.setVars().setOptions(e).build().events(),this.$wrapper.data("loadingOverlay",this)},setVars:function(){return this.$overlay=this.$wrapper.find(".loading-overlay"),this},setOptions:function(t){return this.$overlay.get(0)||this.matchProperties(),this.options=e.extend(!0,{},this.options,t),this.loaderClass=this.getLoaderClass(this.options.css.backgroundColor),this},build:function(){return this.$overlay.closest(document.documentElement).get(0)||(this.$cachedOverlay?this.$overlay=this.$cachedOverlay.clone():(this.$overlay=e(i).clone(),this.options.css&&(this.$overlay.css(this.options.css),this.$overlay.find(".loader").addClass(this.loaderClass))),this.$wrapper.append(this.$overlay)),this.$cachedOverlay||(this.$cachedOverlay=this.$overlay.clone()),this},events:function(){var t=this;return this.options.startShowing&&t.show(),(this.$wrapper.is("body")||this.options.hideOnWindowLoad)&&e(window).on("load error",(function(){t.hide()})),this.options.listenOn&&e(this.options.listenOn).on("loading-overlay:show beforeSend.ic",(function(e){e.stopPropagation(),t.show()})).on("loading-overlay:hide complete.ic",(function(e){e.stopPropagation(),t.hide()})),this.$wrapper.on("loading-overlay:show beforeSend.ic",(function(e){e.stopPropagation(),t.show()})).on("loading-overlay:hide complete.ic",(function(e){e.stopPropagation(),t.hide()})),this},show:function(){this.build(),this.position=this.$wrapper.css("position").toLowerCase(),"relative"==this.position&&"absolute"==this.position&&"fixed"==this.position||this.$wrapper.css({position:"relative"}),this.$wrapper.addClass("loading-overlay-showing")},hide:function(){var t=this;this.$wrapper.removeClass("loading-overlay-showing"),setTimeout((function(){"relative"==this.position&&"absolute"==this.position&&"fixed"==this.position||t.$wrapper.css({position:""})}),500)},matchProperties:function(){var t,i,o;for(i=(o=["backgroundColor","borderRadius"]).length,t=0;t<i;t++){var n={};n[o[t]]=this.$wrapper.css(o[t]),e.extend(this.options.css,n)}},getLoaderClass:function(t){if(!t||"transparent"===t||"inherit"===t)return"black";var e,i,o,n;return(i=t).indexOf("#")>-1?o=i.replace("#",""):(n=i.match(/\d+/g),o=("0"+parseInt(n[0],10).toString(16)).slice(-2)+("0"+parseInt(n[1],10).toString(16)).slice(-2)+("0"+parseInt(n[2],10).toString(16)).slice(-2)),3===o.length&&(o+=o),e=o,(299*parseInt(e.substr(0,2),16)+587*parseInt(e.substr(2,2),16)+114*parseInt(e.substr(4,2),16))/1e3>=128?"black":"white"}},e.extend(t,{LoadingOverlay:o}),e.fn.loadingOverlay=function(t){return this.each((function(){var i=e(this),n=i.data("loadingOverlay");if(n)return n;var s=t||i.data("loading-overlay-options")||{};return new o(i,s)}))},e("body.loading-overlay-showing, [data-loading-overlay]").loadingOverlay()}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";var i="__masonry",o=function(t,e){return this.initialize(t,e)};o.defaults={itemSelector:"li",isOriginLeft:!(t=t||{}).rtl},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){if(!e.fn.isotope)return this;var t=this,i=this.options.wrapper;return i.isotope(this.options),i.isotope("on","layoutComplete",(function(){"function"==typeof this.options.callback&&this.options.callback.call(),i.find(".porto-lazyload:not(.lazy-load-loaded):visible").length&&e(window).trigger("scroll")})),i.isotope("layout"),t.resize(),e(window).smartresize((function(){t.resize()})),this},resize:function(){var e=this,i=this.options.wrapper;e.resizeTimer&&t.deleteTimeout(e.resizeTimer),e.resizeTimer=t.requestTimeout((function(){i.data("isotope")&&i.isotope("layout"),delete e.resizeTimer}),600)}},e.extend(t,{Masonry:o}),e.fn.themeMasonry=function(o){return this.map((function(){var n=e(this);imagesLoaded(this,(function(){return n.data(i)?n.data(i):new t.Masonry(n,o)}))}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__previewImage",o=function(t,e){return this.initialize(t,e)};o.defaults={},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){var t=this.options.wrapper,e=t.data("image");return e&&t.css("background-image","url("+e+")"),this}},e.extend(t,{PreviewImage:o}),e.fn.themePreviewImage=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.PreviewImage(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__toggle",o=function(t,e){return this.initialize(t,e)};o.defaults={},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){var i=this.options.wrapper;return i.hasClass("active")&&i.find("> div.toggle-content").stop().slideDown(350,(function(){e(this).attr("style","").show()})),i.on("click","> label",(function(i){var o=e(this).parent(),n=e(this).closest("div.toogle"),s=e(this).closest(".porto-toggles"),a=n.hasClass("toogle-accordion"),r=o.find("> div.toggle-content");a&&void 0!==i.originalEvent&&n.find("section.toggle.active > label").trigger("click"),o.hasClass("active")?s.length&&"one-toggle"==s.data("view")||(r.stop().slideUp(350,(function(){e(this).attr("style","").hide()})),o.removeClass("active")):(s.length&&"one-toggle"==s.data("view")&&s.find(".toggle").each((function(){e(this).removeClass("active"),e(this).find("> div.toggle-content").stop().slideUp(350,(function(){e(this).attr("style","").hide()}))})),r.stop().slideDown(350,(function(){e(this).attr("style","").show(),t.refreshVCContent(r)})),o.addClass("active"))})),this}},e.extend(t,{Toggle:o}),e.fn.themeToggle=function(o){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.Toggle(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var i="__parallax",o=function(t,e){return this.initialize(t,e)};o.defaults={speed:1.5,horizontalPosition:"50%",offset:0},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){var i,o=this;e(window);i=e('<div class="parallax-background"></div>');var n=o.options.wrapper.data("image-src")?"url("+o.options.wrapper.data("image-src")+")":o.options.wrapper.css("background-image");i.css({"background-image":n,"background-size":"cover","background-position":"50% 0%",position:"absolute",top:0,left:0,width:"100%",height:100*o.options.speed+"%"}),o.options.wrapper.prepend(i),o.options.wrapper.css({position:"relative",overflow:"hidden"}),o.options.wrapper.attr("data-parallax-type")&&(o.options.parallaxType="horizontal",i.css({"background-position":"0% 50%",width:100*o.options.speed+"%",height:"100%"}));var s=function(){var t=-(100*o.options.speed-100);o.options.parallaxType?(t/=9.8,i.attr("data-bottom-top","left: "+t+"%;").attr("data-top-bottom","left: 0%;")):i.attr("data-bottom-top","top: "+t+"%;").attr("data-top-bottom","top: 0%;")};return t.is_device_mobile?1==o.options.enableOnMobile?s():o.options.wrapper.addClass("parallax-disabled"):s(),this}},e.extend(t,{Parallax:o}),e.fn.themeParallax=function(o){if("undefined"==typeof skrollr)return this;var n=this.map((function(){var n=e(this);return n.data(i)?n.data(i):new t.Parallax(n,o)}));return t.portoSkrollr?t.portoSkrollr.refresh():t.is_device_mobile||(t.portoSkrollr=skrollr.init({forceHeight:!1,smoothScrolling:!1,mobileCheck:function(){return t.is_device_mobile}})),n}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";e.fn.themePin=function(i){var o=0,n=0,s=[],a=!1,r=e(window),l=[],d=[],h=[];i=i||{};var c=function(){for(var o=0,n=s.length;o<n;o++){var l=s[o];if(i.minWidth&&window.innerWidth<i.minWidth)l.parent().hasClass("pin-wrapper")&&l.unwrap(),l.css({width:"",left:"",top:"",position:""}),i.activeClass&&l.removeClass(i.activeClass),l.removeClass("sticky-transition"),l.removeClass("sticky-absolute"),a=!0;else{a=!1;var d=i.containerSelector?l.closest(i.containerSelector).length?l.closest(i.containerSelector):e(i.containerSelector):e(document.body),h=l.offset(),c=d.offset();if(void 0!==c){var u=l.parent().offset();if(!l.parent().hasClass("pin-wrapper")&&(l.wrap("<div class='pin-wrapper'>"),l.hasClass("elementor-element-populated"))){var p=l.closest(".elementor-container");if(p.length){var f=p.attr("class").match(/elementor-column-gap-([a-z]*)/g);if(f&&f.length){var m=f[0].replace("elementor-column-gap-","");l.addClass("porto-gap-"+m)}}}var g=e.extend({top:0,bottom:0},i.padding||{}),v=l.parent(),w=parseInt(v.parent().css("padding-top")),y=parseInt(v.parent().css("padding-bottom"));i.autoInit&&(e("#header").hasClass("header-side")?g.top=t.adminBarHeight():(g.top=t.adminBarHeight(),!e("#header > .main-menu-wrap").length&&e("#header").hasClass("sticky-menu-header")||(g.top+=t.StickyHeader.sticky_height)),void 0!==i.paddingOffsetTop?g.top+=parseInt(i.paddingOffsetTop,10):g.top+=18,void 0!==i.paddingOffsetBottom?g.bottom=parseInt(i.paddingOffsetBottom,10):g.bottom=0);var b=l.css("border-bottom"),_=l.outerHeight();l.css("border-bottom","1px solid transparent");var C=l.outerHeight()-_-1;l.css("border-bottom",b),l.css({width:l.outerWidth()<=v.width()?l.outerWidth():v.width()}),v.css("height",l.outerHeight()+C),!i.autoFit&&!i.fitToBottom||l.outerHeight()<=r.height()?l.data("themePin",{pad:g,from:(i.containerSelector?c.top:h.top)-g.top+w,pb:y,parentTop:u.top-w,offset:C}):l.data("themePin",{pad:g,fromFitTop:(i.containerSelector?c.top:h.top)-g.top+w,from:(i.containerSelector?c.top:h.top)+l.outerHeight()-window.innerHeight+w,pb:y,parentTop:u.top-w,offset:C})}}}},u=function(){if(!a){o=r.scrollTop();for(var t=window.innerHeight||r.height(),c=0,u=s.length;c<u;c++){var p,f=e(s[c]),m=f.data("themePin");if(m&&void 0!==m.pad){var g=i.containerSelector?f.closest(i.containerSelector).length?f.closest(i.containerSelector):e(i.containerSelector):e(document.body),v=!i.autoFit&&!i.fitToBottom||f.outerHeight()+m.pad.top<=t;if(m.end=g.offset().top+g.height(),v?m.to=g.offset().top+g.height()-f.outerHeight()-m.pad.bottom-m.pb:(m.to=g.offset().top+g.height()-t-m.pb,m.to2=g.height()-f.outerHeight()-m.pad.bottom-m.pb),0===h[c]&&(h[c]=m.to),v){var w=m.from-m.pad.bottom,y=m.to-m.pad.top-m.offset;if(void 0!==m.fromFitTop&&m.fromFitTop&&(w=m.fromFitTop-m.pad.bottom),w+f.outerHeight()>m.end||w>=y){f.css({position:"",top:"",left:""}),i.activeClass&&f.removeClass(i.activeClass),f.removeClass("sticky-transition"),f.removeClass("sticky-absolute");continue}o>w&&o<y?("fixed"!=f.css("position")&&f.css({left:f.offset().left,top:m.pad.top}).css("position","fixed"),i.activeClass&&f.addClass(i.activeClass),f.removeClass("sticky-transition"),f.removeClass("sticky-absolute")):o>=y?(f.css({left:"",top:y-m.parentTop+m.pad.top}).css("position","absolute"),i.activeClass&&f.addClass(i.activeClass),f.hasClass("sticky-absolute")&&f.addClass("sticky-transition"),f.addClass("sticky-absolute")):(f.css({position:"",top:"",left:""}),i.activeClass&&f.removeClass(i.activeClass),f.removeClass("sticky-transition"),f.removeClass("sticky-absolute"))}else if(i.fitToBottom){w=m.from,y=m.to;if(m.from+t>m.end||m.from>=y){f.css({position:"",top:"",bottom:"",left:""}),i.activeClass&&f.removeClass(i.activeClass),f.removeClass("sticky-transition"),f.removeClass("sticky-absolute");continue}o>w&&o<y?("fixed"!=f.css("position")&&f.css({left:f.offset().left,bottom:m.pad.bottom,top:""}).css("position","fixed"),i.activeClass&&f.addClass(i.activeClass),f.removeClass("sticky-transition"),f.removeClass("sticky-absolute")):o>=y?(f.css({left:"",top:m.to2,bottom:""}).css("position","absolute"),i.activeClass&&f.addClass(i.activeClass),f.hasClass("sticky-absolute")&&f.addClass("sticky-transition"),f.addClass("sticky-absolute")):(f.css({position:"",top:"",bottom:"",left:""}),i.activeClass&&f.removeClass(i.activeClass),f.removeClass("sticky-transition"),f.removeClass("sticky-absolute"))}else{var b=f.outerHeight();if(h[c]!=m.to&&d[c]&&b+f.offset().top+m.pad.bottom<o+t&&(d[c]=!1),b+m.pad.top+m.pad.bottom>t||l[c]||d[c]){var _=parseInt(f.parent().parent().css("padding-top"));o+m.pad.top-_<=m.parentTop?(f.css({position:"",top:"",bottom:"",left:""}),l[c]=d[c]=!1,i.activeClass&&f.removeClass(i.activeClass)):o>=m.to?(f.css({left:"",top:m.to2,bottom:""}).css("position","absolute"),i.activeClass&&f.addClass(i.activeClass)):o>=n?l[c]?(l[c]=!1,p=f.offset().top-m.parentTop,f.css({left:"",top:p,bottom:""}).css("position","absolute"),i.activeClass&&f.addClass(i.activeClass)):!d[c]&&b+f.offset().top+m.pad.bottom<o+t&&(d[c]=!0,"fixed"!=f.css("position")&&f.css({left:f.offset().left,bottom:m.pad.bottom,top:""}).css("position","fixed"),i.activeClass&&f.addClass(i.activeClass)):o<n&&(d[c]?(d[c]=!1,p=f.offset().top-m.parentTop,f.css({left:"",top:p,bottom:""}).css("position","absolute"),i.activeClass&&f.addClass(i.activeClass)):!l[c]&&f.offset().top>=o+m.pad.top?(l[c]=!0,"fixed"!=f.css("position")&&f.css({left:f.offset().left,top:m.pad.top,bottom:""}).css("position","fixed"),i.activeClass&&f.addClass(i.activeClass)):!d[c]&&l[c]&&"absolute"==f.css("position")&&f.offset().top>=o+m.pad.top&&(l[c]=!1))}else o>=m.parentTop-m.pad.top?f.css({position:"fixed",top:m.pad.top}):(f.css({position:"",top:"",bottom:"",left:""}),i.activeClass&&f.removeClass(i.activeClass)),l[c]=d[c]=!1}h[c]=m.to}}n=o}},p=function(){c(),u()},f=null;return this.each((function(){var i=e(this),o=i.data("themePin")||{};o&&o.update||(s.push(i),e("img",this).one("load",(function(){f&&t.deleteTimeout(f),f=t.requestFrame(c)})),o.update=p,i.data("themePin",o),l.push(!1),d.push(!1),h.push(0))})),window.addEventListener("touchmove",u,{passive:!0}),window.addEventListener("scroll",u,{passive:!0}),c(),t.isLoaded||r.on("load",p),e(this).on("recalc.pin",(function(){c(),u()})),this},t=t||{};var i="__sticky",o=function(t,e){return this.initialize(t,e)};o.defaults={autoInit:!1,minWidth:767,activeClass:"sticky-active",padding:{top:0,bottom:0},offsetTop:0,offsetBottom:0,autoFit:!1,fitToBottom:!1},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){if(!e.fn.themePin)return this;var i,o=this,n=this.options.wrapper;return n.hasClass("porto-sticky-nav")&&(this.options.padding.top=t.StickyHeader.sticky_height+t.adminBarHeight(),this.options.activeClass="sticky-active",this.options.containerSelector=".main-content-wrap",t.sticky_nav_height=n.outerHeight(),this.options.minWidth>window.innerWidth&&(t.sticky_nav_height=0)),n.themePin(this.options),e(window).smartresize((function(){i&&clearTimeout(i),i=setTimeout((function(){n.trigger("recalc.pin")}),800);var e=n.parent();n.outerWidth(e.width()),"fixed"==n.css("position")&&n.css("left",e.offset().left),n.hasClass("porto-sticky-nav")&&(t.sticky_nav_height=n.outerHeight(),o.options.minWidth>window.innerWidth&&(t.sticky_nav_height=0))})),this}},e.extend(t,{Sticky:o}),e.fn.themeSticky=function(o){return this.map((function(){var n=e(this);return n.data(i)?(n.trigger("recalc.pin"),setTimeout((function(){n.trigger("recalc.pin")}),800),n.data(i)):new t.Sticky(n,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";e((function(){e(document.body).on("click",".mobile-toggle",(function(i){var o=e("#nav-panel");if(o.length>0){if(e(this).closest(".header-main").length&&o.closest(".header-builder-p").length&&!o.parent(".header-main").length&&o.appendTo(e(this).closest(".header-main")),o.is(":visible")&&e("#header").hasClass("sticky-header")){var n=e("#header").height(),s=o.outerHeight();n>s+30&&e("#header").css("height",n-s)}o.stop().slideToggle()}else e("#side-nav-panel").length>0&&(e("html").toggleClass("panel-opened"),e(".panel-overlay").toggleClass("active"));e("#nav-panel .skeleton-body, #side-nav-panel .skeleton-body").length&&t.lazyload_menu(1,"mobile_menu"),i.preventDefault()})),e(document.body).on("click",".panel-overlay",(function(){e("html").css("transition","margin .3s").removeClass("panel-opened"),t.requestTimeout((function(){e("html").css("transition","")}),260),e(this).removeClass("active")})),e(document.body).on("click","#side-nav-panel .side-nav-panel-close",(function(t){t.preventDefault(),e(".panel-overlay").trigger("click")})),e(window).on("resize",(function(){window.innerWidth>991&&(e("#nav-panel").hide(),e("html").hasClass("panel-opened")&&e(".panel-overlay").trigger("click"))}))}))}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";e((function(){e(document).on("click",".blog-like, .portfolio-like",(function(i){i.preventDefault();var o=e(this),n=this.parentNode,s=o.attr("data-id"),a=o.hasClass("blog-like"),r={nonce:js_porto_vars.porto_nonce};if(a){if(o.hasClass("updating"))return!1;o.addClass("updating").text("..."),r.blog_id=s,r.action="porto_blog-like"}else r.portfolio_id=s,r.action="porto_portfolio-like";return e.post(t.ajax_url,r,(function(t){t&&(o.remove(),n.innerHTML=t,"undefined"!=typeof bootstrap&&[].slice.call(n.querySelectorAll("[data-bs-tooltip]")).map((function(t){return new bootstrap.Tooltip(t)})))})),!1}))}))}.apply(this,[window.theme,jQuery]);var scrolltotop={setting:{startline:100,scrollto:0,scrollduration:1e3,fadeduration:[500,100]},controlHTML:'<img src="assets/img/up.png" style="width:40px; height:40px" />',controlattrs:{offsetx:10,offsety:10},anchorkeyword:"#top",state:{isvisible:!1,shouldvisible:!1},scrollup:function(){this.cssfixedsupport||this.$control.css({opacity:0});var t=isNaN(this.setting.scrollto)?this.setting.scrollto:parseInt(this.setting.scrollto);t="string"==typeof t&&1==jQuery("#"+t).length?jQuery("#"+t).offset().top:0,this.$body.stop().animate({scrollTop:t},this.setting.scrollduration)},keepfixed:function(){var t=jQuery(window),e=t.scrollLeft()+t.width()-this.$control.width()-this.controlattrs.offsetx,i=t.scrollTop()+t.height()-this.$control.height()-this.controlattrs.offsety;this.$control.css({left:e+"px",top:i+"px"})},togglecontrol:function(){var t=jQuery(window).scrollTop();this.cssfixedsupport||this.keepfixed(),this.state.shouldvisible=t>=this.setting.startline,this.state.shouldvisible&&!this.state.isvisible?(this.$control.stop().animate({opacity:1},this.setting.fadeduration[0]),this.state.isvisible=!0):0==this.state.shouldvisible&&this.state.isvisible&&(this.$control.stop().animate({opacity:0},this.setting.fadeduration[1]),this.state.isvisible=!1)},init:function(){jQuery(document).ready((function(t){var e=scrolltotop,i=document.all;e.cssfixedsupport=!i||i&&"CSS1Compat"==document.compatMode&&window.XMLHttpRequest,e.$body=window.opera?"CSS1Compat"==document.compatMode?t("html"):t("body"):t("html,body"),e.$control=t('<div id="topcontrol">'+e.controlHTML+"</div>").css({position:e.cssfixedsupport?"fixed":"absolute",bottom:e.controlattrs.offsety,opacity:0,cursor:"pointer"}).attr({title:""}).on("click",(function(){return e.scrollup(),!1})).appendTo("body"),document.all&&!window.XMLHttpRequest&&""!=e.$control.text()&&e.$control.css({width:e.$control.width()}),e.togglecontrol(),t('a[href="'+e.anchorkeyword+'"]').on("click",(function(){return e.scrollup(),!1})),t(window).on("scroll resize",(function(t){e.togglecontrol()}))}))}};function porto_init(t){"use strict";jQuery(window).on("touchstart",(function(){})),t||(t=jQuery(document.body));var e=t.get(0);t.trigger("porto_init_start",[e]),function(i){if(i.fn.themeAccordion&&i((function(){t.find(".accordion:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themeAccordion(t)}))})),i.fn.themeAccordionMenu&&i((function(){t.find(".accordion-menu:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themeAccordionMenu(t)}))})),i.fn.themeChartCircular){var o=e.querySelectorAll("[data-plugin-chart-circular]:not(.manual), .circular-bar-chart:not(.manual)");o.length&&theme.dynIntObsInit(o,"themeChartCircular",theme.ChartCircular.defaults)}(i.fn.themeFitVideo&&i((function(){t.find(".fit-video:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themeFitVideo(t)}))})),i.fn.themePluginVideoBackground&&i((function(){t.find("[data-plugin-video-background]:not(.manual)").each((function(){var t,e=i(this),o=theme.getOptions(e.data("plugin-options"));o&&(t=o),e.themePluginVideoBackground(t)}))})),i.fn.themeFlickrZoom&&i((function(){t.find(".wpb_flickr_widget:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themeFlickrZoom(t)}))})),i.fn.themePluginLazyLoad&&i((function(){t.find("[data-plugin-lazyload]:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themePluginLazyLoad(t)})),t.find(".porto-lazyload").filter((function(){return!(i(this).data("__lazyload")||i(this).closest(".owl-carousel").length&&i(this).closest(".owl-carousel").find(".owl-item.cloned").length)})).themePluginLazyLoad({effect:"fadeIn",effect_speed:400}),t.find(".porto-lazyload").closest(".nivoSlider").length&&theme.requestTimeout((function(){t.find(".nivoSlider").each((function(){i(this).find(".porto-lazyload").length&&i(this).closest(".nivoSlider").find(".nivo-main-image").attr("src",i(this).closest(".nivoSlider").find(".porto-lazyload").eq(0).attr("src"))}))}),100),t.find(".porto-lazyload").closest(".porto-carousel-wrapper").length&&theme.requestTimeout((function(){t.find(".porto-carousel-wrapper").each((function(){i(this).find(".porto-lazyload:not(.lazy-load-loaded)").length&&i(this).find(".slick-list").css("height","auto")}))}),100)})),i.fn.themeMasonry&&i((function(){t.find("[data-plugin-masonry]:not(.manual)").each((function(){var t,e=i(this);e.hasClass("elementor-row")&&e.children(".elementor-column").addClass("porto-grid-item");var o=e.data("plugin-options");o&&(t=o),e.themeMasonry(t)})),t.find(".posts-masonry .posts-container:not(.manual)").each((function(){var t=i(this).data("plugin-options");t||(t={}),t.itemSelector=".post",i(this).themeMasonry(t)})),t.find(".page-portfolios .portfolio-row:not(.manual)").each((function(){if(!(i(this).closest(".porto-grid-container").length>0||void 0!==i(this).attr("data-plugin-masonry"))){var t,e=i(this).parent(),o="masonry",n=".portfolio:not(.w2)",s=null;e.hasClass("portfolios-grid")||e.hasClass("portfolios-masonry")&&(e.children(".bounce-loader").length||e.append('<div class="bounce-loader"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>')),t={itemSelector:".portfolio",layoutMode:o,callback:function(){s&&clearTimeout(s),s=setTimeout((function(){void 0!==theme.FilterZoom&&theme.FilterZoom.initialize(i(".page-portfolios")),e.addClass("portfolio-iso-active")}),400)}},e.find(".portfolio:not(.w2)").length||(n=".portfolio"),t=i.extend(!0,{},t,{masonry:{columnWidth:n}}),i(this).themeMasonry(t)}})),t.find(".page-members .member-row:not(.manual)").each((function(){i(this).themeMasonry({itemSelector:".member",callback:function(){setTimeout((function(){void 0!==theme.FilterZoom&&theme.FilterZoom.initialize(i(".page-members"))}),400)}})}))})),i.fn.themePreviewImage&&i((function(){t.find(".thumb-info-preview .thumb-info-image:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themePreviewImage(t)}))})),i.fn.themeToggle&&i((function(){t.find("section.toggle:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themeToggle(t)}))})),i.fn.themeParallax&&i((function(){t.find("[data-plugin-parallax]:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.themeParallax(t)}))})),i.fn.themeSticky&&i((function(){t.find("[data-plugin-sticky]:not(.manual), .porto-sticky:not(.manual), .porto-sticky-nav:not(.manual)").each((function(){var t,e=i(this),o=e.data("plugin-options");o&&(t=o),e.is(":visible")&&e.themeSticky(t)}))})),i.fn.themePluginFloatElement&&i((function(){t.find("[data-plugin-float-element]:not(.manual)").each((function(){var t,e=i(this),o=theme.getOptions(e.data("plugin-options"));o&&(t=o),e.themePluginFloatElement(t)}))})),"undefined"!=typeof bootstrap)&&([].slice.call(e.querySelectorAll("[data-bs-tooltip]:not(.manual), [data-toggle='tooltip']:not(.manual), .star-rating:not(.manual)")).map((function(t){return new bootstrap.Tooltip(t)})),[].slice.call(e.querySelectorAll("[data-toggle='popover']")).map((function(t){return new bootstrap.Popover(t)})));t.find('a[data-bs-toggle="tab"]').off("shown.bs.tab").on("shown.bs.tab",(function(t){i(this).parents(".nav-tabs").find(".active").removeClass("active"),i(this).addClass("active").parent().addClass("active")})),i.fn.vcwaypoint&&t.find(".vc_progress_bar").each((function(){var t=i(this);t.find(".progress-bar-tooltip").length&&t.vcwaypoint((function(){var e=t.find(".progress-bar-tooltip"),i=0,o=e.length;!function t(){theme.requestTimeout((function(){e.animate({opacity:1})}),200),++i<o&&t()}()}),{offset:"85%"})})),"function"==typeof theme.initAsync?theme.initAsync(t,e):i(document.body).on("porto_async_init",(function(){theme.initAsync(t,e)}))}(jQuery),jQuery(document.body).trigger("porto_init",[t])}(function(t,e){"use strict";t=t||{},e.extend(t,{ScrollToTop:{defaults:{html:'<i class="fas fa-chevron-up"></i>',offsetx:10,offsety:0},initialize:function(t,i,o){return e("#topcontrol").length||(this.html=t||this.defaults.html,this.offsetx=i||this.defaults.offsetx,this.offsety=o||this.defaults.offsety,this.build()),this},build:function(){var t=this;return void 0!==scrolltotop&&(scrolltotop.controlHTML=t.html,scrolltotop.controlattrs={offsetx:t.offsetx,offsety:t.offsety},scrolltotop.init()),t}}})}).apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{MegaMenu:{defaults:{menu:e(".mega-menu")},initialize:function(t){return this.$menu=t||this.defaults.menu,this.build().events(),this},popupWidth:function(){var i=window.innerWidth,o=t.bodyWidth-2*t.grid_gutter_width;return e("body").hasClass("wide")||(i>=t.container_width+t.grid_gutter_width-1?o=t.container_width-t.grid_gutter_width:i>=992?o=960-t.grid_gutter_width:i>=768&&(o=720-t.grid_gutter_width)),o},calcMenuPosition:function(i){var o=i,n=e("#header .header-main").hasClass("elementor-section")?e("#header .header-main > .elementor-container"):e("#header .header-main .container-fluid").length?e("#header .header-main .container-fluid"):e("#header .header-main .container").length?e("#header .header-main .container"):null;if(null!==n&&n.length){var s=n.outerWidth()-parseInt(n.css("padding-left"))-parseInt(n.css("padding-right"));if(!(s<900)){o.parent().hasClass("pos-fullwidth")&&(o.get(0).style.width=s+"px");var a=t.bodyWidth,r=o.offset().left-(a-s)/2;window.theme.rtl&&(r=t.bodyWidth-(o.offset().left+o.outerWidth())-(a-s)/2);var l=o.width(),d=s-(r+l),h=!1;return r>d&&r<l&&(h=(r+d)/3),d<0&&(h=-d),h}}},build:function(i){var o=this;return i||(i=o.$menu),i.each((function(){var i=e(this),n=(i.closest(".container"),o.popupWidth());if(i.closest(".porto-popup-menu").length)return!1;i.children("li.has-sub").each((function(){var i=e(this),s=i.children(".popup");if(s.length){var a=s.get(0);if(a.style.display="block",i.hasClass("wide")){a.style.left=0;var r=parseInt(s.css("padding-left"))+parseInt(s.css("padding-right"))+parseInt(s.find("> .inner").css("padding-left"))+parseInt(s.find("> .inner").css("padding-right")),l=4;i.hasClass("col-2")&&(l=2),i.hasClass("col-3")&&(l=3),i.hasClass("col-4")&&(l=4),i.hasClass("col-5")&&(l=5),i.hasClass("col-6")&&(l=6),window.innerWidth<992&&(l=1);var d=0;s.find("> .inner > ul > li").each((function(){var t=parseFloat(e(this).attr("data-cols"));(t<=0||!t)&&(t=1),t>l&&(t=l),d+=t})),d>l&&(d=l);var h=s.data("popup-mw")?s.data("popup-mw"):s.find(".inner").css("max-width"),c=n/l;if("none"!==h&&h<n&&(c=parseInt(h)/l),s.find("> .inner > ul > li").each((function(){var t=parseFloat(e(this).data("cols"));t<=0&&(t=1),t>l&&(t=l),i.hasClass("pos-center")||i.hasClass("pos-left")||i.hasClass("pos-right")?this.style.width=100/d*t+"%":this.style.width=100/l*t+"%"})),i.hasClass("pos-center")){s.find("> .inner > ul").get(0).style.width=c*d-r+"px";var u=s.offset().left-(t.bodyWidth-c*d)/2;a.style.left="-"+u+"px"}else if(i.hasClass("pos-left"))s.find("> .inner > ul").get(0).style.width=c*d-r+"px",a.style.left="-15px";else if(i.hasClass("pos-right"))s.find("> .inner > ul").get(0).style.width=c*d-r+"px",a.style.right="-15px",a.style.left="auto";else{i.hasClass("pos-fullwidth")||(s.find("> .inner > ul").get(0).style.width=n-r+"px"),t.rtl&&(a.style.right=0,a.style.left="auto");u=o.calcMenuPosition(s);t.rtl?(a.style.right="-15px",a.style.left="auto",u&&(a.style.right="-"+u+"px")):(a.style.left="-15px",a.style.right="auto",u&&(a.style.left="-"+u+"px"))}}else if(i.hasClass("pos-center"));else if(i.hasClass("pos-left"));else if(i.hasClass("pos-right"));else if(s.offset().left+s.width()>window.innerWidth)i.addClass("pos-right");else if(s.find("> .inner > ul").length){var p=s.find("> .inner > ul").eq(0);p.offset().left+p.width()+200>window.innerWidth&&p.addClass("pos-left")}i.addClass("sub-ready")}}))})),o},events:function(){var i=this;return e(window).smartresize((function(){i.build()})),t.isLoaded?t.requestFrame((function(){i.build()})):e(window).on("load",(function(){t.requestFrame((function(){i.build()}))})),i}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{SidebarMenu:{defaults:{menu:e(".sidebar-menu:not(.side-menu-accordion)"),toggle:e(".widget_sidebar_menu .widget-title .toggle"),menu_toggle:e("#main-toggle-menu .menu-title")},rtl:t.rtl,initialize:function(t,i,o){return this.$menu&&this.$menu.length&&t&&t.length?(this.$menu=e.uniqueSort(e.merge(this.$menu,t)),this.build(),this):(this.$menu=t||this.defaults.menu,this.$menu.length?(this.$toggle=i||this.defaults.toggle,this.$menu_toggle=o||this.defaults.menu_toggle,this.build().events(),this):this)},isRightSidebar:function(t){var i=!1;i=this.rtl?!(e("#main").hasClass("column2-right-sidebar")||e("#main").hasClass("column2-wide-right-sidebar")):e("#main").hasClass("column2-right-sidebar")||e("#main").hasClass("column2-wide-right-sidebar"),t.closest("#main-toggle-menu").length&&(i=!!this.rtl);var o=t.closest(".header-wrapper");return o.length&&o.hasClass("header-side-nav")&&(i=!!this.rtl,e(".page-wrapper").hasClass("side-nav-right")&&(i=!this.rtl)),i},popupWidth:function(){var i=window.innerWidth,o=t.bodyWidth-2*t.grid_gutter_width;return e("body").hasClass("wide")||(i>=t.container_width+t.grid_gutter_width-1?o=t.container_width-t.grid_gutter_width:i>=992?o=960-t.grid_gutter_width:i>=768&&(o=720-t.grid_gutter_width)),o},build:function(t){var i=this;if(t||(t=i.$menu),t.length){var o=t.parent(".toggle-menu-wrap"),n=null;if(o.length&&o.is(":hidden")&&((n=o.get(0)).style.display="block",n.style.visibility="hidden"),t.each((function(){var t,o=this,n=e(this);if(!o.classList.contains("side-menu-slide")){if(window.innerWidth<992)t=i.popupWidth();else{var s=this.offsetWidth?this.offsetWidth:n.width();t=i.popupWidth()-s-45}var a=i.isRightSidebar(n),r=n.children("li");r.each((function(){var i=e(this),s=i.children(".popup");if(s.length){var l=s.get(0),d=!1;if(s.is(":visible")?d=!0:l.style.display="block",i.hasClass("wide")){n.hasClass("side-menu-columns")||(l.style.left=0);var h=4;i.hasClass("col-2")&&(h=2),i.hasClass("col-3")&&(h=3),i.hasClass("col-4")&&(h=4),i.hasClass("col-5")&&(h=5),i.hasClass("col-6")&&(h=6),window.innerWidth<992&&(h=1);var c=0;s.find("> .inner > ul > li").each((function(){var t=parseFloat(e(this).data("cols"));(!t||t<=0)&&(t=1),t>h&&(t=h),c+=t})),c>h&&(c=h);var u=s.data("popup-mw")?s.data("popup-mw"):s.find(".inner").css("max-width"),p=t/h;"none"!==u&&u<t&&(p=parseInt(u)/h),s.find("> .inner > ul > li").each((function(){var t=parseFloat(e(this).data("cols"));t<=0&&(t=1),t>h&&(t=h),i.hasClass("pos-center")||i.hasClass("pos-left")||i.hasClass("pos-right")?this.style.width=100/c*t+"%":this.style.width=100/h*t+"%"})),l.children[0].children[0].style.width=p*c+1+"px",n.hasClass("side-menu-columns")||(a?(l.style.left="auto",l.style.right=(this.offsetWidth?this.offsetWidth:e(this).width())+"px"):(l.style.left=(this.offsetWidth?this.offsetWidth:e(this).width())+"px",l.style.right="auto"))}d||(l.style.display="none"),o.classList.contains("side-menu-accordion")||o.classList.contains("side-menu-slide")||i.hasClass("sub-ready")||(!("ontouchstart"in document)&&window.innerWidth>991?i.on("mouseenter",(function(){r.find(".popup").hide(),s.show(),s.parent().addClass("open")})).on("mouseleave",(function(){s.hide(),s.parent().removeClass("open")})):i.on("click",".arrow",(function(){s.slideToggle(),s.parent().toggleClass("open")})),i.addClass("sub-ready"))}}))}})),t.hasClass("side-menu-slide")){var s={$mainNav:t,$mainNavItem:t.find("li"),build:function(){this.menuNav()},initSub:function(t){var e=t.closest("ul"),i=t.parent().find("ul").first();i.children(".menu-item").children(".go-back").length<1&&i.prepend('<li class="menu-item"><a class="go-back" href="#">'+js_porto_vars.submenu_back+"</a></li>");var o=i.find("> li").length*i.find("> li").outerHeight()-i.outerHeight();e.addClass("next-menu"),i.addClass("visible"),e.css({overflow:"visible","overflow-y":"visible"}),o>0&&i.css({overflow:"hidden","overflow-y":"scroll"}),i.outerHeight()<i.closest(".header-main").outerHeight()-100&&i.css({height:i.outerHeight()+i.find("> li").outerHeight()}),i.css({"padding-top":o+"px"})},menuNav:function(){var t=this;t.$mainNav.find(".menu-item-has-children > a.nolink").removeClass("nolink").attr("href",""),t.$mainNav.find(".menu-item-has-children > a:not(.go-back)").off("click").on("click",(function(i){i.stopImmediatePropagation(),i.preventDefault();var o=e(this);js_porto_vars.lazyload_menu&&!t.$mainNav.hasClass("sub-ready")?(t.initSub(o),t.$mainNav.on("sub-loaded",(function(){t.initSub(o)}))):t.initSub(o)}))}};s.build()}return n&&(n.style.display="",n.style.visibility=""),i}},events:function(){var t,i=this;(i.$toggle.on("click",(function(){var t=e(this).parent().parent(),o=e(this);o.hasClass("closed")?(o.removeClass("closed"),t.removeClass("closed"),t.find(".sidebar-menu-wrap").stop().slideDown(400,(function(){e(this).attr("style","").show(),i.build()}))):(o.addClass("closed"),t.addClass("closed"),t.find(".sidebar-menu-wrap").stop().slideUp(400,(function(){e(this).attr("style","").hide()})))})),this.$menu_toggle.on("click",(function(){var t=e(this).parent();if(!t.hasClass("show-always")&&!t.hasClass("show-hover")){var o=e(this);o.hasClass("closed")?(o.removeClass("closed"),t.removeClass("closed"),t.find(".toggle-menu-wrap").stop().slideDown(400,(function(){e(this).attr("style","").show()})),i.build()):(o.addClass("closed"),t.addClass("closed"),t.find(".toggle-menu-wrap").stop().slideUp(400,(function(){e(this).attr("style","").hide()})))}})),i.$menu.hasClass("side-menu-slide")&&i.$menu.on("click",".go-back",(function(t){t.preventDefault();var i=e(this).closest(".next-menu"),o=0;i.length&&i.find("> li").length&&(o=i.find("> li").length*i.find("> li").outerHeight()-i.outerHeight()),i.removeClass("next-menu"),e(this).closest("ul").removeClass("visible"),o>0&&i.css({overflow:"hidden","overflow-y":"scroll"})})),e(".sidebar-menu:not(.side-menu-accordion)").closest("[data-plugin-sticky]").length)?e(window).smartresize((function(){t&&clearTimeout(t),t=setTimeout((function(){i.build()}),800)})):e(window).smartresize((function(){i.build()}));return setTimeout((function(){i.build()}),400),i}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{StickyHeader:{defaults:{header:e("#header")},initialize:function(i){if(this.$header=i||this.defaults.header,this.sticky_height=0,this.sticky_pos=0,this.change_logo=t.change_logo,!t.show_sticky_header||!this.$header.length||e(".side-header-narrow-bar").length)return this;var o=this,n=o.$header.find("> .main-menu-wrap");return n.length?(o.$menu_wrap=n,o.menu_height=n.height()):o.$menu_wrap=!1,o.$header_main=o.$header.find(".header-main"),!o.$header_main.length&&o.$header.children(".elementor-location-header").length&&(o.$header_main=o.$header.children(".elementor-location-header").last().addClass("header-main")),o.$header_main.length?(o.reveal=o.$header.parents(".header-wrapper").hasClass("header-reveal"),o.is_sticky=!1,o.reset().build().events(),o):this},build:function(){var i=this;if(!i.is_sticky&&window.innerHeight+i.header_height+t.adminBarHeight()+parseInt(i.$header.css("border-top-width"))>=e(document).height())return i;window.innerHeight>e(document.body).height()&&window.scrollTo(0,0);var o=e(window).scrollTop();if(i.$menu_wrap&&!t.isTablet())if(i.$header_main.stop().css("top",0),i.$header.parent().hasClass("fixed-header")&&i.$header.parent().attr("style",""),o>i.sticky_pos){if(!i.$header.hasClass("sticky-header")){var n,s=i.$header.outerHeight();i.$header.addClass("sticky-header").css("height",s),i.$menu_wrap.stop().css("top",t.adminBarHeight()),(n=i.$header.find(".header-main .searchform select").data("selectric"))&&void 0!==n.close&&n.close(),i.$header.parent().hasClass("fixed-header")&&(i.$header_main.hide(),i.$header.css("height","")),i.init_toggle_menu||(i.init_toggle_menu=!0,t.MegaMenu.build(),e("#main-toggle-menu").length&&(e("#main-toggle-menu").hasClass("show-always")&&(e("#main-toggle-menu").data("show-always",!0),e("#main-toggle-menu").removeClass("show-always")),e("#main-toggle-menu").addClass("closed"),e("#main-toggle-menu .menu-title").addClass("closed"),e("#main-toggle-menu .toggle-menu-wrap").attr("style",""))),i.is_sticky=!0}}else i.$header.hasClass("sticky-header")&&(i.$header.removeClass("sticky-header"),i.$header.css("height",""),i.$menu_wrap.stop().css("top",0),i.$header_main.show(),(n=i.$header.find(".main-menu-wrap .searchform select").data("selectric"))&&void 0!==n.close&&n.close(),i.init_toggle_menu&&(i.init_toggle_menu=!1,t.MegaMenu.build(),e("#main-toggle-menu").length&&e("#main-toggle-menu").data("show-always")&&(e("#main-toggle-menu").addClass("show-always"),e("#main-toggle-menu").removeClass("closed"),e("#main-toggle-menu .menu-title").removeClass("closed"),e("#main-toggle-menu .toggle-menu-wrap").attr("style",""))),i.is_sticky=!1);else if(i.$header_main.show(),i.$header.parent().hasClass("fixed-header")&&e("#wpadminbar").length&&"absolute"==e("#wpadminbar").css("position")?i.$header.parent().css("top",e("#wpadminbar").height()-o<0?-e("#wpadminbar").height():-o):(i.$header.parent().hasClass("fixed-header")||i.$header.parent().hasClass("fixed-header"))&&i.$header.parent().attr("style",""),i.$header.hasClass("sticky-menu-header")&&!t.isTablet())i.$header_main.stop().css("top",0),i.change_logo&&i.$header_main.removeClass("change-logo"),i.$header_main.removeClass("sticky"),i.$header.removeClass("sticky-header"),i.is_sticky=!1,i.sticky_height=0;else if(i.$menu_wrap&&i.$menu_wrap.stop().css("top",0),o>i.sticky_pos&&(!t.isTablet()||t.isTablet()&&!t.isMobile()&&t.show_sticky_header_tablet||t.isMobile()&&t.show_sticky_header_tablet&&t.show_sticky_header_mobile)){if(!i.$header.hasClass("sticky-header")){s=i.$header.outerHeight();i.$header.addClass("sticky-header").css("height",s),i.$header_main.addClass("sticky"),i.change_logo&&i.$header_main.addClass("change-logo"),i.$header_main.stop().css("top",t.adminBarHeight()),i.init_toggle_menu||(i.init_toggle_menu=!0,t.MegaMenu.build(),e("#main-toggle-menu").length&&(e("#main-toggle-menu").hasClass("show-always")&&(e("#main-toggle-menu").data("show-always",!0),e("#main-toggle-menu").removeClass("show-always")),e("#main-toggle-menu").addClass("closed"),e("#main-toggle-menu .menu-title").addClass("closed"),e("#main-toggle-menu .toggle-menu-wrap").attr("style",""))),i.is_sticky=!0}}else i.$header.hasClass("sticky-header")&&(i.change_logo&&i.$header_main.removeClass("change-logo"),i.$header_main.removeClass("sticky"),i.$header.removeClass("sticky-header"),i.$header.css("height",""),i.$header_main.stop().css("top",0),i.init_toggle_menu&&(i.init_toggle_menu=!1,t.MegaMenu.build(),e("#main-toggle-menu").length&&e("#main-toggle-menu").data("show-always")&&(e("#main-toggle-menu").addClass("show-always"),e("#main-toggle-menu").removeClass("closed"),e("#main-toggle-menu .menu-title").removeClass("closed"),e("#main-toggle-menu .toggle-menu-wrap").attr("style",""))),i.is_sticky=!1);return i.$header.hasClass("header-loaded")||i.$header.addClass("header-loaded"),i.$header.find(".logo").hasClass("logo-transition")||i.$header.find(".logo").addClass("logo-transition"),i.$header.find(".overlay-logo").get(0)&&!i.$header.find(".overlay-logo").hasClass("overlay-logo-transition")&&i.$header.find(".overlay-logo").addClass("overlay-logo-transition"),i},reset:function(){var i=this;return i.$header.find(".logo").hasClass("logo-transition")&&i.$header.find(".logo").removeClass("logo-transition"),i.$header.find(".overlay-logo").get(0)&&i.$header.find(".overlay-logo").hasClass("overlay-logo-transition")&&i.$header.find(".overlay-logo").removeClass("overlay-logo-transition"),i.$menu_wrap&&!t.isTablet()?(i.$header.addClass("sticky-header sticky-header-calc"),i.$header_main.addClass("sticky"),i.change_logo&&i.$header_main.addClass("change-logo"),i.sticky_height=i.$menu_wrap.height()+parseInt(i.$menu_wrap.css("padding-top"))+parseInt(i.$menu_wrap.css("padding-bottom")),i.change_logo&&i.$header_main.removeClass("change-logo"),i.$header_main.removeClass("sticky"),i.$header.removeClass("sticky-header sticky-header-calc"),i.header_height=i.$header.height()+parseInt(i.$header.css("margin-top")),i.menu_height=i.$menu_wrap.height()+parseInt(i.$menu_wrap.css("padding-top"))+parseInt(i.$menu_wrap.css("padding-bottom")),i.sticky_pos=i.header_height-i.sticky_height+parseInt(e("body").css("padding-top"))+parseInt(i.$header.css("border-top-width")),e(".banner-before-header").length&&(i.sticky_pos+=e(".banner-before-header").height()),e(".porto-block-html-top").length&&(i.sticky_pos+=e(".porto-block-html-top").height())):(i.$header.addClass("sticky-header sticky-header-calc"),i.$header_main.addClass("sticky"),i.change_logo&&i.$header_main.addClass("change-logo"),i.sticky_height=i.$header_main.outerHeight(),i.change_logo&&i.$header_main.removeClass("change-logo"),i.$header_main.removeClass("sticky"),i.$header.removeClass("sticky-header sticky-header-calc"),i.header_height=i.$header.height()+parseInt(i.$header.css("margin-top")),i.main_height=i.$header_main.height(),!t.isTablet()||t.isTablet()&&!t.isMobile()&&t.show_sticky_header_tablet||t.isMobile()&&t.show_sticky_header_tablet&&t.show_sticky_header_mobile||(i.sticky_height=0),i.sticky_pos=i.$header.offset().top+i.header_height-i.sticky_height-t.adminBarHeight()+parseInt(i.$header.css("border-top-width"))),i.reveal&&(i.menu_height?i.sticky_pos+=i.menu_height+30:i.sticky_pos+=30),i.sticky_pos<0&&(i.sticky_pos=0),i.init_toggle_menu=!1,i.$header_main.removeAttr("style"),!t.isTablet()&&i.$header.hasClass("header-side")&&void 0!==i.$header.attr("data-plugin-sticky")?i.$header.css("height",""):i.$header.removeAttr("style"),i},events:function(){var i=this,o=0;return e(window).smartresize((function(){o!=window.innerWidth&&(i.reset().build(),o=window.innerWidth)})),window.addEventListener("scroll",(function(){t.requestFrame((function(){i.build()}))}),{passive:!0}),i}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{SideNav:{defaults:{side_nav:e(".header-side-nav #header")},bc_pos_top:0,initialize:function(t){if(this.$side_nav=t||this.defaults.side_nav,!this.$side_nav.length)return this;var e=this;return e.$side_nav.addClass("initialize"),e.reset().build().events(),e},build:function(){var i=this,o=e(".page-top"),n=e("#main");if(t.isTablet())o.removeClass("fixed-pos"),o.attr("style",""),n.attr("style","");else{var s=e(window).scrollTop();o.length&&o.outerHeight()<100&&!e(".side-header-narrow-bar-top").length&&(i.page_top_offset==t.adminBarHeight()||i.page_top_offset<=s?o.hasClass("fixed-pos")||(o.addClass("fixed-pos"),o.css("top",t.adminBarHeight()),n.css("padding-top",o.outerHeight())):o.hasClass("fixed-pos")&&(o.removeClass("fixed-pos"),o.attr("style",""),n.attr("style",""))),n.css("min-height",window.innerHeight-t.adminBarHeight()-e(".page-top:not(.fixed-pos)").height()-e(".footer-wrapper").height())}return i},reset:function(){var i=this;if(t.isTablet())i.$side_nav.attr("style","");else{var o=window.innerHeight,n=i.$side_nav.find(".side-bottom");i.$side_nav.css({"min-height":o-t.adminBarHeight(),"padding-bottom":n.length?n.height()+parseInt(n.css("margin-top"))+parseInt(n.css("margin-bottom")):""});var s=navigator.appVersion,a=s.indexOf("AppleWebKit/")+12,r=a+3;s.slice(a,r)<537&&(i.$side_nav.css("-webkit-backface-visibility","hidden"),i.$side_nav.css("-webkit-perspective","1000"))}var l=e(".page-top"),d=e("#main");return l.length&&(l.removeClass("fixed-pos"),l.attr("style",""),d.attr("style",""),i.page_top_offset=l.offset().top),i},events:function(){var i=this;return e(window).on("resize",(function(){i.reset().build()})),window.addEventListener("scroll",(function(){i.build()}),{passive:!0}),e(".side-header-narrow-bar-top").length&&(e(window).scrollTop()>t.adminBarHeight()+e(".side-header-narrow-bar-top").height()&&e(".side-header-narrow-bar-top").addClass("side-header-narrow-bar-sticky"),window.addEventListener("scroll",(function(){e(this).scrollTop()>t.adminBarHeight()+e(".side-header-narrow-bar-top").height()?e(".side-header-narrow-bar-top").addClass("side-header-narrow-bar-sticky"):e(".side-header-narrow-bar-top").removeClass("side-header-narrow-bar-sticky")}),{passive:!0})),e(".side-header-narrow-bar .hamburguer-btn").on("click",(function(){e(this).toggleClass("active"),e("#header").toggleClass("side-header-visible"),e(this).closest(".side-header-narrow-bar-top").length&&!e("#header > .hamburguer-btn").length&&e(this).closest(".side-header-narrow-bar-top").toggle()})),e(".hamburguer-close").on("click",(function(){e(".side-header-narrow-bar .hamburguer-btn").trigger("click")})),i}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{Search:{defaults:{popup:e(".searchform-popup"),form:e(".searchform")},initialize:function(t,e){return this.$popup=t||this.defaults.popup,this.$form=e||this.defaults.form,this.build().events(),this},build:function(){var t=this.$form.find(".text input"),i=this.$form.find(".cat");return e(".searchform .cat").get(0)&&e.fn.selectric&&e(".searchform .cat").selectric({arrowButtonMarkup:"",expandToItemText:!0,maxHeight:240}),t.on("change",(function(){var i=e(this),o=i.val();t.each((function(){i!=e(this)&&e(this).val(o)}))})),i.on("change",(function(){var t=e(this),o=t.val();i.each((function(){t!=e(this)&&e(this).val(o)}))})),this},events:function(){var t=this;return t.$popup.on("click",(function(t){t.stopPropagation()})),t.$popup.find(".search-toggle").on("click",(function(i){i.preventDefault(),e(this).toggleClass("opened"),e(this).next().toggle(),e(this).hasClass("opened")&&(e("#mini-cart.open").removeClass("open"),e(this).next().find('input[type="text"]').focus(),t.$popup.find(".btn-close-search-form").length&&t.$popup.parent().addClass("position-static")),i.preventDefault(),i.stopPropagation()})),e("html,body").on("click",(function(){t.removeFormStyle()})),"ontouchstart"in document||e(window).on("resize",(function(){t.removeFormStyle()})),e(".btn-close-search-form").on("click",(function(e){e.preventDefault(),t.removeFormStyle()})),t},removeFormStyle:function(){this.$form.removeAttr("style"),this.$popup.find(".search-toggle").removeClass("opened"),this.$popup.find(".btn-close-search-form").length&&this.$popup.parent().removeClass("position-static")}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{HashScroll:{initialize:function(){return this.build().events(),this},build:function(){try{var i=window.location.hash,o=e(i);return o.length&&"#review_form"!=i&&"#reviews"!=i&&-1==i.indexOf("#comment-")&&e("html, body").delay(600).stop().animate({scrollTop:o.offset().top-t.StickyHeader.sticky_height-t.adminBarHeight()-t.sticky_nav_height+1},600,"easeOutQuad"),this}catch(t){return this}},getTarget:function(t){if("#"==t||t.endsWith("#"))return!1;var i;if(0==t.indexOf("#"))i=e(t);else{var o=window.location.href;-1!=(o=o.substring(o.indexOf("://")+3)).indexOf("#")&&(o=o.substring(0,o.indexOf("#"))),0==(t=(t=t.substring(t.indexOf("://")+3)).substring(t.indexOf(o)+o.length)).indexOf("#")&&(i=e(t))}return i},activeMenuItem:function(){var i=this,o=e(window).scrollTop(),n=e('.menu-item > a[href*="#"], .porto-sticky-nav .nav > li > a[href*="#"]');return n.length&&n.each((function(){var n=e(this),s=n.attr("href"),a=i.getTarget(s);if(a&&a.get(0))if(n.parent().is(":last-child")&&o+window.innerHeight>=a.offset().top+a.outerHeight())n.parent().siblings().removeClass("active"),n.parent().addClass("active");else{var r=a.offset().top-t.StickyHeader.sticky_height-t.adminBarHeight()-t.sticky_nav_height+1,l=n.parent();r<=o+5?(l.siblings().removeClass("active"),l.addClass("active"),l.closest(".secondary-menu").length&&l.closest("#header").find(".main-menu").eq(0).children(".menu-item.active").removeClass("active")):l.removeClass("active")}})),i},events:function(){var i=this;e('.menu-item > a[href*="#"], .porto-sticky-nav .nav > li > a[href*="#"], a[href*="#"].hash-scroll, .hash-scroll-wrap a[href*="#"]').on("click",(function(o){o.preventDefault();var n=e(this),s=n.attr("href"),a=i.getTarget(s);if(a&&a.get(0)){var r=n.parent(),l=a.offset().top-t.StickyHeader.sticky_height-t.adminBarHeight()-t.sticky_nav_height+1;e("html, body").stop().animate({scrollTop:l},600,"easeOutQuad",(function(){r.siblings().removeClass("active"),r.addClass("active")})),n.closest(".porto-popup-menu.opened").length&&n.closest(".porto-popup-menu.opened").children(".hamburguer-btn").trigger("click")}else"#"==s&&n.closest(".porto-popup-menu.opened").length||n.hasClass("nolink")||(window.location.href=n.attr("href"))}));var o=e('.menu-item > a[href*="#"], .porto-sticky-nav .nav > li > a[href*="#"]');return o.each((function(){var t="-20% 0px -79.9% 0px",n=e(this).parent().is(":last-child");if(n){var s=document.getElementById(this.hash.replace("#",""));if(s&&document.body.offsetHeight-s.offsetTop<window.innerHeight){var a=(window.innerHeight-document.body.offsetHeight+s.offsetTop)/window.innerHeight*.8;t="-"+(20+(a=Math.round(100*a)))+"% 0px -"+(79.9-a)+"% 0px"}}i.scrollSpyIntObs(this.hash,(function(){this&&void 0!==this[0]&&this[0].id&&e('.menu-item > a[href*="#'+this[0].id+'"], .porto-sticky-nav .nav > li > a[href*="#'+this[0].id+'"]').parent().addClass("active").siblings().removeClass("active")}),{rootMargin:t,thresholds:0},!0,n,!0,o,e(this).parent().index())})),i},scrollSpyIntObs:function(t,i,o,n,s,a,r,l){if("undefined"==typeof IntersectionObserver)return this;var d=document.getElementById(t.replace("#",""));if(!d)return this;var h={rootMargin:"0px 0px 200px 0px"};return Object.keys(o).length&&(h=e.extend(h,o)),new IntersectionObserver((function(t){for(var o=0;o<t.length;o++){var n=t[o];if(n.intersectionRatio>0)if("string"==typeof i)Function("return "+i)();else i.call(e(n.target));else 0==a&&s&&r.filter('[href*="'+n.target.id+'"]').parent().prev().addClass("active").siblings().removeClass("active"),a=!1}}),h).observe(d),this}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{SortFilter:{defaults:{filters:".porto-sort-filters ul",elements:".porto-sort-container .row"},initialize:function(t,i){return this.$elements=t||e(this.defaults.elements),this.$filters=i||e(this.defaults.filters),this.build(),this},build:function(){var i=this;return i.$elements.each((function(){var i=e(this);i.isotope({itemSelector:".porto-sort-item",layoutMode:"masonry",getSortData:{popular:"[data-popular] parseInt"},sortBy:"popular",isOriginLeft:!t.rtl}),imagesLoaded(this,(function(){i.data("isotope")&&i.isotope("layout")}))})),i.$filters.each((function(){var i=e(this),o=i.attr("data-sort-id"),n=e("#"+o);n.length&&(i.on("click","li",(function(o){o.preventDefault();var s=e(this);i.find("li").removeClass("active"),s.addClass("active");var a=s.attr("data-sort-by");n.isotope({sortBy:a});var r=s.attr("data-filter-by");r?n.isotope({filter:r}):n.isotope({filter:".porto-sort-item"}),t.refreshVCContent()})),i.find("li[data-active]").trigger("click"))})),i}}})}.apply(this,[window.theme,jQuery]),function(t){var e={$wrapper:t(".footer-reveal"),init:function(){this.build(),this.events()},build:function(){var e=this.$wrapper.outerHeight(!0),i=window.innerHeight-theme.adminBarHeight();t("#header .header-main").length&&(i-=t("#header .header-main").height()),e>i?(t(".footer-wrapper").removeClass("footer-reveal"),t(".page-wrapper").css("margin-bottom",0)):(t(".footer-wrapper").addClass("footer-reveal"),t(".page-wrapper").css("margin-bottom",e),document.body.offsetHeight<window.innerHeight&&(document.body.style.paddingBottom="0.1px"))},events:function(){var e=this;t(window).smartresize((function(){e.build()}))}};t(".footer-reveal").get(0)&&e.init()}(jQuery),function(t,e){"use strict";t=t||{};var i="__floatElement",o=function(t,e){return this.initialize(t,e)};o.defaults={startPos:"top",speed:3,horizontal:!1,transition:!1,transitionDelay:0,transitionDuration:500},o.prototype={initialize:function(t,e){return t.data(i)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(i,this),this},setOptions:function(t){return this.options=e.extend(!0,{},o.defaults,t,{wrapper:this.$el}),this},build:function(){var t,i=this,o=this.options.wrapper,n=e(window);return i.options.style&&o.attr("style",i.options.style),n.width()>767&&("none"==i.options.startPos?t="":"top"==i.options.startPos?(o.css({top:0}),t=""):(o.css({bottom:0}),t="-"),i.options.transition&&o.css({transition:"ease-out transform "+i.options.transitionDuration+"ms "+i.options.transitionDelay+"ms"}),i.movement(t),window.addEventListener("scroll",(function(){i.movement(t)}),{passive:!0})),this},movement:function(t){var i=this,o=this.options.wrapper,n=e(window),s=n.scrollTop(),a=o.offset().top,r=100*(a-s)/n.height();a+o.height()>=s&&a<=s+window.innerHeight&&(i.options.horizontal?o.css({transform:"translate3d("+t+r/i.options.speed+"%, "+t+r/i.options.speed+"%, 0)"}):o.css({transform:"translate3d(0, "+t+r/i.options.speed+"%, 0)"}))}},e.extend(t,{PluginFloatElement:o}),e.fn.themePluginFloatElement=function(t){return this.map((function(){var n=e(this);return n.data(i)?n.data(i):new o(n,t)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";e(document).ready((function(){var i,o=0;if(e(window).smartresize((function(){o!=window.innerWidth&&(t.adminBarHeightNum=null,o=window.innerWidth)})),void 0!==t.ScrollToTop&&t.ScrollToTop.initialize(),setTimeout((function(){porto_init()}),0),t.bodyWidth=t.bodyWidth||document.body.offsetWidth,void 0!==t.MegaMenu&&t.MegaMenu.initialize(),void 0!==t.SidebarMenu&&(t.SidebarMenu.initialize(),e(".sidebar-menu.side-menu-accordion").themeAccordionMenu({open_one:!0})),function(){if(e(".porto-popup-menu").length&&(e(".porto-popup-menu .hamburguer-btn").on("click",(function(i){i.preventDefault();var o=e(this);e(".porto-popup-menu-spacer").length?e(".porto-popup-menu-spacer").remove():(e('<div class="porto-popup-menu-spacer"></div>').insertBefore(o.parent()),e(".porto-popup-menu-spacer").width(o.parent().width())),o.parent().toggleClass("opened"),t.requestFrame((function(){o.toggleClass("active")}))})),e(".porto-popup-menu .main-menu").scrollbar(),e(".porto-popup-menu").on("click","li.menu-item-has-children > a",(function(t){t.preventDefault(),e(this).parent().siblings("li.menu-item-has-children.opened").removeClass("opened"),e(this).parent().toggleClass("opened")}))),js_porto_vars.lazyload_menu){var i,o,n=!1;e(".secondary-menu.mega-menu").length?(i="secondary_menu",o=e(".mega-menu.main-menu")):e(".mega-menu.main-menu:not(.scroll-wrapper)").length?(i="main_menu",o=e(".mega-menu.main-menu:not(.scroll-wrapper)")):e(".toggle-menu-wrap .sidebar-menu").length?(i="toggle_menu",o=e(".toggle-menu-wrap .sidebar-menu")):e(".main-sidebar-menu .sidebar-menu").length?(i="sidebar_menu",o=e(".main-sidebar-menu .sidebar-menu")):e(".header-side-nav .sidebar-menu").length&&(i="header_side_menu",o=e(".header-side-nav .sidebar-menu")),o&&o.length&&("pageload"==js_porto_vars.lazyload_menu?t.lazyload_menu(o,i):"firsthover"==js_porto_vars.lazyload_menu&&o.one("mouseenter touchstart","li.menu-item-has-children",(function(){if(n)return!0;t.lazyload_menu(o,i),n=!0})))}void 0!==t.SideNav&&t.SideNav.initialize(),void 0!==t.StickyHeader&&t.StickyHeader.initialize()}(),void 0!==t.HashScroll&&t.HashScroll.initialize(),js_porto_vars.use_skeleton_screen.length>0&&e(".skeleton-loading").length){var n=(i=e.Deferred(),e((function(){i.resolve(),!0})),i.promise()),s=!1,a=window.MutationObserver||window.WebkitMutationObserver||window.MozMutationObserver;void 0!==a&&(s=new a((function(t,i){for(var o in t){var n=t[o];"childList"==n.type&&e(n.target).trigger("skeleton:initialised")}})));var r=setTimeout((function(){s&&(s.disconnect(),s=void 0)}),4e3);e(".skeleton-loading").each((function(i){var o=e(this),a=function(){var t=e.Deferred();return o.on("skeleton:initialised",(function(e){e.target.classList.contains("skeleton-loading")&&t.resolve(e)})),t.promise()}(),l=e.Deferred().resolve().promise();if(e.when(a,l,n).done((function(i){var o=e(i.target),n=o.siblings(".skeleton-body");n.length||(n=o.parent().parent().parent().find('[class="'+o.attr("class").replace("skeleton-loading","skeleton-body")+'"]')),porto_init(o),o.find(".sidebar-menu:not(.side-menu-accordion)").length&&t.SidebarMenu.initialize(o.find(".sidebar-menu:not(.side-menu-accordion)")),o.trigger("skeleton-loaded"),t.requestTimeout((function(){n.length&&(n.parent().hasClass("yit-wcan-container")?n.parent().remove():n.remove()),o.removeClass("skeleton-loading"),o.closest(".skeleton-loading-wrap")&&o.closest(".skeleton-loading-wrap").removeClass("skeleton-loading-wrap"),(e(document.body).hasClass("elementor-default")||e(document.body).hasClass("elementor-page"))&&e(window).trigger("resize"),t.refreshStickySidebar(!1)}),100),e(".skeleton-loading").length||(clearTimeout(r),s.disconnect(),s=void 0)})),o.children('script[type="text/template"]').length){var d=e(JSON.parse(o.children('script[type="text/template"]').eq(0).html()));o.children('script[type="text/template"]').eq(0).remove(),s&&s.observe(this,{childList:!0,subtree:!1}),o.append(d),s||o.trigger("skeleton:initialised")}}))}e(document).trigger("porto_theme_init")})),e(window).on("load",(function(){setTimeout((function(){void 0!==t.Search&&t.Search.initialize()}),0),void 0!==t.SortFilter&&t.SortFilter.initialize(),e(document).on("click",".sidebar-toggle",(function(t){t.preventDefault();var i=e("html");e(this).siblings(".porto-product-filters").length?i.hasClass("filter-sidebar-opened")?(i.removeClass("filter-sidebar-opened"),e(".sidebar-overlay").removeClass("active")):(i.removeClass("sidebar-opened"),i.addClass("filter-sidebar-opened"),e(".sidebar-overlay").addClass("active")):i.hasClass("sidebar-opened")?(i.removeClass("sidebar-opened"),e(".sidebar-overlay").removeClass("active")):(i.addClass("sidebar-opened"),e(".sidebar-overlay").addClass("active"))})),e(".minicart-offcanvas .cart-head").on("click",(function(){e(this).closest(".minicart-offcanvas").toggleClass("minicart-opened")})),e(".minicart-offcanvas .minicart-overlay").on("click",(function(){e(this).closest(".minicart-offcanvas").removeClass("minicart-opened")})),e(document.body).on("click",".sidebar-overlay",(function(){e("html").removeClass("sidebar-opened"),e("html").removeClass("filter-sidebar-opened"),e(this).removeClass("active")})),e(window).on("resize",(function(t){t.originalEvent&&window.innerWidth>991&&e("html").hasClass("sidebar-opened")&&e(".sidebar-overlay").trigger("click")}));var i=e(".tabs-simple .featured-box .box-content, .porto-content-box .featured-box .box-content, .vc_general.vc_cta3, .match-height");if(i.length)if(e.fn.matchHeight)i.matchHeight();else{var o=document.createElement("script");o.addEventListener("load",(function(t){i.matchHeight()})),o.src=js_porto_vars.ajax_loader_url.replace("/images/ajax-loader@2x.gif","/js/libs/jquery.matchHeight.min.js"),o.async=!0,document.body.appendChild(o)}/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)&&e(".share-whatsapp").css("display","inline-block"),e(document).ajaxComplete((function(t,i,o){/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)&&e(".share-whatsapp").css("display","inline-block")})),window.navigator.userAgent.indexOf("Edge/")>0&&e("html").addClass("ie12"),e(document).on("click",".portfolios-lightbox a.portfolio-link",(function(t){return e(this).find(".thumb-info-zoom").trigger("click"),!1})),e(".porto-faqs").each((function(){e(this).find(".faq .toggle.active").length<1&&(e(this).find(".faq").eq(0).find(".toggle").addClass("active"),e(this).find(".faq").eq(0).find(".toggle-content").show())})),e(document).on("shown.bs.collapse",".collapse",(function(){var i=e(this);t.refreshVCContent(i)})),e(document).on("shown.bs.tab",'a[data-bs-toggle="tab"]',(function(i){var o=e(e(i.target).attr("href"));t.refreshVCContent(o)})),e(".porto-tooltip .tooltip-icon").on("click",(function(){"none"==e(this).parent().children(".tooltip-popup").css("display")?e(this).parent().children(".tooltip-popup").fadeIn(200):e(this).parent().children(".tooltip-popup").fadeOut(200)})),e(".porto-tooltip .tooltip-close").on("click",(function(){e(this).parent().fadeOut(200)}))}))}.apply(this,[window.theme,jQuery]),function(t,e,i){"use strict";e(document).ready((function(){e(window).on("vc_reload",(function(){porto_init(),e(".type-post").addClass("post"),e(".type-portfolio").addClass("portfolio"),e(".type-member").addClass("member"),e(".type-block").addClass("block")}))}));var o={$timeline:e("#exp-timeline"),$timelineBar:e("#exp-timeline .timeline-bar"),$firstTimelineItem:e("#exp-timeline .timeline-box").first(),$lastTimelineItem:e("#exp-timeline .timeline-box").last(),build:function(){this.adjustHeight()},adjustHeight:function(){var t=this,e=t.$firstTimelineItem.outerHeight(!0)/2+5,i=t.$lastTimelineItem.outerHeight(!0)/2+5;t.$timelineBar.css({top:e,bottom:i})}};if(e("#exp-timeline").get(0)){var n=null;e(window).smartresize((function(){n&&clearTimeout(n),n=setTimeout((function(){o.build()}),800)})),o.build()}e(".custom-view-our-location").on("click",(function(t){t.preventDefault();var i=e(this);e(".custom-googlemap").slideDown("1000",(function(){i.delay(700).hide()}))}))}(window.theme,jQuery),function(t,e,i){"use strict";if(window.onload=function(){t.isLoaded=!0},e(document).ready((function(){if(e(".porto-u-heading").each((function(){var t=e(this).attr("data-halign");"line_only"==e(this).attr("data-hspacer")&&("right"==t||"left"==t?"auto"!=e(this).find(".porto-u-heading-spacer").find(".porto-u-headings-line")[0].style.width&&e(this).find(".porto-u-heading-spacer").find(".porto-u-headings-line").css({float:t}):e(this).find(".porto-u-heading-spacer").find(".porto-u-headings-line").css({margin:"0 auto"}))})),"undefined"!=typeof elementorFrontend&&e(window).on("elementor/frontend/init",(function(){elementorFrontend.hooks.addFilter("frontend/handlers/menu_anchor/scroll_top_distance",(function(e){return t&&t.StickyHeader&&void 0!==t.sticky_nav_height&&(elementorFrontend.elements.$wpAdminBar.length&&(e+=elementorFrontend.elements.$wpAdminBar.height()),e=e-t.adminBarHeight()-t.StickyHeader.sticky_height-t.sticky_nav_height+1),e}))})),js_porto_vars.user_edit_pages){var i=function(t){[].slice.call(t.querySelectorAll(".pb-edit-link")).map((function(t){var e=t.getAttribute("data-title");if(t.nextSibling&&t.nextSibling.classList.contains("porto-block")){var i=t.nextSibling;i.classList.add("has-pb-edit");var o=new bootstrap.Tooltip(i,{html:!0,template:'<div class="tooltip porto-tooltip-wrap" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"manual",title:'<a href="'+t.getAttribute("data-link")+'"><i class="porto-icon-edit me-1"></i>'+e+"</a>",delay:300});o&&o._element&&(o._element.addEventListener("mouseenter",(function(t){o._enter(t,o)})),o._element.addEventListener("mouseleave",(function(t){o._leave(t,o)})))}t.parentNode.removeChild(t)}))};i(document.body),e(".skeleton-loading").on("skeleton-loaded",(function(){i(this)})),e(document.body).on("mouseenter mouseleave",'.porto-tooltip-wrap[role="tooltip"]',(function(t){var i=e('.porto-block[aria-describedby="'+e(this).attr("id")+'"]');if(i.length){var o=bootstrap.Tooltip.getInstance(i.get(0));if(o)o["mouseenter"==t.type?"_enter":"_leave"](t,o)}})).on("porto_init_start",(function(t,e){e.classList.contains("porto-posts-grid")&&i(e)}))}})),e(".porto-btn[data-hover]").on("mouseenter",(function(){var t=e(this).data("hover"),i=e(this).data("border-hover");t&&(e(this).data("originalColor",e(this).css("color")),e(this).css("color",t)),i&&(e(this).data("originalBorderColor",e(this).css("border-color")),e(this).css("border-color",i))})).on("mouseleave",(function(){var t=e(this).data("originalColor"),i=e(this).data("originalBorderColor");t&&e(this).css("color",t),i&&e(this).css("border-color",i)})),e("#footer .widget_wysija .wysija-submit:not(.btn)").addClass("btn btn-default"),e("[data-vc-parallax] .owl-carousel").length&&t.requestTimeout((function(){"object"==typeof window.vcParallaxSkroll&&window.vcParallaxSkroll.refresh()}),200),e(".page-content > .alignfull, .post-content > .alignfull").length){var o=function(){e(".page-content > .alignfull, .post-content > .alignfull").each((function(){e(this).css("left",-1*e(this).parent().offset().left).css("right",-1*e(this).parent().offset().left).css("width",e("body").width()-(parseInt(e(this).css("margin-left"),10)+parseInt(e(this).css("margin-right"),10)))}))};o(),e(window).smartresize((function(){o()}))}}(window.theme,jQuery),function(t,e){"use strict";var i=e("#header .header-main"),o=e("#header .main-menu-wrap");e(".porto-sticky-navbar").length>0&&window.addEventListener("scroll",(function(){if(window.innerWidth<576){var t=-1,n=e(window).scrollTop();i.length&&(t=Math.max(i.scrollTop()+i.height(),t)),o.length&&(t=Math.max(o.scrollTop()+o.height(),t)),t<=0&&(t=e("#header").length>0&&e("#header").height()>10?e("#header").scrollTop()+e("#header").height():100),t<=n?e(".porto-sticky-navbar").addClass("fixed"):e(".porto-sticky-navbar").removeClass("fixed")}}),{passive:!0})}(window.theme,jQuery);
(function(t,e){"use strict";t=t||{},e.extend(t,{mfpConfig:{tClose:js_porto_vars.popup_close,tLoading:'<div class="porto-ajax-loading"><i class="porto-loading-icon"></i></div>',gallery:{tPrev:js_porto_vars.popup_prev,tNext:js_porto_vars.popup_next,tCounter:js_porto_vars.mfp_counter},image:{tError:js_porto_vars.mfp_img_error},ajax:{tError:js_porto_vars.mfp_ajax_error},callbacks:{open:function(){e("body").addClass("lightbox-opened"),this.st.fixedContentPos&&e("#header.sticky-header .header-main.sticky, #header.sticky-header .main-menu-wrap, .fixed-header #header.sticky-header .header-main, .fixed-header #header.sticky-header .main-menu-wrap").css(t.rtl_browser?"left":"right",t.getScrollbarWidth());var a=e(this._lastFocusedEl);if(a.closest(".portfolios-lightbox").hasClass("with-thumbs")&&e(document).width()>=1024){var i=a.closest(".portfolios-lightbox.with-thumbs").find(".porto-portfolios-lighbox-thumbnails").clone(),o=e.magnificPopup.instance;e("body").prepend(i);var n=e("body > .porto-portfolios-lighbox-thumbnails").children(".owl-carousel");n.themeCarousel(n.data("plugin-options")),n.trigger("refresh.owl.carousel");var s=n.find(".owl-stage");s.find(".owl-item").removeClass("current"),s.find(".owl-item").eq(o.currItem.index).addClass("current"),e.magnificPopup.instance.next=function(){var t=e.magnificPopup.instance;e.magnificPopup.proto.next.call(this),s.find(".owl-item").removeClass("current"),s.find(".owl-item").eq(t.currItem.index).addClass("current")},e.magnificPopup.instance.prev=function(){var t=e.magnificPopup.instance;e.magnificPopup.proto.prev.call(this),s.find(".owl-item").removeClass("current"),s.find(".owl-item").eq(t.currItem.index).addClass("current")},s.find(".owl-item").on("click",(function(){s.find(".owl-item").removeClass("current"),e.magnificPopup.instance.goTo(e(this).index()),e(this).addClass("current")}))}},close:function(){e("body").removeClass("lightbox-opened"),this.st.fixedContentPos&&e("#header.sticky-header .header-main.sticky, #header.sticky-header .main-menu-wrap, .fixed-header #header.sticky-header .header-main, .fixed-header #header.sticky-header .main-menu-wrap").css(t.rtl_browser?"left":"right",""),e(".owl-carousel .owl-stage").each((function(){var t=e(this),a=t.width()+parseInt(t.css("padding-left"))+parseInt(t.css("padding-right"));t.css({width:a+200}),setTimeout((function(){t.css({width:a})}),0)})),e(this._lastFocusedEl).parents(".portfolios-lightbox").hasClass("with-thumbs")&&e(document).width()>=1024&&e(" body > .porto-portfolios-lighbox-thumbnails").remove()}}}})}).apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var a="__animate",i=function(t,e){return this.initialize(t,e)};i.defaults={accX:0,accY:-120,delay:1,duration:1e3},i.prototype={initialize:function(t,e){return t.data(a)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(a,!0),this},setOptions:function(t){return this.options=e.extend(!0,{},i.defaults,t,{wrapper:this.$el}),this},build:function(){var a,i,o=this.options.wrapper;if(o.data("appear-animation-svg"))return o.find("[data-appear-animation]").each((function(){var a,i=e(this),o=t.getOptions(i.data("plugin-options"));o&&(a=o),i.themeAnimate(a)})),this;o.addClass("appear-animation");var n=o.get(0);return(a=Math.abs(o.data("appear-animation-delay")?o.data("appear-animation-delay"):this.options.delay))>1&&(n.style.animationDelay=a+"ms"),1e3!=(i=Math.abs(o.data("appear-animation-duration")?o.data("appear-animation-duration"):this.options.duration))&&(n.style.animationDuration=i+"ms"),o.addClass(o.data("appear-animation")+" appear-animation-visible"),this}},e.extend(t,{Animate:i}),e.fn.themeAnimate=function(i){return this.map((function(){var o=e(this);return o.data(a)?o:new t.Animate(o,i)}))}}.apply(this,[window.theme,jQuery]),function(t,e){t=t||{};var a="__animatedLetters",i=function(t,e){return this.initialize(t,e)};i.defaults={animationName:"typeWriter",animationSpeed:50,startDelay:500,minWindowWidth:768,letterClass:""},i.prototype={initialize:function(t,e){if(t.data(a))return this;return this.$el=t,this.initialText=t.text(),this.timeoutId=null,this.setData().setOptions(e).build().events(),this},setData:function(){return this.$el.data(a,this),this},setOptions:function(t){return this.options=e.extend(!0,{},i.defaults,t,{wrapper:this.$el}),this},build:function(){var t=this,a=t.$el.text().split("");if(e(window).width()<t.options.minWindowWidth)return t.$el.addClass("initialized"),this;if(t.options.firstLoadNoAnim)return t.$el.css({visibility:"visible"}),t.$el.closest(".owl-carousel").get(0)&&setTimeout((function(){t.$el.closest(".owl-carousel").on("change.owl.carousel",(function(){t.options.firstLoadNoAnim=!1,t.build()}))}),500),this;if(t.$el.addClass("initialized"),t.setMinHeight(),t.$el.text(""),"typeWriter"==t.options.animationName){t.$el.append('<span class="letters-wrapper"></span><span class="typeWriter"></pre>');var i=0,o=function(){var e=setTimeout((function(){var e=a[i];t.$el.find(".letters-wrapper").append('<span class="letter '+(t.options.letterClass?t.options.letterClass+" ":"")+'">'+e+"</span>"),i++,o()}),t.options.animationSpeed);i>=a.length&&clearTimeout(e)};o()}else this.timeoutId=setTimeout((function(){for(var e=0;e<a.length;e++){var i=a[e];t.$el.append('<span class="letter '+(t.options.letterClass?t.options.letterClass+" ":"")+t.options.animationName+' animated" style="animation-delay: '+e*t.options.animationSpeed+'ms;">'+i+"</span>")}}),t.options.startDelay);return this},setMinHeight:function(){var t=this;return t.$el.closest(".owl-carousel").get(0)?(t.$el.closest(".owl-carousel").addClass("d-block"),t.$el.css("min-height",t.$el.height()),t.$el.closest(".owl-carousel").removeClass("d-block")):t.$el.css("min-height",t.$el.height()),this},destroy:function(){return this.$el.html(this.initialText).css("min-height",""),this.timeoutId&&(clearTimeout(this.timeoutId),this.timeoutId=null),this},events:function(){var t=this;return t.$el.on("animated.letters.destroy",(function(){t.destroy()})),t.$el.on("animated.letters.initialize",(function(){t.build()})),this}},e.extend(t,{PluginAnimatedLetters:i}),e.fn.themePluginAnimatedLetters=function(t){return this.map((function(){var o=e(this);return o.data(a)?o.data(a):new i(o,t)}))}}.apply(this,[window.theme,jQuery]),"function"==typeof jQuery.fn.owlCarousel&&function(t,e){"use strict";t=t||{};var a="__carousel",i=function(t,e){return this.initialize(t,e)};i.defaults=e.extend({},{loop:!0,navText:[],themeConfig:!1,lazyLoad:!0,lg:0,md:0,sm:0,xs:0,single:!1,rtl:t.rtl}),i.prototype={initialize:function(t,e){return t.data(a)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(a,!0),this},setOptions:function(a){return a&&a.themeConfig||!a?this.options=e.extend(!0,{},i.defaults,t.owlConfig,a,{wrapper:this.$el,themeConfig:!0}):this.options=e.extend(!0,{},i.defaults,a,{wrapper:this.$el}),this},calcOwlHeight:function(t){var a=0;t.find(".owl-item.active").each((function(){a<e(this).height()&&(a=e(this).height())})),t.children(".owl-stage-outer").height(a)},build:function(){if(!e.fn.owlCarousel)return this;var a,i=this.options.wrapper,o=this.options.loop,n=this.options.lg,s=this.options.md,r=this.options.sm,l=this.options.xs,d=this.options.single,p=i.find(".zoom").get(0),c={},h=i.find(".owl-item").length>0?i.find(".owl-item:not(.cloned)").length:i.find("> *").length;void 0!==this.options.fullscreen&&this.options.fullscreen;if(d)a=1;else if(void 0!==this.options.responsive)for(var f in this.options.responsive){var u=Number(this.options.responsive[f]);c[Number(f)]={items:u,loop:!!(o&&h>=u)}}else{a=this.options.items?this.options.items:n||1,(this.options.xl||n||s||r||l)&&(this.options.xl?c[1400]={items:this.options.xl,loop:!!(o&&h>this.options.xl),mergeFit:this.options.mergeFit}:n&&a>n+1&&(c[1400]={items:a,loop:!!(o&&h>a),mergeFit:this.options.mergeFit},c[t.screen_lg]={items:n+1,loop:!!(o&&h>n+1),mergeFit:this.options.mergeFit}),void 0===c[t.screen_lg]&&(c[t.screen_lg]={items:a,loop:!!(o&&h>=a),mergeFit:this.options.mergeFit}),n&&(c[992]={items:n,loop:!!(o&&h>=n),mergeFit:this.options.mergeFit_lg}),s&&(c[768]={items:s,loop:!!(o&&h>s),mergeFit:this.options.mergeFit_md}),c[576]=r?{items:r,loop:!!(o&&h>r),mergeFit:this.options.mergeFit_sm}:{items:1,mergeFit:!1},c[0]=l?{items:l,loop:!!(o&&h>l),mergeFit:this.options.mergeFit_xs}:{items:1})}if(!i.hasClass("show-nav-title")&&this.options.themeConfig&&t.slider_nav&&t.slider_nav_hover&&i.addClass("show-nav-hover"),this.options=e.extend(!0,{},this.options,{items:a,loop:!!(o&&h>a),responsive:c,onInitialized:function(){i.hasClass("stage-margin")&&i.find(".owl-stage-outer").css({"margin-left":this.options.stagePadding,"margin-right":this.options.stagePadding});var t=".porto-u-heading, .vc_custom_heading, .slider-title, .elementor-widget-heading, .porto-heading";if(i.hasClass("show-dots-title")&&(i.prev(t).length||i.closest(".slider-wrapper").prev(t).length||i.closest(".porto-recent-posts").prev(t).length||i.closest(".elementor-widget-porto_recent_posts, .elementor-section").prev(t).length)){var e=i.prev(t);e.length||(e=i.closest(".slider-wrapper").prev(t)),e.length||(e=i.closest(".porto-recent-posts").prev(t)),e.length||(e=i.closest(".elementor-widget-porto_recent_posts, .elementor-section").prev(t));try{var a=e.addClass("w-auto").css("display","inline-block").width();e.removeClass("w-auto").css("display",""),a+15+i.find(".owl-dots").width()<=e.width()?(i.find(".owl-dots").css("left",a+15+(i.width()-e.width())/2),i.find(".owl-dots").css("top",-1*e.height()/2-parseInt(e.css("margin-bottom"))-i.find(".owl-dots").height()/2+2)):i.find(".owl-dots").css("position","static")}catch(t){}}}}),this.options.autoHeight){var m=this;e(window).on("resize",(function(){m.calcOwlHeight(i)})),t.isLoaded?setTimeout((function(){m.calcOwlHeight(i)}),100):e(window).on("load",(function(){m.calcOwlHeight(i)}))}var g=!1;if(p){g=[];var v=0;i.find(".zoom").each((function(){var t={},a=e(this);t.src=a.data("src")?a.data("src"):a.data("mfp-src"),t.title=a.data("title"),g[v]=t,a.data("index",v),v++}))}return i.hasClass("show-nav-title")?this.options.stagePadding=0:(this.options.themeConfig&&t.slider_nav&&t.slider_nav_hover&&i.addClass("show-nav-hover"),this.options.themeConfig&&!t.slider_nav_hover&&t.slider_margin&&i.addClass("stage-margin")),i.hasClass("has-ccols-spacing")&&i.removeClass("has-ccols-spacing"),i.owlCarousel(this.options),p&&g&&i.on("click",".zoom",(function(a){if(a.preventDefault(),e.fn.magnificPopup){var o=e(this).data("index");void 0===o&&(o=(e(this).closest(".owl-item").index()-i.find(".cloned").length/2)%i.data("owl.carousel").items().length),e.magnificPopup.close(),e.magnificPopup.open(e.extend(!0,{},t.mfpConfig,{items:g,gallery:{enabled:!0},type:"image"}),o)}return!1})),this}},e.extend(t,{Carousel:i}),e.fn.themeCarousel=function(i,o){return this.map((function(){var n=e(this);return n.data(a)?n:new t.Carousel(n,i,o)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var a="__lightbox",i=function(t,e){return this.initialize(t,e)};i.defaults={callbacks:{open:function(){e("body").addClass("lightbox-opened")},close:function(){e("body").removeClass("lightbox-opened")}}},i.prototype={initialize:function(t,e){return t.data(a)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(a,this),this},setOptions:function(a){return this.options=e.extend(!0,{},i.defaults,t.mfpConfig,a,{wrapper:this.$el}),this},build:function(){return e.fn.magnificPopup?(this.options.wrapper.magnificPopup(this.options),this):this}},e.extend(t,{Lightbox:i}),e.fn.themeLightbox=function(i){return this.map((function(){var o=e(this);return o.data(a)?o.data(a):new t.Lightbox(o,i)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var a="__toggle",i=function(t,e){return this.initialize(t,e)};i.defaults={},i.prototype={initialize:function(t,e){return t.data(a)||(this.$el=t,this.setData().setOptions(e).build()),this},setData:function(){return this.$el.data(a,this),this},setOptions:function(t){return this.options=e.extend(!0,{},i.defaults,t,{wrapper:this.$el}),this},build:function(){return this.options.container.parent().magnificPopup(e.extend(!0,{},t.mfpConfig,{delegate:".porto-vc-zoom",gallery:{enabled:!0},mainClass:"mfp-with-zoom",zoom:{enabled:!0,duration:300},type:"image"})),this}},e.extend(t,{VcImageZoom:i}),e.fn.themeVcImageZoom=function(i){return this.map((function(){var o=e(this);return o.data(a)?o.data(a):new t.VcImageZoom(o,i)}))}}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";var a;t=t||{},e.extend(t,{PostAjaxModal:{defaults:{elements:".page-portfolios"},initialize:function(t,a){return this.$elements=t||e(this.defaults.elements),void 0===a&&(a="portfolio"),this.build(a),this},build:function(i){var o={$wrapper:null,modals:[],currentModal:0,total:0,p_type:"portfolio",build:function(t,a){var i=this;i.$wrapper=t,i.$wrapper&&(i.modals=[],i.total=0,i.p_type=a,t.find("a[data-ajax-on-modal]").each((function(){i.add(e(this))})),t.off("mousedown","a[data-ajax-on-modal]").on("mousedown","a[data-ajax-on-modal]",(function(t){if(2==t.which)return t.preventDefault(),!1})))},add:function(t){var e=this,a=t.attr("href"),i=e.total;e.modals.push({src:a}),e.total++,t.off("click").on("click",(function(t){return t.preventDefault(),e.show(i),!1}))},next:function(){var t=this;t.currentModal+1<t.total?t.show(t.currentModal+1):t.show(0)},prev:function(){var t=this;t.currentModal-1>=0?t.show(t.currentModal-1):t.show(t.total-1)},show:function(i){var o=this;if(o.currentModal=i,i<0||i>o.total-1)return!1;e.magnificPopup.close(),e.magnificPopup.open(e.extend(!0,{},t.mfpConfig,{type:"ajax",items:o.modals,gallery:{enabled:!0},ajax:{settings:{type:"post",data:{ajax_action:o.p_type+"_ajax_modal"}}},mainClass:o.p_type+"-ajax-modal",fixedContentPos:!1,callbacks:{parseAjax:function(t){var a=e(t.data),i=a.find("#content article."+o.p_type),n=a.filter('style[data-type]:not("")'),s="";n.each((function(){s+=e(this).text()})),e("#"+o.p_type+"AjaxCSS").get(0)?e("#"+o.p_type+"AjaxCSS").text(s):e('<style id="'+o.p_type+'AjaxCSS">'+s+"</style>").appendTo("head"),i.find("."+o.p_type+"-nav-all").html('<a href="#" data-ajax-'+o.p_type+'-close data-bs-tooltip data-original-title="'+js_porto_vars.popup_close+'" data-bs-placement="bottom"><i class="fas fa-th"></i></a>'),i.find("."+o.p_type+"-nav").html('<a href="#" data-ajax-'+o.p_type+'-prev class="'+o.p_type+'-nav-prev" data-bs-tooltip data-original-title="'+js_porto_vars.popup_prev+'" data-bs-placement="bottom"><i class="fa"></i></a><a href="#" data-toggle="tooltip" data-ajax-'+o.p_type+'-next class="'+o.p_type+'-nav-next" data-bs-tooltip data-original-title="'+js_porto_vars.popup_next+'" data-bs-placement="bottom"><i class="fa"></i></a>'),i.find(".elementor-invisible").removeClass("elementor-invisible"),t.data='<div class="ajax-container">'+i.html()+"</div>"},ajaxContentAdded:function(){var i=e("."+o.p_type+"-ajax-modal");i.find("a[data-ajax-"+o.p_type+"-close]").on("click",(function(t){return t.preventDefault(),e.magnificPopup.close(),!1})),a=i.find(".rev_slider, rs-module"),o.modals.length<=1?i.find("a[data-ajax-"+o.p_type+"-prev], a[data-ajax-"+o.p_type+"-next]").remove():(i.find("a[data-ajax-"+o.p_type+"-prev]").on("click",(function(t){if(t.preventDefault(),a&&a.get(0))try{a.revkill()}catch(t){}return i.find(".mfp-arrow-left").trigger("click"),!1})),i.find("a[data-ajax-"+o.p_type+"-next]").on("click",(function(t){if(t.preventDefault(),a&&a.get(0))try{a.revkill()}catch(t){}return i.find(".mfp-arrow-right").trigger("click"),!1}))),"portfolio"==o.p_type&&e(window).trigger("resize"),porto_init(),t.refreshVCContent(i),setTimeout((function(){var t=i.find("video");t.get(0)&&t.each((function(){e(this)[0].play(),e(this).parent().parent().parent().find(".video-controls").attr("data-action","play"),e(this).parent().parent().parent().find(".video-controls").html('<i class="ult-vid-cntrlpause"></i>')}))}),600),i.off("scroll").on("scroll",(function(){e.fn.appear.run()}))},change:function(){e(".mfp-wrap .ajax-container").trigger("click")},beforeClose:function(){if(a&&a.get(0))try{a.revkill()}catch(t){}e("."+o.p_type+"-ajax-modal").off("scroll")}}}),i)}};return this.$elements.each((function(){var t=e(this);t.find("a[data-ajax-on-modal]").get(0)&&(t.data(i+"AjaxOnModal")||(o.build(t,i),t.data(i+"AjaxOnModal",o)))})),this}}}),e(document.documentElement).on("keydown",(function(t){try{37!=t.keyCode&&39!=t.keyCode||a&&a.get(0)&&a.revkill()}catch(t){}}))}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";var a;t=t||{},e.extend(t,{PortfolioAjaxPage:{defaults:{elements:".page-portfolios"},initialize:function(t){return this.$elements=t||e(this.defaults.elements),this.build(),this},build:function(){return this.$elements.each((function(){var i=e(this);if(i.find("#portfolioAjaxBox").get(0)&&!i.data("portfolioAjaxOnPage")){var o={$wrapper:e(this),pages:[],currentPage:0,total:0,$ajaxBox:i.find("#portfolioAjaxBox"),$ajaxBoxContent:i.find("#portfolioAjaxBoxContent"),build:function(){var t=this;t.pages=[],t.total=0,i.find("a[data-ajax-on-page]").each((function(){t.add(e(this))})),i.off("mousedown","a[data-ajax-on-page]").on("mousedown","a[data-ajax-on-page]",(function(t){if(2==t.which)return t.preventDefault(),!1}))},add:function(t){var e=this,a=t.attr("href");e.pages.push(a),e.total++,t.off("click").on("click",(function(t){t.preventDefault();var i=t.target.className;return"owl-next"==i||"owl-prev"==i||e.show(e.pages.indexOf(a)),!1}))},events:function(){var t=this;i.off("click","a[data-ajax-portfolio-close]").on("click","a[data-ajax-portfolio-close]",(function(e){return e.preventDefault(),t.close(),!1})),t.total<=1?e("a[data-ajax-portfolio-prev], a[data-ajax-portfolio-next]").remove():(i.off("click","a[data-ajax-portfolio-prev]").on("click","a[data-ajax-portfolio-prev]",(function(e){return e.preventDefault(),t.prev(),!1})),i.off("click","a[data-ajax-portfolio-next]").on("click","a[data-ajax-portfolio-next]",(function(e){return e.preventDefault(),t.next(),!1})))},close:function(){var t=this;if(t.$ajaxBoxContent.find(".rev_slider, rs-module").get(0))try{t.$ajaxBoxContent.find(".rev_slider, rs-module").revkill()}catch(t){}t.$ajaxBoxContent.empty(),t.$ajaxBox.removeClass("ajax-box-init").removeClass("ajax-box-loading")},next:function(){var t=this;t.currentPage+1<t.total?t.show(t.currentPage+1):t.show(0)},prev:function(){var t=this;t.currentPage-1>=0?t.show(t.currentPage-1):t.show(t.total-1)},show:function(i){var o=this;if(a=null,o.$ajaxBoxContent.find(".rev_slider, rs-module").get(0))try{o.$ajaxBoxContent.find(".rev_slider, rs-module").revkill()}catch(t){}if(o.$ajaxBoxContent.empty(),o.$ajaxBox.removeClass("ajax-box-init").addClass("ajax-box-loading"),t.scrolltoContainer(o.$ajaxBox),o.currentPage=i,i<0||i>o.total-1)return o.close(),!1;e.ajax({url:o.pages[i],complete:function(i){var n=e(i.responseText),s=n.find("#content article.portfolio");n.filter('style[data-type]:not("")');e("#portfolioAjaxCSS").get(0)?e("#portfolioAjaxCSS").text(""):e('<style id="portfolioAjaxCSS"></style>').appendTo("head"),s.find(".portfolio-nav-all").html('<a href="#" data-ajax-portfolio-close data-bs-tooltip data-original-title="'+js_porto_vars.popup_close+'"><i class="fas fa-th"></i></a>'),s.find(".portfolio-nav").html('<a href="#" data-ajax-portfolio-prev class="portfolio-nav-prev" data-bs-tooltip data-original-title="'+js_porto_vars.popup_prev+'"><i class="fa"></i></a><a href="#" data-toggle="tooltip" data-ajax-portfolio-next class="portfolio-nav-next" data-bs-tooltip data-original-title="'+js_porto_vars.popup_next+'"><i class="fa"></i></a>'),o.$ajaxBoxContent.html(s.html()).append('<div class="row"><div class="col-lg-12"><hr class="tall"></div></div>'),o.$ajaxBox.removeClass("ajax-box-loading"),e(window).trigger("resize"),porto_init(),t.refreshVCContent(o.$ajaxBoxContent),o.events(),a=o,o.$ajaxBoxContent.find(".lightbox:not(.manual)").each((function(){var t,a=e(this),i=a.data("plugin-options");i&&(t=i),a.themeLightbox(t)}))}})}};o.build(),i.data("portfolioAjaxOnPage",o)}})),this}}}),e(document.documentElement).on("keyup",(function(t){try{if(!a)return;39==t.keyCode&&a.next(),37==t.keyCode&&a.prev()}catch(t){}}))}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{PostFilter:{cache:{},defaults:{elements:".portfolio-filter"},initialize:function(t,a){return this.$elements=t||e(this.defaults.elements),this.build(a),this},filterFn:function(a){if(void 0!==a&&void 0!==a.data&&void 0!==a.data.elements&&a.data.elements&&a.data.elements.length){var i=a.data.selfobj;if(i.isLoading)return!1;var o=a.data.thisobj,n=(a.data.elements,a.data.position),s=a.data.post_type,r=a.data.parent,l=a.data.posts_wrap,d=a.data.use_ajax,p=a.data.page_path,c=a.data.infinite_load,h=a.data.load_more;if(a.preventDefault(),!e(this).hasClass("active")){i.isLoading=!0;var f=e(this).attr("data-filter");if("sidebar"==n&&e(".sidebar-overlay").trigger("click"),o.find(".active").removeClass("active"),d){var u="*"==f?"":f;p||(p=l.data("page_path")),p&&l.data("page_path",p.replace(/&category=[^&]*&/,"&category="+u+"&")),e(this).addClass("active"),i.load_posts(u,!(!c&&!h),r,s,l,void 0,e(this).children("a").attr("href"))}else if("faq"==s)r.find(".faq").each((function(){var t=e(this),a="easeInOutQuart";"*"==f||t.hasClass(f)?("none"==t.css("display")&&t.stop(!0).slideDown(300,a,(function(){e(this).attr("style","").show()})),m++):"none"!=t.css("display")&&t.stop(!0).slideUp(300,a,(function(){e(this).attr("style","").hide()}))})),!m&&r.find(".faqs-infinite").length&&void 0!==e.fn.infinitescroll&&r.find(".faqs-infinite").infinitescroll("retrieve");else if(r.hasClass("portfolios-timeline")){var m=0;r.find(".portfolio").each((function(){var t=e(this),a="easeInOutQuart";"*"==f||t.hasClass(f)?("none"==t.css("display")&&t.stop(!0).slideDown(300,a,(function(){e(this).attr("style","").show()})),m++):"none"!=t.css("display")&&t.stop(!0).slideUp(300,a,(function(){e(this).attr("style","").hide()}))})),!m&&r.find(".portfolios-infinite").length&&void 0!==e.fn.infinitescroll&&r.find(".portfolios-infinite").infinitescroll("retrieve"),setTimeout((function(){t.FilterZoom.initialize(r)}),400)}else r.find("."+s+"-row").isotope({filter:"*"==f?f:"."+f});return d||(e(this).addClass("active"),i.isLoading=!1),"sidebar"==n&&i.$elements.each((function(){var t=e(this);t==o&&"sidebar"!=t.data("position")||(t.find("li").removeClass("active"),t.find('li[data-filter="'+f+'"]').addClass("active"))})),d||(window.location.hash="#"+f),t.refreshVCContent(),!1}}},build:function(a){var i=this;return i.$elements.each((function(){var o,n,s=e(this),r=s.data("position");if(n=void 0===a?s.hasClass("member-filter")?"member":s.hasClass("faq-filter")?"faq":s.hasClass("product-filter")?"product":s.hasClass("post-filter")?"post":s.hasClass("portfolio-filter")?"portfolio":s.attr("data-filter-type"):a,(o="sidebar"==r||"global"==r?e(".main-content .page-"+n+"s"):s.closest(".page-"+n+"s")).length||(o=s.closest(".porto-posts-grid")),o&&o.length){var l,d=s.hasClass("porto-ajax-filter"),p=o.hasClass("load-infinite"),c=o.hasClass("load-more"),h=o.find("."+n+"s-container");if(d&&(!p&&!c||!o.data("ajax_load_options"))){var f=window.location.href;-1!==f.indexOf("#")&&(f=f.split("#")[0]),l=t.ajax_url+"?action=porto_ajax_posts&nonce="+js_porto_vars.porto_nonce+"&post_type="+n+"&current_link="+f+"&category=&page=%cur_page%",o.data("post_layout")&&(l+="&post_layout="+o.data("post_layout")),h.data("page_path",l)}s.find("li").on("click",{thisobj:s,selfobj:i,elements:i.$elements,position:r,parent:o,post_type:n,posts_wrap:h,use_ajax:d,page_path:l,infinite_load:p,load_more:c},i.filterFn)}})),e(window).on("hashchange",{elements:i.$elements},i.hashchange),i.hashchange({data:{elements:i.$elements}}),i},hashchange:function(t){if(void 0!==t&&void 0!==t.data&&void 0!==t.data.elements&&t.data.elements&&t.data.elements.length){var a=t.data.elements,i=e(a.get(0)),o=window.location.hash;if(o){var n=i.find('li[data-filter="'+o.replace("#","")+'"]');n.hasClass("active")||n.trigger("click")}}},set_elements:function(t){var a=this;void 0!==t&&t&&t.length?(a.$elements=t,e(window).off("hashchange",a.hashchange).on("hashchange",{elements:t},a.hashchange)):a.destroy(a.$elements)},destroy:function(t){if(void 0!==t&&t&&t.length){t.find("li").off("click",this.filterFn),e(window).off("hashchange",this.hashchange)}},load_posts:function(a,i,o,n,s,r,l){var d=o.attr("id"),p=this,c=o.hasClass("archive-posts"),h=function(h,f){if(h){void 0!==f&&!0===f||void 0!==r||!d||(p.cache[d]||(p.cache[d]={}),p.cache[d][a]=h);var u=e(h),m=o.hasClass("archive-products"),g=u.find(c?".archive-posts .posts-wrap":".posts-wrap").children();if(g.length&&((void 0===s||c)&&(s=o.find("."+n+"s-container")),s.length)){s.data("isotope")?s.isotope("remove",s.children()):s.children().remove(),s.hasClass("owl-loaded")&&s.removeClass("owl-loaded"),s.append(g),t.refreshVCContent(g);var v=o.find("."+n+"-filter");if(v.length&&!v.hasClass("porto-ajax-filter")&&!o.hasClass("load-infinite")&&!o.hasClass("load-more")){var w=u.find((c?".archive-posts ":"")+"."+n+"-filter");w.length&&(v.find("li:first-child").trigger("click"),t.PostFilter.destroy(v),v.replaceWith(w),t.PostFilter.initialize(w,n),t.PostFilter.set_elements(e("ul[data-filter-type]")))}porto_init(o);var x="";x="product"!=n&&"member"!=n&&"faq"!=n&&"portfolio"!=n&&"post"!=n?"ptu":n,t.PostsInfinite[x+"Behavior"](g,s);var y=o.find(".pagination-wrap"),_=u.find((c?".archive-posts ":"")+".pagination-wrap").eq(0),b=!1;if(y.length?_.length?(y.replaceWith(_),b=!0):y.children().remove():_.length&&(o.append(_),b=!0),i){var C=s.data("infinitescroll");if(b){var j=u.find(c?".archive-posts .posts-wrap":".posts-wrap");j.data("cur_page")&&(s.data("cur_page",j.data("cur_page")),s.data("max_page",j.data("max_page")));var k=!0;if(C&&(C.options.state.isDestroyed?s.removeData("infinitescroll"):(k=!1,j.data("cur_page")&&C.update({maxPage:j.data("max_page"),state:{currPage:j.data("cur_page")}}),C.options.state.isPaused&&C.resume())),k){var P=s.data("__postsinfinite");P&&P.destroy(),new t.PostsInfinite(s,"."+n+", .timeline-date",s.data("infiniteoptions"),n)}if(c){var $=s.siblings(".pagination-wrap").find(".next").attr("href");$&&($=($+=(-1!==$.indexOf("?")?"&":"?")+"portoajax=1&load_posts_only=2").replace(/(paged=)(\d+)|(page\/)(\d+)/,"$1$3%cur_page%"),s.data("page_path",$))}new t.PostsInfinite(s,"."+n+", .timeline-date",s.data("infiniteoptions"),n)}}if(c){if(e(".sidebar-content").each((function(t){var a=e(this),i=e(u.find(".sidebar-content").get(t));if(a.html(i.html()),m&&"undefined"!=typeof updateSelect2&&updateSelect2){if(jQuery().selectWoo){a.find("select.woocommerce-widget-layered-nav-dropdown").each((function(){e(this).selectWoo({placeholder:e(this).find("option").eq(0).text(),minimumResultsForSearch:5,width:"100%",allowClear:void 0!==e(this).attr("multiple")&&"multiple"==e(this).attr("multiple")?"false":"true"})}))}e("body").children("span.select2-container").remove()}})),m){var z=u.filter('script:contains("var woocommerce_price_slider_params")').first();if(z&&z.length&&-1!==z.text().indexOf("{")&&-1!==z.text().indexOf("}")){var A=z.text().substring(z.text().indexOf("{"),z.text().indexOf("}")+1);window.woocommerce_price_slider_params=JSON.parse(A)}var D=e(".entry-title");if(D.length){var O=u.find(".entry-title").eq(0);O.length&&D.html(O.html())}var T=e(".entry-description");if(T.length){var I=u.find(".entry-description").eq(0);I.length&&T.html(I.html())}var L=".shop-loop-before",F=e(L);F.length&&(u.find(L).length?F.each((function(t){var a=u.find(L).eq(t);a.length&&e(this).html(a.html()).show()})):F.empty());var B=e(".woocommerce-result-count");if(B.length){var M=u.find(".woocommerce-result-count").eq(0);M.length&&(B[0].outerHTML=M.length?M[0].outerHTML:"")}e(document).trigger("yith-wcan-ajax-filtered")}l&&!navigator.userAgent.match(/msie/i)&&window.history.pushState({pageTitle:h&&h.pageTitle||""},"",l)}e(document.body).trigger("porto_load_posts_end",[o.parent()])}}};if(void 0===r&&void 0!==p.cache[d]&&void 0!==p.cache[d][a]&&p.cache[d][a])return h(p.cache[d][a],!0),p.isLoading=!1,void o.removeClass("porto-ajax-loading").removeClass("loading").find(".porto-loading-icon").remove();var f=o.data("ajax_load_options");if(o.hasClass("archive-products")&&-1!=js_porto_vars.use_skeleton_screen.indexOf("shop")||c&&-1!=js_porto_vars.use_skeleton_screen.indexOf("blog"))if(s=o.find("."+n+"s-container"),f){var u="div";"product"==n&&"ul"==s.get(0).tagName.toLowerCase()&&(u="li"),s.addClass("skeleton-body").empty();for(var m=0;m<Number(f.count||f.columns&&3*f.columns||12);m++)s.append("<"+u+' class="porto-tb-item post '+n+("product"==n?" product-col":"")+'"></'+u+">")}else s.addClass("skeleton-body").children().empty();else o.children(".porto-loading-icon").length||o.append('<i class="porto-loading-icon"></i>'),o.addClass("porto-ajax-loading");var g=window.location.href;-1!==g.indexOf("#")&&(g=g.split("#")[0]);var v,w=t.ajax_url;o.hasClass("archive-posts")?(v={portoajax:!0,load_posts_only:!0},o.closest(".porto-block").length&&(v.builder_id=o.closest(".porto-block").data("id")),w=void 0!==l?l:g):(v={action:"porto_ajax_posts",nonce:js_porto_vars.porto_nonce,post_type:n,current_link:g},o.data("post_layout")&&(v.post_layout=o.data("post_layout")),f&&(v.extra=f),void 0!==r&&(v=e.extend(v,r))),a&&(v.category=a),e.ajax({url:w,type:"post",data:v,success:h,complete:function(){p.isLoading=!1,s.removeClass("skeleton-body"),o.removeClass("porto-ajax-loading").removeClass("loading").find(".porto-loading-icon").remove()}})}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";var a;t=t||{},e.extend(t,{MemberAjaxPage:{defaults:{elements:".page-members"},initialize:function(t){return this.$elements=t||e(this.defaults.elements),this.build(),this},build:function(){return this.$elements.each((function(){var i=e(this);if(i.find("#memberAjaxBox").get(0)){var o={$wrapper:e(this),pages:[],currentPage:0,total:0,$ajaxBox:i.find("#memberAjaxBox"),$ajaxBoxContent:i.find("#memberAjaxBoxContent"),build:function(){var t=this;t.pages=[],t.total=0,i.find("a[data-ajax-on-page]").each((function(){t.add(e(this))})),i.off("mousedown","a[data-ajax-on-page]").on("mousedown","a[data-ajax-on-page]",(function(t){if(2==t.which)return t.preventDefault(),!1}))},add:function(t){var e=this,a=t.attr("href");e.pages.push(a),e.total++,t.off("click").on("click",(function(t){return t.preventDefault(),e.show(e.pages.indexOf(a)),!1}))},next:function(){var t=this;t.currentPage+1<t.total?t.show(t.currentPage+1):t.show(0)},prev:function(){var t=this;t.currentPage-1>=0?t.show(t.currentPage-1):t.show(t.total-1)},show:function(i){var o=this;if(a=null,o.$ajaxBoxContent.find(".rev_slider, rs-module").get(0))try{o.$ajaxBoxContent.find(".rev_slider, rs-module").revkill()}catch(t){}if(o.$ajaxBoxContent.empty(),o.$ajaxBox.removeClass("ajax-box-init").addClass("ajax-box-loading"),t.scrolltoContainer(o.$ajaxBox),o.currentPage=i,i<0||i>o.total-1)return o.close(),!1;e.ajax({url:o.pages[i],complete:function(i){var n=e(i.responseText),s=n.find("#content article.member"),r=n.filter('style[data-type]:not("")'),l="";r.each((function(){l+=e(this).text()})),e("#memberAjaxCSS").get(0)?e("#memberAjaxCSS").text(l):e('<style id="memberAjaxCSS">'+l+"</style>").appendTo("head");var d=o.$ajaxBox.find(".ajax-content-append"),p="";d.length&&(p=d.html()),o.$ajaxBoxContent.html(s.html()).prepend('<div class="row"><div class="col-lg-12"><hr class="tall m-t-none"></div></div>').append('<div class="row"><div class="col-md-12"><hr class="m-t-md"></div></div>'+p),o.$ajaxBox.removeClass("ajax-box-loading"),e(window).trigger("resize"),porto_init(),t.refreshVCContent(o.$ajaxBoxContent),a=o}})}};o.build(),i.data("memberAjaxOnPage",o)}})),this}}}),e(document.documentElement).on("keyup",(function(t){try{if(!a)return;39==t.keyCode&&a.next(),37==t.keyCode&&a.prev()}catch(t){}}))}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{},e.extend(t,{FilterZoom:{defaults:{elements:null},initialize:function(t){return this.$elements=t||this.defaults.elements,this.build(),this},build:function(){return this.$elements.each((function(){var a=e(this);if(a.find(".zoom, .thumb-info-zoom").get(0)){a.find(".zoom, .thumb-info-zoom").off("click");var i=[],o=0;a.find("article").each((function(){var t=e(this);if("none"!=t.css("display")){var a,n=t.find(".zoom, .thumb-info-zoom"),s=n.data("src"),r=n.data("title");n.data("index",o),Array.isArray(s)?e.each(s,(function(t,e){(a={}).src=e,a.title=r[t],i[o]=a,o++})):((a={}).src=s,a.title=r,i[o]=a,o++)}})),a.find("article").each((function(){var a=e(this);"none"!=a.css("display")&&a.off("click",".zoom, .thumb-info-zoom").on("click",".zoom, .thumb-info-zoom",(function(a){var o=e(this),n=o.parents(".thumb-info"),s=0;if(n.get(0)){var r=n.find(".porto-carousel");r.get(0)&&(s=r.data("owl.carousel").current()-r.find(".cloned").length/2)}return a.preventDefault(),e.fn.magnificPopup&&(e.magnificPopup.close(),e.magnificPopup.open(e.extend(!0,{},t.mfpConfig,{items:i,gallery:{enabled:!0},type:"image"}),o.data("index")+s)),!1}))}))}})),this}}})}.apply(this,[window.theme,jQuery]),function(t,e){"use strict";t=t||{};var a="__parallax",i=function(t,e){return this.initialize(t,e)};i.prototype={initialize:function(t,e){return this.$el=t,this.setData().setOptions(e).build(),this},setData:function(){return this.$el.data(a,this),this},setOptions:function(t){return this.options=e.extend(!0,{},{wrapper:this.$el,opts:t}),this},build:function(){if(!e.fn.parallax)return this;var t=this.options.wrapper,a=this.options.opts;t.parallax(a)}},e.extend(t,{Mouseparallax:i}),e.fn.themeMouseparallax=function(i){return this.map((function(){var o=e(this);return o.data(a)?o.data(a):new t.Mouseparallax(o,i)}))}}.apply(this,[window.theme,jQuery]),function(t,e){t=t||{};var a="__readmore",i=function(t,e){return this.initialize(t,e)};i.defaults={buttonOpenLabel:'Read More <i class="fas fa-chevron-down text-2 ms-1"></i>',buttonCloseLabel:'Read Less <i class="fas fa-chevron-up text-2 ms-1"></i>',enableToggle:!0,maxHeight:300,overlayColor:"#43a6a3",overlayHeight:100,startOpened:!1,align:"left"},i.prototype={initialize:function(t,e){return this.$el=t,this.setData().setOptions(e).build().events().resize(),this.options.startOpened&&this.options.wrapper.find(".readmore-button-wrapper > button").trigger("click"),this},setData:function(){return this.$el.data(a,this),this},setOptions:function(t){return this.options=e.extend(!0,{},i.defaults,t,{wrapper:this.$el}),this},build:function(){var t=this;t.options.wrapper.addClass("position-relative"),t.options.wrapper.append('<div class="readmore-overlay"></div>');var a="linear-gradient(180deg, rgba(2, 0, 36, 0) 0%, "+t.options.overlayColor+" 100%)";switch(e("html").hasClass("safari")&&(a="-webkit-linear-gradient(top, rgba(2, 0, 36, 0) 0%, "+t.options.overlayColor+" 100%)"),t.options.wrapper.find(".readmore-overlay").css({background:a,position:"absolute",bottom:0,left:0,width:"100%",height:t.options.overlayHeight,"z-index":1}),t.options.wrapper.find(".readmore-button-wrapper").removeClass("d-none").css({position:"absolute",bottom:0,left:0,width:"100%","z-index":2}),t.options.wrapper.find(".readmore-button-wrapper > button").html(t.options.buttonOpenLabel),t.options.wrapper.css({height:t.options.maxHeight,"overflow-y":"hidden"}),t.options.align){case"center":t.options.wrapper.find(".readmore-button-wrapper").addClass("text-center");break;case"right":t.options.wrapper.find(".readmore-button-wrapper").addClass("text-end");break;default:t.options.wrapper.find(".readmore-button-wrapper").addClass("text-start")}return this},events:function(){var t=this;return t.readMore=function(){t.options.wrapper.find(".readmore-button-wrapper > button:not(.readless)").on("click",(function(a){a.preventDefault(),t.options.wrapper.addClass("opened");var i=e(this);setTimeout((function(){t.options.wrapper.animate({height:t.options.wrapper[0].scrollHeight},(function(){t.options.enableToggle||i.fadeOut(),i.html(t.options.buttonCloseLabel).addClass("readless").off("click"),t.readLess(),t.options.wrapper.find(".readmore-overlay").fadeOut(),t.options.wrapper.css({"max-height":"none",overflow:"visible"}),t.options.wrapper.find(".readmore-button-wrapper").animate({bottom:-20})}))}),200)}))},t.readLess=function(){t.options.wrapper.find(".readmore-button-wrapper > button.readless").on("click",(function(a){a.preventDefault(),t.options.wrapper.removeClass("opened");var i=e(this);t.options.wrapper.find(".readmore-button-wrapper").animate({bottom:0}),t.options.wrapper.find(".readmore-overlay").fadeIn(),setTimeout((function(){t.options.wrapper.height(t.options.wrapper[0].scrollHeight).animate({height:t.options.maxHeight},(function(){i.html(t.options.buttonOpenLabel).removeClass("readless").off("click"),t.readMore(),t.options.wrapper.css({overflow:"hidden"})}))}),200)}))},t.readMore(),this},resize:function(){var t=this;window.addEventListener("resize",(function(){t.options.wrapper.hasClass("opened")?t.options.wrapper.css({height:"auto"}):t.options.wrapper.css({height:t.options.maxHeight})}))}},e.extend(t,{PluginReadMore:i}),e.fn.themePluginReadMore=function(t){return this.map((function(){var t=e(this);return t.data(a)?t.data(a):new i(t,t.data("plugin-options"))}))}}.apply(this,[window.theme,jQuery]),function(t,e){t.initAsync=function(a,i){e.fn.themeAnimate&&e((function(){var a=i.querySelectorAll("svg [data-appear-animation]");a.length&&e(a).closest("svg").attr("data-appear-animation-svg","1");var o=i.querySelectorAll("[data-plugin-animate], [data-appear-animation], [data-appear-animation-svg]");if(o.length){var n=function(){window.innerWidth<768&&(window.removeEventListener("resize",n),o.forEach((function(t){t.classList.add("appear-animation-visible")})))};t.animation_support?(window.addEventListener("resize",n),t.dynIntObsInit(o,"themeAnimate",t.Animate.defaults)):o.forEach((function(t){t.classList.add("appear-animation-visible")}))}})),e.fn.themePluginAnimatedLetters&&(e("[data-plugin-animated-letters]").length||e(".animated-letters").length)&&t.intObs("[data-plugin-animated-letters]:not(.manual), .animated-letters","themePluginAnimatedLetters"),e.fn.themeCarousel&&e((function(){var i=a.find(".owl-carousel:not(.manual)");i.on("initialized.owl.carousel refreshed.owl.carousel",(function(a){var i=e(a.currentTarget);if(i.find("[data-appear-animation]:not(.appear-animation)").addClass("appear-animation"),i.find(".owl-item.cloned").length){i.find(".porto-lazyload:not(.lazy-load-loaded)").themePluginLazyLoad({effect:"fadeIn",effect_speed:400});var o=a.currentTarget.querySelectorAll(".appear-animation");o.length&&t.dynIntObsInit(o,"themeAnimate",t.Animate.defaults),e.fn.themePluginAnimatedLetters&&e(this).find(".owl-item.cloned [data-plugin-animated-letters]:not(.manual)").length&&t.dynIntObsInit(e(this).find(".owl-item.cloned [data-plugin-animated-letters]:not(.manual)"),"themePluginAnimatedLetters")}setTimeout((function(){var t=i.find(".owl-item:not(.active)");!e("html").hasClass("no-csstransitions")&&window.innerWidth>767&&(t.find(".appear-animation").removeClass("appear-animation-visible"),t.find(".appear-animation").each((function(){var t=e(this),a=Math.abs(t.data("appear-animation-delay")?t.data("appear-animation-delay"):0);a>1&&(this.style.animationDelay=a+"ms");var i=Math.abs(t.data("appear-animation-duration")?t.data("appear-animation-duration"):1e3);1e3!=i&&(this.style.animationDuration=i+"ms")}))),window.innerWidth>=1200&&t.find("[data-vce-animate]").removeAttr("data-vcv-o-animated")}),300)})).on("translated.owl.carousel",(function(a){var i=e(a.currentTarget),o=i.find(".owl-item.active");o.hasClass("translating")?o.removeClass("translating"):(i.find(".owl-item.translating").removeClass("translating"),i.find("[data-plugin-animated-letters]").removeClass("invisible"),i.find(".owl-item.active [data-plugin-animated-letters]").trigger("animated.letters.initialize"),window.innerWidth>767&&(i.find(".appear-animation").removeClass("appear-animation-visible"),o.find(".appear-animation").each((function(){var t=e(this),a=t.data("appear-animation");t.addClass(a+" appear-animation-visible")}))),o.find(".slide-animate").each((function(){var a=e(this),i=a.data("settings");if(i&&(i._animation||i.animation)){var o=i._animation||i.animation,n=i._animation_delay||i.animation_delay||0;t.requestTimeout((function(){a.removeClass("elementor-invisible").addClass("animated "+o)}),n)}})),window.innerWidth>=1200&&(i.find("[data-vce-animate]").removeAttr("data-vcv-o-animated").removeAttr("data-vcv-o-animated-fully"),o.find("[data-vce-animate]").each((function(){var t=e(this);if(t.data("porto-origin-anim")){var a=t.data("porto-origin-anim");t.attr("data-vce-animate",a).attr("data-vcv-o-animated",!0);var i=1e3*parseFloat(window.getComputedStyle(this).animationDuration),o=1e3*parseFloat(window.getComputedStyle(this).animationDelay);window.setTimeout((function(){t.attr("data-vcv-o-animated-fully",!0)}),o+i+5)}}))))})),i.on("translate.owl.carousel",(function(){e(this).find("[data-plugin-animated-letters]").addClass("invisible"),e(this).find("[data-plugin-animated-letters]").trigger("animated.letters.destroy")})),i.filter((function(){return!!e(this).find("[data-vce-animate]").length})).on("translate.owl.carousel",(function(t){var a=e(t.currentTarget);a.find(".owl-item.active").addClass("translating"),window.innerWidth>=1200&&a.find("[data-vce-animate]").each((function(){var t=e(this);t.data("porto-origin-anim",t.data("vce-animate")).attr("data-vce-animate","")}))})),i.filter((function(){var t=e(this).find(".elementor-invisible");return!!t.length&&(t.addClass("slide-animate"),!0)})).on("translate.owl.carousel",(function(t){var a=e(t.currentTarget);a.find(".owl-item.active").addClass("translating"),a.find(".owl-item:not(.active) .slide-animate").addClass("elementor-invisible"),a.find(".slide-animate").each((function(){var t=e(this),a=t.data("settings");(a._animation||a.animation)&&t.removeClass(a._animation||a.animation)}))})),i.filter((function(){return!!e(this).find(".appear-animation").length})).on("translate.owl.carousel",(function(t){if(window.innerWidth>767){var a=e(t.currentTarget);a.find(".owl-item.active").addClass("translating"),a.find(".appear-animation").each((function(){var t=e(this);t.removeClass(t.data("appear-animation"))}))}})),a.find("[data-plugin-carousel]:not(.manual), .porto-carousel:not(.manual)").each((function(){var t,a=e(this),i=a.data("plugin-options");i&&(t=i),setTimeout((function(){a.themeCarousel(t)}),0)}))})),a.find(".thumb-gallery-thumbs").each((function(){var t=e(this),a=t.parent().find(".thumb-gallery-detail"),i=!1;t.data("initThumbs")||(a.on("changed.owl.carousel",(function(e){if(!i){i=!0;var o=a.find(".owl-item").length,n=a.find(".cloned").length;o&&t.trigger("to.owl.carousel",[(e.item.index-n/2-1)%o,300,!0]),i=!1}})),t.on("changed.owl.carousel",(function(e){if(!i){i=!0;var o=t.find(".owl-item").length,n=t.find(".cloned").length;o&&a.trigger("to.owl.carousel",[(e.item.index-n/2)%o,300,!0]),i=!1}})).on("click",".owl-item",(function(){if(!i){i=!0;var o=t.find(".owl-item").length,n=t.find(".cloned").length;o&&a.trigger("to.owl.carousel",[(e(this).index()-n/2)%o,300,!0]),i=!1}})).data("initThumbs",!0))})),a.find(".video-fixed").each((function(){var a=e(this),i=a.find("video, iframe");i.length&&window.addEventListener("scroll",(function(){var o=e(window).scrollTop()-a.position().top+t.adminBarHeight();i.css("cssText","top: "+o+"px !important;")}),{passive:!0})}))},e(document.body).trigger("porto_async_init")}.apply(this,[window.theme,jQuery]),jQuery(document).ready((function(t){"use strict";function e(e){var a=e.data("trigger-id"),i=e.data("overlay-class"),o=e.data("extra-class")?e.data("extra-class"):"",n=e.data("type");if(void 0!==a){void 0===n&&(n="inline"),"inline"==n&&(a="#"+escape(a));var s={items:{src:a},type:n,mainClass:o};e.hasClass("porto-onload")&&(s.callbacks={beforeClose:function(){t(".mfp-wrap .porto-disable-modal-onload").length&&(t(".mfp-wrap .porto-disable-modal-onload").is(":checked")||t('.mfp-wrap .porto-disable-modal-onload input[type="checkbox"]').is(":checked"))&&t.cookie("porto_modal_disable_onload","true",{expires:7})}}),void 0!==i&&i&&(s.mainClass+=escape(i)),t.magnificPopup.open(t.extend(!0,{},theme.mfpConfig,s),0)}}function a(a){if(void 0!==a&&a.length||(a=t(document.body)),a.find(".lightbox:not(.manual)").each((function(){var e,a=t(this),i=a.data("lightbox-options");i?e=i:("object"!=typeof(i=a.data("plugin-options"))&&(i=JSON.parse(i)),i&&(e=i)),a.themeLightbox(e)})),a.find(".porto-popup-iframe").magnificPopup(t.extend(!0,{},theme.mfpConfig,{disableOn:700,type:"iframe",mainClass:"mfp-fade",removalDelay:160,preloader:!1,fixedContentPos:!1})),a.find(".porto-popup-ajax").magnificPopup(t.extend(!0,{},theme.mfpConfig,{type:"ajax"})),a.find(".porto-popup-content").each((function(){var e=t(this).attr("data-animation");t(this).magnificPopup(t.extend(!0,{},theme.mfpConfig,{type:"inline",fixedContentPos:!1,fixedBgPos:!0,overflowY:"auto",closeBtnInside:!0,preloader:!1,midClick:!0,removalDelay:300,mainClass:e}))})),a.find(".popup-youtube, .popup-vimeo, .popup-gmaps").each((function(e){var a=t(this).find(".porto-modal-trigger").data("overlay-class"),i={type:"iframe",removalDelay:160,preloader:!1,fixedContentPos:!1};void 0!==a&&a&&(i.mainClass=escape(a)),t(this).magnificPopup(i)})),a.find(".porto-modal-trigger.porto-onload").length){var i=a.find(".porto-modal-trigger.porto-onload").eq(0),o=0;i.data("timeout")&&(o=parseInt(i.data("timeout"),10)),setTimeout((function(){e(i)}),o)}a.on("click",".porto-modal-trigger",(function(a){a.preventDefault(),e(t(this))})),a.hasClass("login-popup")&&a.find(".porto-link-login, .porto-link-register, .my-account").magnificPopup({items:{src:theme.ajax_url+"?action=porto_account_login_popup&nonce="+js_porto_vars.porto_nonce,type:"ajax"},tLoading:'<i class="porto-loading-icon"></i>',callbacks:{ajaxContentAdded:function(){t(window).trigger("porto_login_popup_opened")}}}),a.find(".product-images").magnificPopup(t.extend(!0,{},theme.mfpConfig,{delegate:".img-thumbnail a.zoom",type:"image",gallery:{enabled:!0}})),a.find(".porto-posts-grid").each((function(){t(this).magnificPopup(t.extend(!0,{},theme.mfpConfig,{delegate:".porto-tb-featured-image span.zoom",type:"image",gallery:{enabled:!0}}))})),a.find(".porto-posts-grid .tb-image-type-slider div.zoom").each((function(){var e=t(this),a=[];e.find("a").each((function(){var e={};e.src=t(this).attr("href"),e.title=t(this).attr("title"),a.push(e)})),a.length&&e.on("click",(function(){var i=e.siblings(".porto-carousel");if(i.length){var o=i.data("owl.carousel").current()-i.find(".cloned").length/2;t.magnificPopup.open(t.extend(!0,{},theme.mfpConfig,{items:a,gallery:{enabled:!0},type:"image"}),o)}}))}))}if(t.fn.themeVcImageZoom&&t((function(){var e=null;t(".porto-vc-zoom:not(.manual)").each((function(){var a,i=t(this),o=i.attr("data-gallery"),n=i.data("plugin-options");if(n&&(a=n),void 0===a&&(a={}),a.container=i.parent(),"true"==o){var s="vc_row";i.attr("data-container")&&(s=i.attr("data-container"));var r=t(i.closest("."+s).get(0));if(r.length>0&&null!=e&&e.is(r))return;r.length>0&&(e=r),null!=e&&e.length>0&&(a.container=e)}i.themeVcImageZoom(a)}))})),t.fn.magnificPopup?a():setTimeout((function(){t.fn.magnificPopup&&a()}),500),t(document.body).on("porto_load_posts_end",(function(e,i){t.fn.magnificPopup&&a(i)})),void 0!==theme.PostAjaxModal&&(t(".page-portfolios").length&&theme.PostAjaxModal.initialize(t(".page-portfolios")),t(".page-members").length&&theme.PostAjaxModal.initialize(t(".page-members"),"member")),void 0!==theme.PortfolioAjaxPage&&theme.PortfolioAjaxPage.initialize(),void 0!==theme.PostFilter){var i=t("ul[data-filter-type], .portfolio-filter, .member-filter, .faq-filter, .porto-ajax-filter.product-filter, .porto-ajax-filter.post-filter");i.length&&theme.PostFilter.initialize(i)}t("body").on("click",".porto-ajax-load .pagination:not(.load-more) .page-numbers",(function(e){var a=t(this);if(!a.hasClass("current")&&!a.hasClass("dots")){e.preventDefault();var i=a.closest(".porto-ajax-load"),o=i.data("post_type"),n=i.find("."+o+"s-container");if(n.length&&!i.hasClass("loading")){i.addClass("loading");var s=i.find(".porto-ajax-filter"),r=s.length&&s.children(".active").length&&s.children(".active").data("filter");"*"==r&&(r="");var l={},d=a.attr("href").match(/paged=(\d+)|page\/(\d+)/);d&&Array.isArray(d)&&(d[1]||d[2])?l.page=parseInt(d[1]||d[2]):a.hasClass("prev")?l.page=parseInt(a.next().text()):a.hasClass("next")?l.page=parseInt(a.prev().text()):l.page=parseInt(a.text()),theme.PostFilter.load_posts(r,i.hasClass("load-infinite"),i,o,n,l,a.attr("href"))}}})),void 0!==theme.MemberAjaxPage&&theme.MemberAjaxPage.initialize(),void 0!==theme.FilterZoom&&(theme.FilterZoom.initialize(t(".page-portfolios")),theme.FilterZoom.initialize(t(".page-members")),theme.FilterZoom.initialize(t(".blog-posts-related")));var o=t(".minicart-offcanvas"),n=t(".wishlist-offcanvas"),s=t(".mobile-sidebar"),r=t("#side-nav-panel"),l=t("#header .btn-close-search-form"),d=t("html");(o.length||n.length||s.length||r.length||t(".skeleton-loading").length||l.length)&&(t(document.documentElement).on("keyup",(function(e){try{27==e.keyCode&&(o.removeClass("minicart-opened"),n.removeClass("minicart-opened"),s.length&&(d.removeClass("filter-sidebar-opened"),d.removeClass("sidebar-opened"),t(".sidebar-overlay").removeClass("active")),r.length&&d.hasClass("panel-opened")&&(d.removeClass("panel-opened"),t(".panel-overlay").removeClass("active")),l.length&&l.trigger("click"))}catch(t){}})),t(".skeleton-loading").on("skeleton-loaded",(function(){s=t(".mobile-sidebar")}))),t.fn.themeMouseparallax&&t((function(){t('[data-plugin="mouse-parallax"]').each((function(){var e,a=t(this);a.data("parallax")&&(a.parallax("disable"),a.removeData("parallax"),a.removeData("options")),a.hasClass("elementor-element")?a.children(".elementor-widget-container, .elementor-container, .elementor-widget-wrap, .elementor-column-wrap").addClass("layer").attr("data-depth",a.attr("data-floating-depth")):a.children(".layer").attr("data-depth",a.attr("data-floating-depth"));var i=a.data("options");i&&(e=i),a.themeMouseparallax(e)}))})),t.fn.themePluginReadMore&&t("[data-plugin-readmore]").length&&t("[data-plugin-readmore]:not(.manual)").themePluginReadMore()})),function(t,e){if(e(".wishlist-popup").length){var a=null;e(".wishlist-offcanvas .my-wishlist").on("click",(function(t){t.preventDefault(),e(this).parent().toggleClass("minicart-opened")})),e(".wishlist-offcanvas .minicart-overlay").on("click",(function(){e(this).closest(".wishlist-offcanvas").removeClass("minicart-opened")}));var i=function(){(a=new Worker(js_porto_vars.ajax_loader_url.replace("/images/ajax-loader@2x.gif","/js/woocommerce-worker.js"))).onmessage=function(t){e(".wishlist-popup").html(t.data)},a.postMessage({initWishlist:!0,ajaxurl:t.ajax_url,nonce:js_porto_vars.porto_nonce})};t&&t.isLoaded?setTimeout((function(){i()}),100):e(window).on("load",(function(){i()})),e(".wishlist-popup").on("click",".remove_from_wishlist",(function(t){t.preventDefault();var a=e(this),i=a.attr("data-product_id"),o=e(".wishlist_table #yith-wcwl-row-"+i+" .remove_from_wishlist");a.closest(".wishlist-item").find(".ajax-loading").show(),o.length?o.trigger("click"):e.ajax({url:yith_wcwl_l10n.ajax_url,data:{action:yith_wcwl_l10n.actions.remove_from_wishlist_action,remove_from_wishlist:i,nonce:yith_wcwl_l10n.nonce.remove_from_wishlist_nonce,from:"theme"},method:"post",success:function(t){var a=e(".yith-wcwl-add-to-wishlist.add-to-wishlist-"+i);if(a.length){var o=a.data("fragment-options"),n=a.find("a");if(n.length){o.in_default_wishlist&&(delete o.in_default_wishlist,a.attr(JSON.stringify(o))),a.removeClass("exists"),a.find(".yith-wcwl-wishlistexistsbrowse").addClass("yith-wcwl-add-button").removeClass("yith-wcwl-wishlistexistsbrowse"),a.find(".yith-wcwl-wishlistaddedbrowse").addClass("yith-wcwl-add-button").removeClass("yith-wcwl-wishlistaddedbrowse"),n.attr("href",location.href+"?post_type=product&amp;add_to_wishlist="+i).attr("data-product-id",i).attr("data-product-type",o.product_type);var s=e(".single_add_to_wishlist").data("title");s||(s="Add to wishlist"),n.attr("title",s).attr("data-title",s).addClass("add_to_wishlist single_add_to_wishlist").html("<span>"+s+"</span>")}}e(document.body).trigger("removed_from_wishlist")}})})),e(document.body).on("added_to_wishlist removed_from_wishlist",(function(e){a&&a.postMessage({loadWishlist:!0,ajaxurl:t.ajax_url,nonce:js_porto_vars.porto_nonce})}))}var o=e(".porto-video-social.video-youtube");o.length&&(window.onYouTubeIframeAPIReady=function(){o.each((function(){var t=e(this),a=t.parent(".video-wrapper"),i=t.attr("id"),o=t.data("video"),n=t.data("loop"),s=t.data("audio"),r=1,l=0;"0"===t.data("autoplay")&&(r=0),t.data("controls")&&(l=parseInt(t.data("controls"))),new YT.Player(i,{width:"100%",videoId:o,playerVars:{autoplay:r,controls:l,modestbranding:1,rel:0,playsinline:1,showinfo:0,loop:n},events:{onReady:function(t){a.length&&a.themeFitVideo(),0===parseInt(s)&&t&&t.target&&t.target.mute&&t.target.mute()}}})}))},e('script[src*="www.youtube.com/iframe_api"]').length?setTimeout(onYouTubeIframeAPIReady,350):((s=document.createElement("script")).src="//www.youtube.com/iframe_api",(r=document.getElementsByTagName("script")[0]).parentNode.insertBefore(s,r)));var n=e(".porto-video-social.video-vimeo");if(n.length){var s,r,l=function(){n.each((function(){var t=e(this),a=t.parent(".fit-video"),i=t.attr("id"),o=t.data("video"),n=t.data("loop"),s=t.data("audio"),r=!0;"0"===t.data("autoplay")&&(r=!1);var l=new Vimeo.Player(i,{id:o,loop:1===parseInt(n),autoplay:r,transparent:!1,background:!0,muted:0===parseInt(s),events:{onReady:function(t){a.length&&a.themeFitVideo(),0===parseInt(s)&&t&&t.target&&t.target.mute&&t.target.mute()}}});0===parseInt(s)&&l.setVolume(0),a.length&&l.ready().then((function(){a.themeFitVideo()}))}))};if(e('script[src="https://player.vimeo.com/api/player.js"]').length)setTimeout(l,350);else(s=document.createElement("script")).addEventListener("load",(function(t){setTimeout(l,50)})),s.src="https://player.vimeo.com/api/player.js",(r=document.getElementsByTagName("script")[0]).parentNode.insertBefore(s,r)}}.apply(this,[window.theme,jQuery]);
/*! elementor - v3.5.3 - 28-12-2021 */
(()=>{"use strict";var e,r,_,t,a,i={},n={};function __webpack_require__(e){var r=n[e];if(void 0!==r)return r.exports;var _=n[e]={exports:{}};return i[e](_,_.exports,__webpack_require__),_.exports}__webpack_require__.m=i,e=[],__webpack_require__.O=(r,_,t,a)=>{if(!_){var i=1/0;for(u=0;u<e.length;u++){for(var[_,t,a]=e[u],n=!0,c=0;c<_.length;c++)(!1&a||i>=a)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](_[c])))?_.splice(c--,1):(n=!1,a<i&&(i=a));if(n){e.splice(u--,1);var o=t();void 0!==o&&(r=o)}}return r}a=a||0;for(var u=e.length;u>0&&e[u-1][2]>a;u--)e[u]=e[u-1];e[u]=[_,t,a]},_=Object.getPrototypeOf?e=>Object.getPrototypeOf(e):e=>e.__proto__,__webpack_require__.t=function(e,t){if(1&t&&(e=this(e)),8&t)return e;if("object"==typeof e&&e){if(4&t&&e.__esModule)return e;if(16&t&&"function"==typeof e.then)return e}var a=Object.create(null);__webpack_require__.r(a);var i={};r=r||[null,_({}),_([]),_(_)];for(var n=2&t&&e;"object"==typeof n&&!~r.indexOf(n);n=_(n))Object.getOwnPropertyNames(n).forEach((r=>i[r]=()=>e[r]));return i.default=()=>e,__webpack_require__.d(a,i),a},__webpack_require__.d=(e,r)=>{for(var _ in r)__webpack_require__.o(r,_)&&!__webpack_require__.o(e,_)&&Object.defineProperty(e,_,{enumerable:!0,get:r[_]})},__webpack_require__.f={},__webpack_require__.e=e=>Promise.all(Object.keys(__webpack_require__.f).reduce(((r,_)=>(__webpack_require__.f[_](e,r),r)),[])),__webpack_require__.u=e=>723===e?"lightbox.23e39ac2830dfb4ca6a7.bundle.min.js":48===e?"text-path.9f18ebdea5ac00d653e5.bundle.min.js":209===e?"accordion.fb811bbb2beff11fae3c.bundle.min.js":745===e?"alert.cbc2a0fee74ee3ed0419.bundle.min.js":120===e?"counter.02cef29c589e742d4c8c.bundle.min.js":192===e?"progress.ca55d33bb06cee4e6f02.bundle.min.js":520===e?"tabs.50864c9249aa8a87126a.bundle.min.js":181===e?"toggle.0b9ce025bedc8ed28c59.bundle.min.js":791===e?"video.1a44ef088849d6949ada.bundle.min.js":268===e?"image-carousel.bd7aab19c9d934b7c505.bundle.min.js":357===e?"text-editor.289ae80d76f0c5abea44.bundle.min.js":52===e?"wp-audio.75f0ced143febb8cd31a.bundle.min.js":void 0,__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,r)=>Object.prototype.hasOwnProperty.call(e,r),t={},a="elementor:",__webpack_require__.l=(e,r,_,i)=>{if(t[e])t[e].push(r);else{var n,c;if(void 0!==_)for(var o=document.getElementsByTagName("script"),u=0;u<o.length;u++){var b=o[u];if(b.getAttribute("src")==e||b.getAttribute("data-webpack")==a+_){n=b;break}}n||(c=!0,(n=document.createElement("script")).charset="utf-8",n.timeout=120,__webpack_require__.nc&&n.setAttribute("nonce",__webpack_require__.nc),n.setAttribute("data-webpack",a+_),n.src=e),t[e]=[r];var onScriptComplete=(r,_)=>{n.onerror=n.onload=null,clearTimeout(p);var a=t[e];if(delete t[e],n.parentNode&&n.parentNode.removeChild(n),a&&a.forEach((e=>e(_))),r)return r(_)},p=setTimeout(onScriptComplete.bind(null,void 0,{type:"timeout",target:n}),12e4);n.onerror=onScriptComplete.bind(null,n.onerror),n.onload=onScriptComplete.bind(null,n.onload),c&&document.head.appendChild(n)}},__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e;__webpack_require__.g.importScripts&&(e=__webpack_require__.g.location+"");var r=__webpack_require__.g.document;if(!e&&r&&(r.currentScript&&(e=r.currentScript.src),!e)){var _=r.getElementsByTagName("script");_.length&&(e=_[_.length-1].src)}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),__webpack_require__.p=e})(),(()=>{var e={162:0};__webpack_require__.f.j=(r,_)=>{var t=__webpack_require__.o(e,r)?e[r]:void 0;if(0!==t)if(t)_.push(t[2]);else if(162!=r){var a=new Promise(((_,a)=>t=e[r]=[_,a]));_.push(t[2]=a);var i=__webpack_require__.p+__webpack_require__.u(r),n=new Error;__webpack_require__.l(i,(_=>{if(__webpack_require__.o(e,r)&&(0!==(t=e[r])&&(e[r]=void 0),t)){var a=_&&("load"===_.type?"missing":_.type),i=_&&_.target&&_.target.src;n.message="Loading chunk "+r+" failed.\n("+a+": "+i+")",n.name="ChunkLoadError",n.type=a,n.request=i,t[1](n)}}),"chunk-"+r,r)}else e[r]=0},__webpack_require__.O.j=r=>0===e[r];var webpackJsonpCallback=(r,_)=>{var t,a,[i,n,c]=_,o=0;if(i.some((r=>0!==e[r]))){for(t in n)__webpack_require__.o(n,t)&&(__webpack_require__.m[t]=n[t]);if(c)var u=c(__webpack_require__)}for(r&&r(_);o<i.length;o++)a=i[o],__webpack_require__.o(e,a)&&e[a]&&e[a][0](),e[i[o]]=0;return __webpack_require__.O(u)},r=self.webpackChunkelementor=self.webpackChunkelementor||[];r.forEach(webpackJsonpCallback.bind(null,0)),r.push=webpackJsonpCallback.bind(null,r.push.bind(r))})()})();
/*! elementor - v3.5.3 - 28-12-2021 */
(self.webpackChunkelementor=self.webpackChunkelementor||[]).push([[354],{7914:e=>{e.exports=function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}},e.exports.default=e.exports,e.exports.__esModule=!0},381:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;t.default=(e,t)=>{t=Array.isArray(t)?t:[t];for(const n of t)if(e.constructor.name===n.prototype[Symbol.toStringTag])return!0;return!1}},8135:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class _default extends elementorModules.ViewModule{getDefaultSettings(){return{selectors:{elements:".elementor-element",nestedDocumentElements:".elementor .elementor-element"},classes:{editMode:"elementor-edit-mode"}}}getDefaultElements(){const e=this.getSettings("selectors");return{$elements:this.$element.find(e.elements).not(this.$element.find(e.nestedDocumentElements))}}getDocumentSettings(e){let t;if(this.isEdit){t={};const e=elementor.settings.page.model;jQuery.each(e.getActiveControls(),(n=>{t[n]=e.attributes[n]}))}else t=this.$element.data("elementor-settings")||{};return this.getItems(t,e)}runElementsHandlers(){this.elements.$elements.each(((e,t)=>elementorFrontend.elementsHandler.runReadyTrigger(t)))}onInit(){this.$element=this.getSettings("$element"),super.onInit(),this.isEdit=this.$element.hasClass(this.getSettings("classes.editMode")),this.isEdit?elementor.on("document:loaded",(()=>{elementor.settings.page.model.on("change",this.onSettingsChange.bind(this))})):this.runElementsHandlers()}onSettingsChange(){}}t.default=_default},2821:(e,t,n)=>{"use strict";var s=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var i=s(n(3090));class SwiperHandlerBase extends i.default{getInitialSlide(){const e=this.getEditSettings();return e.activeItemIndex?e.activeItemIndex-1:0}getSlidesCount(){return this.elements.$slides.length}togglePauseOnHover(e){e?this.elements.$swiperContainer.on({mouseenter:()=>{this.swiper.autoplay.stop()},mouseleave:()=>{this.swiper.autoplay.start()}}):this.elements.$swiperContainer.off("mouseenter mouseleave")}handleKenBurns(){const e=this.getSettings();this.$activeImageBg&&this.$activeImageBg.removeClass(e.classes.kenBurnsActive),this.activeItemIndex=this.swiper?this.swiper.activeIndex:this.getInitialSlide(),this.swiper?this.$activeImageBg=jQuery(this.swiper.slides[this.activeItemIndex]).children("."+e.classes.slideBackground):this.$activeImageBg=jQuery(this.elements.$slides[0]).children("."+e.classes.slideBackground),this.$activeImageBg.addClass(e.classes.kenBurnsActive)}}t.default=SwiperHandlerBase},3090:e=>{"use strict";e.exports=elementorModules.ViewModule.extend({$element:null,editorListeners:null,onElementChange:null,onEditSettingsChange:null,onPageSettingsChange:null,isEdit:null,__construct:function(e){this.isActive(e)&&(this.$element=e.$element,this.isEdit=this.$element.hasClass("elementor-element-edit-mode"),this.isEdit&&this.addEditorListeners())},isActive:function(){return!0},findElement:function(e){var t=this.$element;return t.find(e).filter((function(){return jQuery(this).closest(".elementor-element").is(t)}))},getUniqueHandlerID:function(e,t){return e||(e=this.getModelCID()),t||(t=this.$element),e+t.attr("data-element_type")+this.getConstructorID()},initEditorListeners:function(){var e=this;if(e.editorListeners=[{event:"element:destroy",to:elementor.channels.data,callback:function(t){t.cid===e.getModelCID()&&e.onDestroy()}}],e.onElementChange){const t=e.getWidgetType()||e.getElementType();let n="change";"global"!==t&&(n+=":"+t),e.editorListeners.push({event:n,to:elementor.channels.editor,callback:function(t,n){e.getUniqueHandlerID(n.model.cid,n.$el)===e.getUniqueHandlerID()&&e.onElementChange(t.model.get("name"),t,n)}})}e.onEditSettingsChange&&e.editorListeners.push({event:"change:editSettings",to:elementor.channels.editor,callback:function(t,n){n.model.cid===e.getModelCID()&&e.onEditSettingsChange(Object.keys(t.changed)[0])}}),["page"].forEach((function(t){var n="on"+t[0].toUpperCase()+t.slice(1)+"SettingsChange";e[n]&&e.editorListeners.push({event:"change",to:elementor.settings[t].model,callback:function(t){e[n](t.changed)}})}))},getEditorListeners:function(){return this.editorListeners||this.initEditorListeners(),this.editorListeners},addEditorListeners:function(){var e=this.getUniqueHandlerID();this.getEditorListeners().forEach((function(t){elementorFrontend.addListenerOnce(e,t.event,t.callback,t.to)}))},removeEditorListeners:function(){var e=this.getUniqueHandlerID();this.getEditorListeners().forEach((function(t){elementorFrontend.removeListeners(e,t.event,null,t.to)}))},getElementType:function(){return this.$element.data("element_type")},getWidgetType:function(){const e=this.$element.data("widget_type");if(e)return e.split(".")[0]},getID:function(){return this.$element.data("id")},getModelCID:function(){return this.$element.data("model-cid")},getElementSettings:function(e){let t={};const n=this.getModelCID();if(this.isEdit&&n){const e=elementorFrontend.config.elements.data[n],s=e.attributes;let i=s.widgetType||s.elType;s.isInner&&(i="inner-"+i);let r=elementorFrontend.config.elements.keys[i];r||(r=elementorFrontend.config.elements.keys[i]=[],jQuery.each(e.controls,((e,t)=>{t.frontend_available&&r.push(e)}))),jQuery.each(e.getActiveControls(),(function(e){if(-1!==r.indexOf(e)){let n=s[e];n.toJSON&&(n=n.toJSON()),t[e]=n}}))}else t=this.$element.data("settings")||{};return this.getItems(t,e)},getEditSettings:function(e){var t={};return this.isEdit&&(t=elementorFrontend.config.elements.editSettings[this.getModelCID()].attributes),this.getItems(t,e)},getCurrentDeviceSetting:function(e){return elementorFrontend.getCurrentDeviceSetting(this.getElementSettings(),e)},onInit:function(){this.isActive(this.getSettings())&&elementorModules.ViewModule.prototype.onInit.apply(this,arguments)},onDestroy:function(){this.isEdit&&this.removeEditorListeners(),this.unbindEvents&&this.unbindEvents()}})},6412:(e,t,n)=>{"use strict";var s=n(7914),i=s(n(5955)),r=s(n(8135)),o=s(n(5658)),l=s(n(3090)),c=s(n(2821));i.default.frontend={Document:r.default,tools:{StretchElement:o.default},handlers:{Base:l.default,SwiperBase:c.default}}},5658:e=>{"use strict";e.exports=elementorModules.ViewModule.extend({getDefaultSettings:function(){return{element:null,direction:elementorFrontend.config.is_rtl?"right":"left",selectors:{container:window}}},getDefaultElements:function(){return{$element:jQuery(this.getSettings("element"))}},stretch:function(){var e,t=this.getSettings("selectors.container");try{e=jQuery(t)}catch(e){}e&&e.length||(e=jQuery(this.getDefaultSettings().selectors.container)),this.reset();var n=this.elements.$element,s=e.innerWidth(),i=n.offset().left,r="fixed"===n.css("position"),o=r?0:i;if(window!==e[0]){var l=e.offset().left;r&&(o=l),i>l&&(o=i-l)}r||(elementorFrontend.config.is_rtl&&(o=s-(n.outerWidth()+o)),o=-o);var c={};c.width=s+"px",c[this.getSettings("direction")]=o+"px",n.css(c)},reset:function(){var e={width:""};e[this.getSettings("direction")]="",this.elements.$element.css(e)}})},2618:(e,t,n)=>{"use strict";var s=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var i=s(n(7597)),r=s(n(381));class ArgsObject extends i.default{static getInstanceType(){return"ArgsObject"}constructor(e){super(),this.args=e}requireArgument(e,t=this.args){if(!t.hasOwnProperty(e))throw Error(`${e} is required.`)}requireArgumentType(e,t,n=this.args){if(this.requireArgument(e,n),typeof n[e]!==t)throw Error(`${e} invalid type: ${t}.`)}requireArgumentInstance(e,t,n=this.args){if(this.requireArgument(e,n),!(n[e]instanceof t||(0,r.default)(n[e],t)))throw Error(`${e} invalid instance.`)}requireArgumentConstructor(e,t,n=this.args){if(this.requireArgument(e,n),n[e].constructor!==t)throw Error(`${e} invalid constructor type.`)}}t.default=ArgsObject},869:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=t.ForceMethodImplementation=void 0;class ForceMethodImplementation extends Error{constructor(e={}){super(`${e.isStatic?"static ":""}${e.fullName}() should be implemented, please provide '${e.functionName||e.fullName}' functionality.`),Error.captureStackTrace(this,ForceMethodImplementation)}}t.ForceMethodImplementation=ForceMethodImplementation;t.default=()=>{const e=Error().stack.split("\n")[2].trim(),t=e.startsWith("at new")?"constructor":e.split(" ")[1],n={};if(n.functionName=t,n.fullName=t,n.functionName.includes(".")){const e=n.functionName.split(".");n.className=e[0],n.functionName=e[1]}else n.isStatic=!0;throw new ForceMethodImplementation(n)}},7597:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class InstanceType{static[Symbol.hasInstance](e){let t=super[Symbol.hasInstance](e);if(e&&!e.constructor.getInstanceType)return t;if(e&&(e.instanceTypes||(e.instanceTypes=[]),t||this.getInstanceType()===e.constructor.getInstanceType()&&(t=!0),t)){const t=this.getInstanceType===InstanceType.getInstanceType?"BaseInstanceType":this.getInstanceType();-1===e.instanceTypes.indexOf(t)&&e.instanceTypes.push(t)}return!t&&e&&(t=e.instanceTypes&&Array.isArray(e.instanceTypes)&&-1!==e.instanceTypes.indexOf(this.getInstanceType())),t}constructor(){let e=new.target;const t=[];for(;e.__proto__&&e.__proto__.name;)t.push(e.__proto__),e=e.__proto__;t.reverse().forEach((e=>this instanceof e))}static getInstanceType(){elementorModules.ForceMethodImplementation()}}t.default=InstanceType},1192:e=>{"use strict";const Module=function(){const e=jQuery,t=arguments,n=this,s={};let i;const ensureClosureMethods=function(){e.each(n,(function(e){const t=n[e];"function"==typeof t&&(n[e]=function(){return t.apply(n,arguments)})}))},initSettings=function(){i=n.getDefaultSettings();const s=t[0];s&&e.extend(!0,i,s)},init=function(){n.__construct.apply(n,t),ensureClosureMethods(),initSettings(),n.trigger("init")};this.getItems=function(e,t){if(t){const n=t.split("."),s=n.splice(0,1);if(!n.length)return e[s];if(!e[s])return;return this.getItems(e[s],n.join("."))}return e},this.getSettings=function(e){return this.getItems(i,e)},this.setSettings=function(t,s,r){if(r||(r=i),"object"==typeof t)return e.extend(r,t),n;const o=t.split("."),l=o.splice(0,1);return o.length?(r[l]||(r[l]={}),n.setSettings(o.join("."),s,r[l])):(r[l]=s,n)},this.getErrorMessage=function(e,t){let n;if("forceMethodImplementation"===e)n=`The method '${t}' must to be implemented in the inheritor child.`;else n="An error occurs";return n},this.forceMethodImplementation=function(e){throw new Error(this.getErrorMessage("forceMethodImplementation",e))},this.on=function(t,i){if("object"==typeof t)return e.each(t,(function(e){n.on(e,this)})),n;return t.split(" ").forEach((function(e){s[e]||(s[e]=[]),s[e].push(i)})),n},this.off=function(e,t){if(!s[e])return n;if(!t)return delete s[e],n;const i=s[e].indexOf(t);return-1!==i&&(delete s[e][i],s[e]=s[e].filter((e=>e))),n},this.trigger=function(t){const i="on"+t[0].toUpperCase()+t.slice(1),r=Array.prototype.slice.call(arguments,1);n[i]&&n[i].apply(n,r);const o=s[t];return o?(e.each(o,(function(e,t){t.apply(n,r)})),n):n},init()};Module.prototype.__construct=function(){},Module.prototype.getDefaultSettings=function(){return{}},Module.prototype.getConstructorID=function(){return this.constructor.name},Module.extend=function(e){const t=jQuery,n=this,child=function(){return n.apply(this,arguments)};return t.extend(child,n),(child.prototype=Object.create(t.extend({},n.prototype,e))).constructor=child,child.__super__=n.prototype,child},e.exports=Module},6516:(e,t,n)=>{"use strict";var s=n(7914)(n(2640));e.exports=s.default.extend({getDefaultSettings:function(){return{container:null,items:null,columnsCount:3,verticalSpaceBetween:30}},getDefaultElements:function(){return{$container:jQuery(this.getSettings("container")),$items:jQuery(this.getSettings("items"))}},run:function(){var e=[],t=this.elements.$container.position().top,n=this.getSettings(),s=n.columnsCount;t+=parseInt(this.elements.$container.css("margin-top"),10),this.elements.$items.each((function(i){var r=Math.floor(i/s),o=jQuery(this),l=o[0].getBoundingClientRect().height+n.verticalSpaceBetween;if(r){var c=o.position(),a=i%s,u=c.top-t-e[a];u-=parseInt(o.css("margin-top"),10),u*=-1,o.css("margin-top",u+"px"),e[a]+=l}else e.push(l)}))}})},400:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;t.default=class Scroll{static scrollObserver(e){let t=0;const n={root:e.root||null,rootMargin:e.offset||"0px",threshold:((e=0)=>{const t=[];if(e>0&&e<=100){const n=100/e;for(let e=0;e<=100;e+=n)t.push(e/100)}else t.push(0);return t})(e.sensitivity)};return new IntersectionObserver((function handleIntersect(n,s){const i=n[0].boundingClientRect.y,r=n[0].isIntersecting,o=i<t?"down":"up",l=Math.abs(parseFloat((100*n[0].intersectionRatio).toFixed(2)));e.callback({sensitivity:e.sensitivity,isInViewport:r,scrollPercentage:l,intersectionScrollDirection:o}),t=i}),n)}static getElementViewportPercentage(e,t={}){const n=e[0].getBoundingClientRect(),s=t.start||0,i=t.end||0,r=window.innerHeight*s/100,o=window.innerHeight*i/100,l=n.top-window.innerHeight,c=0-l+r,a=n.top+r+e.height()-l+o,u=Math.max(0,Math.min(c/a,1));return parseFloat((100*u).toFixed(2))}static getPageScrollPercentage(e={},t){const n=e.start||0,s=e.end||0,i=t||document.documentElement.scrollHeight-document.documentElement.clientHeight,r=i*n/100,o=i+r+i*s/100;return(document.documentElement.scrollTop+document.body.scrollTop+r)/o*100}}},2640:(e,t,n)=>{"use strict";var s=n(7914)(n(1192));e.exports=s.default.extend({elements:null,getDefaultElements:function(){return{}},bindEvents:function(){},onInit:function(){this.initElements(),this.bindEvents()},initElements:function(){this.elements=this.getDefaultElements()}})},5955:(e,t,n)=>{"use strict";var s=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var i=s(n(1192)),r=s(n(2640)),o=s(n(2618)),l=s(n(6516)),c=s(n(400)),a=s(n(869)),u=window.elementorModules={Module:i.default,ViewModule:r.default,ArgsObject:o.default,ForceMethodImplementation:a.default,utils:{Masonry:l.default,Scroll:c.default}};t.default=u}},e=>{var t;t=6412,e(e.s=t)}]);
!function(){"use strict";function Waypoint(options){if(!options)throw new Error("No options passed to Waypoint constructor");if(!options.element)throw new Error("No element option passed to Waypoint constructor");if(!options.handler)throw new Error("No handler option passed to Waypoint constructor");this.key="waypoint-"+keyCounter,this.options=Waypoint.Adapter.extend({},Waypoint.defaults,options),this.element=this.options.element,this.adapter=new Waypoint.Adapter(this.element),this.callback=options.handler,this.axis=this.options.horizontal?"horizontal":"vertical",this.enabled=this.options.enabled,this.triggerPoint=null,this.group=Waypoint.Group.findOrCreate({name:this.options.group,axis:this.axis}),this.context=Waypoint.Context.findOrCreateByElement(this.options.context),Waypoint.offsetAliases[this.options.offset]&&(this.options.offset=Waypoint.offsetAliases[this.options.offset]),this.group.add(this),this.context.add(this),allWaypoints[this.key]=this,keyCounter+=1}var keyCounter=0,allWaypoints={};Waypoint.prototype.queueTrigger=function(direction){this.group.queueTrigger(this,direction)},Waypoint.prototype.trigger=function(args){this.enabled&&this.callback&&this.callback.apply(this,args)},Waypoint.prototype.destroy=function(){this.context.remove(this),this.group.remove(this),delete allWaypoints[this.key]},Waypoint.prototype.disable=function(){return this.enabled=!1,this},Waypoint.prototype.enable=function(){return this.context.refresh(),this.enabled=!0,this},Waypoint.prototype.next=function(){return this.group.next(this)},Waypoint.prototype.previous=function(){return this.group.previous(this)},Waypoint.invokeAll=function(method){var allWaypointsArray=[];for(var waypointKey in allWaypoints)allWaypointsArray.push(allWaypoints[waypointKey]);for(var i=0,end=allWaypointsArray.length;i<end;i++)allWaypointsArray[i][method]()},Waypoint.destroyAll=function(){Waypoint.invokeAll("destroy")},Waypoint.disableAll=function(){Waypoint.invokeAll("disable")},Waypoint.enableAll=function(){Waypoint.Context.refreshAll();for(var waypointKey in allWaypoints)allWaypoints[waypointKey].enabled=!0;return this},Waypoint.refreshAll=function(){Waypoint.Context.refreshAll()},Waypoint.viewportHeight=function(){return window.innerHeight||document.documentElement.clientHeight},Waypoint.viewportWidth=function(){return document.documentElement.clientWidth},Waypoint.adapters=[],Waypoint.defaults={context:window,continuous:!0,enabled:!0,group:"default",horizontal:!1,offset:0},Waypoint.offsetAliases={"bottom-in-view":function(){return this.context.innerHeight()-this.adapter.outerHeight()},"right-in-view":function(){return this.context.innerWidth()-this.adapter.outerWidth()}},window.Waypoint=Waypoint}(),function(){"use strict";function requestAnimationFrameShim(callback){window.setTimeout(callback,1e3/60)}function Context(element){this.element=element,this.Adapter=Waypoint.Adapter,this.adapter=new this.Adapter(element),this.key="waypoint-context-"+keyCounter,this.didScroll=!1,this.didResize=!1,this.oldScroll={x:this.adapter.scrollLeft(),y:this.adapter.scrollTop()},this.waypoints={vertical:{},horizontal:{}},element.waypointContextKey=this.key,contexts[element.waypointContextKey]=this,keyCounter+=1,Waypoint.windowContext||(Waypoint.windowContext=!0,Waypoint.windowContext=new Context(window)),this.createThrottledScrollHandler(),this.createThrottledResizeHandler()}var keyCounter=0,contexts={},Waypoint=window.Waypoint,oldWindowLoad=window.onload;Context.prototype.add=function(waypoint){var axis=waypoint.options.horizontal?"horizontal":"vertical";this.waypoints[axis][waypoint.key]=waypoint,this.refresh()},Context.prototype.checkEmpty=function(){var horizontalEmpty=this.Adapter.isEmptyObject(this.waypoints.horizontal),verticalEmpty=this.Adapter.isEmptyObject(this.waypoints.vertical),isWindow=this.element==this.element.window;horizontalEmpty&&verticalEmpty&&!isWindow&&(this.adapter.off(".waypoints"),delete contexts[this.key])},Context.prototype.createThrottledResizeHandler=function(){function resizeHandler(){self.handleResize(),self.didResize=!1}var self=this;this.adapter.on("resize.waypoints",function(){self.didResize||(self.didResize=!0,Waypoint.requestAnimationFrame(resizeHandler))})},Context.prototype.createThrottledScrollHandler=function(){function scrollHandler(){self.handleScroll(),self.didScroll=!1}var self=this;this.adapter.on("scroll.waypoints",function(){self.didScroll&&!Waypoint.isTouch||(self.didScroll=!0,Waypoint.requestAnimationFrame(scrollHandler))})},Context.prototype.handleResize=function(){Waypoint.Context.refreshAll()},Context.prototype.handleScroll=function(){var triggeredGroups={},axes={horizontal:{newScroll:this.adapter.scrollLeft(),oldScroll:this.oldScroll.x,forward:"right",backward:"left"},vertical:{newScroll:this.adapter.scrollTop(),oldScroll:this.oldScroll.y,forward:"down",backward:"up"}};for(var axisKey in axes){var axis=axes[axisKey],isForward=axis.newScroll>axis.oldScroll,direction=isForward?axis.forward:axis.backward;for(var waypointKey in this.waypoints[axisKey]){var waypoint=this.waypoints[axisKey][waypointKey];if(null!==waypoint.triggerPoint){var wasBeforeTriggerPoint=axis.oldScroll<waypoint.triggerPoint,nowAfterTriggerPoint=axis.newScroll>=waypoint.triggerPoint,crossedForward=wasBeforeTriggerPoint&&nowAfterTriggerPoint,crossedBackward=!wasBeforeTriggerPoint&&!nowAfterTriggerPoint;(crossedForward||crossedBackward)&&(waypoint.queueTrigger(direction),triggeredGroups[waypoint.group.id]=waypoint.group)}}}for(var groupKey in triggeredGroups)triggeredGroups[groupKey].flushTriggers();this.oldScroll={x:axes.horizontal.newScroll,y:axes.vertical.newScroll}},Context.prototype.innerHeight=function(){return this.element==this.element.window?Waypoint.viewportHeight():this.adapter.innerHeight()},Context.prototype.remove=function(waypoint){delete this.waypoints[waypoint.axis][waypoint.key],this.checkEmpty()},Context.prototype.innerWidth=function(){return this.element==this.element.window?Waypoint.viewportWidth():this.adapter.innerWidth()},Context.prototype.destroy=function(){var allWaypoints=[];for(var axis in this.waypoints)for(var waypointKey in this.waypoints[axis])allWaypoints.push(this.waypoints[axis][waypointKey]);for(var i=0,end=allWaypoints.length;i<end;i++)allWaypoints[i].destroy()},Context.prototype.refresh=function(){var axes,isWindow=this.element==this.element.window,contextOffset=isWindow?void 0:this.adapter.offset(),triggeredGroups={};this.handleScroll(),axes={horizontal:{contextOffset:isWindow?0:contextOffset.left,contextScroll:isWindow?0:this.oldScroll.x,contextDimension:this.innerWidth(),oldScroll:this.oldScroll.x,forward:"right",backward:"left",offsetProp:"left"},vertical:{contextOffset:isWindow?0:contextOffset.top,contextScroll:isWindow?0:this.oldScroll.y,contextDimension:this.innerHeight(),oldScroll:this.oldScroll.y,forward:"down",backward:"up",offsetProp:"top"}};for(var axisKey in axes){var axis=axes[axisKey];for(var waypointKey in this.waypoints[axisKey]){var contextModifier,wasBeforeScroll,nowAfterScroll,triggeredBackward,triggeredForward,waypoint=this.waypoints[axisKey][waypointKey],adjustment=waypoint.options.offset,oldTriggerPoint=waypoint.triggerPoint,elementOffset=0,freshWaypoint=null==oldTriggerPoint;waypoint.element!==waypoint.element.window&&(elementOffset=waypoint.adapter.offset()[axis.offsetProp]),"function"==typeof adjustment?adjustment=adjustment.apply(waypoint):"string"==typeof adjustment&&(adjustment=parseFloat(adjustment),waypoint.options.offset.indexOf("%")>-1&&(adjustment=Math.ceil(axis.contextDimension*adjustment/100))),contextModifier=axis.contextScroll-axis.contextOffset,waypoint.triggerPoint=Math.floor(elementOffset+contextModifier-adjustment),wasBeforeScroll=oldTriggerPoint<axis.oldScroll,nowAfterScroll=waypoint.triggerPoint>=axis.oldScroll,triggeredBackward=wasBeforeScroll&&nowAfterScroll,triggeredForward=!wasBeforeScroll&&!nowAfterScroll,!freshWaypoint&&triggeredBackward?(waypoint.queueTrigger(axis.backward),triggeredGroups[waypoint.group.id]=waypoint.group):!freshWaypoint&&triggeredForward?(waypoint.queueTrigger(axis.forward),triggeredGroups[waypoint.group.id]=waypoint.group):freshWaypoint&&axis.oldScroll>=waypoint.triggerPoint&&(waypoint.queueTrigger(axis.forward),triggeredGroups[waypoint.group.id]=waypoint.group)}}return Waypoint.requestAnimationFrame(function(){for(var groupKey in triggeredGroups)triggeredGroups[groupKey].flushTriggers()}),this},Context.findOrCreateByElement=function(element){return Context.findByElement(element)||new Context(element)},Context.refreshAll=function(){for(var contextId in contexts)contexts[contextId].refresh()},Context.findByElement=function(element){return contexts[element.waypointContextKey]},window.onload=function(){oldWindowLoad&&oldWindowLoad(),Context.refreshAll()},Waypoint.requestAnimationFrame=function(callback){var requestFn=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||requestAnimationFrameShim;requestFn.call(window,callback)},Waypoint.Context=Context}(),function(){"use strict";function byTriggerPoint(a,b){return a.triggerPoint-b.triggerPoint}function byReverseTriggerPoint(a,b){return b.triggerPoint-a.triggerPoint}function Group(options){this.name=options.name,this.axis=options.axis,this.id=this.name+"-"+this.axis,this.waypoints=[],this.clearTriggerQueues(),groups[this.axis][this.name]=this}var groups={vertical:{},horizontal:{}},Waypoint=window.Waypoint;Group.prototype.add=function(waypoint){this.waypoints.push(waypoint)},Group.prototype.clearTriggerQueues=function(){this.triggerQueues={up:[],down:[],left:[],right:[]}},Group.prototype.flushTriggers=function(){for(var direction in this.triggerQueues){var waypoints=this.triggerQueues[direction],reverse="up"===direction||"left"===direction;waypoints.sort(reverse?byReverseTriggerPoint:byTriggerPoint);for(var i=0,end=waypoints.length;i<end;i+=1){var waypoint=waypoints[i];(waypoint.options.continuous||i===waypoints.length-1)&&waypoint.trigger([direction])}}this.clearTriggerQueues()},Group.prototype.next=function(waypoint){this.waypoints.sort(byTriggerPoint);var index=Waypoint.Adapter.inArray(waypoint,this.waypoints),isLast=index===this.waypoints.length-1;return isLast?null:this.waypoints[index+1]},Group.prototype.previous=function(waypoint){this.waypoints.sort(byTriggerPoint);var index=Waypoint.Adapter.inArray(waypoint,this.waypoints);return index?this.waypoints[index-1]:null},Group.prototype.queueTrigger=function(waypoint,direction){this.triggerQueues[direction].push(waypoint)},Group.prototype.remove=function(waypoint){var index=Waypoint.Adapter.inArray(waypoint,this.waypoints);index>-1&&this.waypoints.splice(index,1)},Group.prototype.first=function(){return this.waypoints[0]},Group.prototype.last=function(){return this.waypoints[this.waypoints.length-1]},Group.findOrCreate=function(options){return groups[options.axis][options.name]||new Group(options)},Waypoint.Group=Group}(),function(){"use strict";function JQueryAdapter(element){this.$element=$(element)}var $=window.jQuery,Waypoint=window.Waypoint;$.each(["innerHeight","innerWidth","off","offset","on","outerHeight","outerWidth","scrollLeft","scrollTop"],function(i,method){JQueryAdapter.prototype[method]=function(){var args=Array.prototype.slice.call(arguments);return this.$element[method].apply(this.$element,args)}}),$.each(["extend","inArray","isEmptyObject"],function(i,method){JQueryAdapter[method]=$[method]}),Waypoint.adapters.push({name:"jquery",Adapter:JQueryAdapter}),Waypoint.Adapter=JQueryAdapter}(),function(){"use strict";function createExtension(framework){return function(){var waypoints=[],overrides=arguments[0];return framework.isFunction(arguments[0])&&(overrides=framework.extend({},arguments[1]),overrides.handler=arguments[0]),this.each(function(){var options=framework.extend({},overrides,{element:this});"string"==typeof options.context&&(options.context=framework(this).closest(options.context)[0]),waypoints.push(new Waypoint(options))}),waypoints}}var Waypoint=window.Waypoint;window.jQuery&&(window.jQuery.fn.elementorWaypoint=createExtension(window.jQuery)),window.Zepto&&(window.Zepto.fn.elementorWaypoint=createExtension(window.Zepto))}();

var elementorFrontendConfig = {"environmentMode":{"edit":false,"wpPreview":false,"isScriptDebug":false},"i18n":{"shareOnFacebook":"Share on Facebook","shareOnTwitter":"Share on Twitter","pinIt":"Pin it","download":"Download","downloadImage":"Download image","fullscreen":"Fullscreen","zoom":"Zoom","share":"Share","playVideo":"Play Video","previous":"Previous","next":"Next","close":"Close"},"is_rtl":false,"breakpoints":{"xs":0,"sm":480,"md":768,"lg":992,"xl":1440,"xxl":1600},"responsive":{"breakpoints":{"mobile":{"label":"Mobile","value":767,"default_value":767,"direction":"max","is_enabled":true},"mobile_extra":{"label":"Mobile Extra","value":880,"default_value":880,"direction":"max","is_enabled":false},"tablet":{"label":"Tablet","value":991,"default_value":1024,"direction":"max","is_enabled":true},"tablet_extra":{"label":"Tablet Extra","value":1200,"default_value":1200,"direction":"max","is_enabled":false},"laptop":{"label":"Laptop","value":1366,"default_value":1366,"direction":"max","is_enabled":false},"widescreen":{"label":"Widescreen","value":2400,"default_value":2400,"direction":"min","is_enabled":false}}},"version":"3.5.3","is_static":false,"experimentalFeatures":{"e_dom_optimization":true,"e_optimized_assets_loading":true,"e_optimized_css_loading":true,"a11y_improvements":true,"e_import_export":true,"additional_custom_breakpoints":true,"e_hidden_wordpress_widgets":true,"landing-pages":true,"elements-color-picker":true,"favorite-widgets":true,"admin-top-bar":true},"urls":{"assets":"https:\/\/www.portotheme.com\/wordpress\/porto\/elementor\/transportation\/wp-content\/plugins\/elementor\/assets\/"},"settings":{"page":[],"editorPreferences":[]},"kit":{"viewport_tablet":"991","active_breakpoints":["viewport_mobile","viewport_tablet"],"global_image_lightbox":"yes","lightbox_enable_counter":"yes","lightbox_enable_fullscreen":"yes","lightbox_enable_zoom":"yes","lightbox_enable_share":"yes","lightbox_title_src":"title","lightbox_description_src":"description"},"post":{"id":1,"title":"Hello%20world%21%20%E2%80%93%20Transportation%20%26%20Logistic","excerpt":"","featuredImage":false}};/*! elementor - v3.5.3 - 28-12-2021 */
"use strict";(self.webpackChunkelementor=self.webpackChunkelementor||[]).push([[819],{9220:(e,t,n)=>{var i=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var s=i(n(8135));class _default extends elementorModules.ViewModule{constructor(...e){super(...e),this.documents={},this.initDocumentClasses(),this.attachDocumentsClasses()}getDefaultSettings(){return{selectors:{document:".elementor"}}}getDefaultElements(){const e=this.getSettings("selectors");return{$documents:jQuery(e.document)}}initDocumentClasses(){this.documentClasses={base:s.default},elementorFrontend.hooks.doAction("elementor/frontend/documents-manager/init-classes",this)}addDocumentClass(e,t){this.documentClasses[e]=t}attachDocumentsClasses(){this.elements.$documents.each(((e,t)=>this.attachDocumentClass(jQuery(t))))}attachDocumentClass(e){const t=e.data(),n=t.elementorId,i=t.elementorType,s=this.documentClasses[i]||this.documentClasses.base;this.documents[n]=new s({$element:e,id:n})}}t.default=_default},9804:(e,t,n)=>{var i=n(7914),s=i(n(6397)),o=i(n(9320)),r=i(n(7537));e.exports=function(e){const t={};this.elementsHandlers={"accordion.default":()=>n.e(209).then(n.bind(n,8470)),"alert.default":()=>n.e(745).then(n.bind(n,9269)),"counter.default":()=>n.e(120).then(n.bind(n,7884)),"progress.default":()=>n.e(192).then(n.bind(n,1351)),"tabs.default":()=>n.e(520).then(n.bind(n,9459)),"toggle.default":()=>n.e(181).then(n.bind(n,2)),"video.default":()=>n.e(791).then(n.bind(n,5363)),"image-carousel.default":()=>n.e(268).then(n.bind(n,5914)),"text-editor.default":()=>n.e(357).then(n.bind(n,1327)),"wp-widget-media_audio.default":()=>n.e(52).then(n.bind(n,7602))};const addElementsHandlers=()=>{this.elementsHandlers.section=o.default,this.elementsHandlers.column=r.default,e.each(this.elementsHandlers,((e,t)=>{const n=e.split(".");e=n[0];const i=n[1]||null;this.attachHandler(e,t,i)}))},isClassHandler=e=>{var t;return null===(t=e.prototype)||void 0===t?void 0:t.getUniqueHandlerID},addHandlerWithHook=(e,t,n="default")=>{n=n?"."+n:"",elementorFrontend.hooks.addAction(`frontend/element_ready/${e}${n}`,(e=>{if(isClassHandler(t))this.addHandler(t,{$element:e},!0);else{const n=t();n instanceof Promise?n.then((({default:t})=>{this.addHandler(t,{$element:e},!0)})):this.addHandler(n,{$element:e},!0)}}))};this.addHandler=function(e,n){const i=n.$element.data("model-cid");let s;if(i){s=e.prototype.getConstructorID(),t[i]||(t[i]={});const n=t[i][s];n&&n.onDestroy()}const o=new e(n);i&&(t[i][s]=o)},this.attachHandler=(e,t,n)=>{Array.isArray(t)||(t=[t]),t.forEach((t=>addHandlerWithHook(e,t,n)))},this.getHandler=function(e){if(!e)return;const t=this.elementsHandlers[e];return isClassHandler(t)?t:new Promise((e=>{t().then((({default:t})=>{e(t)}))}))},this.getHandlers=function(e){return elementorCommon.helpers.softDeprecated("getHandlers","3.1.0","elementorFrontend.elementsHandler.getHandler"),e?this.getHandler(e):this.elementsHandlers},this.runReadyTrigger=function(t){if(elementorFrontend.config.is_static)return;const n=jQuery(t),i=n.attr("data-element_type");if(i&&(elementorFrontend.hooks.doAction("frontend/element_ready/global",n,e),elementorFrontend.hooks.doAction(`frontend/element_ready/${i}`,n,e),"widget"===i)){const t=n.attr("data-widget_type");elementorFrontend.hooks.doAction(`frontend/element_ready/${t}`,n,e)}},this.init=()=>{elementorFrontend.hooks.addAction("frontend/element_ready/global",s.default),addElementsHandlers()}}},5654:(e,t,n)=>{var i=n(7914);n(59);var s=i(n(9220)),o=i(n(5107)),r=i(n(3308)),a=i(n(1604)),l=i(n(1911)),d=i(n(4773)),c=i(n(2064)),u=i(n(8628)),h=i(n(8646)),m=i(n(6866)),g=i(n(4375)),p=i(n(6404)),f=i(n(6046)),v=n(6028);const b=n(9469),y=n(9804),_=n(3346);class Frontend extends elementorModules.ViewModule{constructor(...e){super(...e),this.config=elementorFrontendConfig,this.config.legacyMode={get elementWrappers(){return elementorFrontend.isEditMode()&&elementorCommon.helpers.hardDeprecated("elementorFrontend.config.legacyMode.elementWrappers","3.1.0","elementorFrontend.config.experimentalFeatures.e_dom_optimization"),!elementorFrontend.config.experimentalFeatures.e_dom_optimization}},this.populateActiveBreakpointsConfig()}get Module(){return this.isEditMode()&&parent.elementorCommon.helpers.hardDeprecated("elementorFrontend.Module","2.5.0","elementorModules.frontend.handlers.Base"),elementorModules.frontend.handlers.Base}getDefaultSettings(){return{selectors:{elementor:".elementor",adminBar:"#wpadminbar"}}}getDefaultElements(){const e={window,$window:jQuery(window),$document:jQuery(document),$head:jQuery(document.head),$body:jQuery(document.body),$deviceMode:jQuery("<span>",{id:"elementor-device-mode",class:"elementor-screen-only"})};return e.$body.append(e.$deviceMode),e}bindEvents(){this.elements.$window.on("resize",(()=>this.setDeviceModeData()))}getElements(e){return this.getItems(this.elements,e)}getPageSettings(e){const t=this.isEditMode()?elementor.settings.page.model.attributes:this.config.settings.page;return this.getItems(t,e)}getGeneralSettings(e){return this.isEditMode()&&parent.elementorCommon.helpers.softDeprecated("getGeneralSettings","3.0.0","getKitSettings and remove the `elementor_` prefix"),this.getKitSettings(`elementor_${e}`)}getKitSettings(e){return this.getItems(this.config.kit,e)}getCurrentDeviceMode(){return getComputedStyle(this.elements.$deviceMode[0],":after").content.replace(/"/g,"")}getDeviceSetting(e,t,n){if("widescreen"===e)return this.getWidescreenSetting(t,n);const i=elementorFrontend.breakpoints.getActiveBreakpointsList({largeToSmall:!0,withDesktop:!0});let s=i.indexOf(e);for(;s>0;){const e=t[n+"_"+i[s]];if(e||0===e)return e;s--}return t[n]}getWidescreenSetting(e,t){const n=t+"_widescreen";let i;return i=e[n]?e[n]:e[t],i}getCurrentDeviceSetting(e,t){return this.getDeviceSetting(elementorFrontend.getCurrentDeviceMode(),e,t)}isEditMode(){return this.config.environmentMode.edit}isWPPreviewMode(){return this.config.environmentMode.wpPreview}initDialogsManager(){let e;this.getDialogsManager=()=>(e||(e=new DialogsManager.Instance),e)}initOnReadyComponents(){this.utils={youtube:new a.default,vimeo:new l.default,baseVideoLoader:new d.default,anchors:new _,get lightbox(){return h.default.getLightbox()},urlActions:new c.default,swiper:u.default,environment:r.default,assetsLoader:new m.default,escapeHTML:v.escapeHTML},this.modules={StretchElement:elementorModules.frontend.tools.StretchElement,Masonry:elementorModules.utils.Masonry},this.elementsHandler.init(),this.isEditMode()?elementor.once("document:loaded",(()=>this.onDocumentLoaded())):this.onDocumentLoaded()}initOnReadyElements(){this.elements.$wpAdminBar=this.elements.$document.find(this.getSettings("selectors.adminBar"))}addUserAgentClasses(){for(const[e,t]of Object.entries(r.default))t&&this.elements.$body.addClass("e--ua-"+e)}setDeviceModeData(){this.elements.$body.attr("data-elementor-device-mode",this.getCurrentDeviceMode())}addListenerOnce(e,t,n,i){if(i||(i=this.elements.$window),this.isEditMode())if(this.removeListeners(e,t,i),i instanceof jQuery){const s=t+"."+e;i.on(s,n)}else i.on(t,n,e);else i.on(t,n)}removeListeners(e,t,n,i){if(i||(i=this.elements.$window),i instanceof jQuery){const s=t+"."+e;i.off(s,n)}else i.off(t,n,e)}debounce(e,t){let n;return function(){const i=this,s=arguments,later=()=>{n=null,e.apply(i,s)},o=!n;clearTimeout(n),n=setTimeout(later,t),o&&e.apply(i,s)}}waypoint(e,t,n){n=jQuery.extend({offset:"100%",triggerOnce:!0},n);return e.elementorWaypoint((function(){const e=this.element||this,i=t.apply(e,arguments);return n.triggerOnce&&this.destroy&&this.destroy(),i}),n)}muteMigrationTraces(){jQuery.migrateMute=!0,jQuery.migrateTrace=!1}initModules(){const e={shapes:f.default};elementorFrontend.trigger("elementor/modules/init:before"),elementorFrontend.trigger("elementor/modules/init/before"),Object.entries(e).forEach((([e,t])=>{this.modulesHandlers[e]=new t}))}populateActiveBreakpointsConfig(){this.config.responsive.activeBreakpoints={},Object.entries(this.config.responsive.breakpoints).forEach((([e,t])=>{t.is_enabled&&(this.config.responsive.activeBreakpoints[e]=t)}))}init(){this.hooks=new b,this.breakpoints=new g.default(this.config.responsive),this.storage=new o.default,this.elementsHandler=new y(jQuery),this.modulesHandlers={},this.addUserAgentClasses(),this.setDeviceModeData(),this.initDialogsManager(),this.isEditMode()&&this.muteMigrationTraces(),p.default.dispatch(this.elements.$window,"elementor/frontend/init"),this.initModules(),this.initOnReadyElements(),this.initOnReadyComponents()}onDocumentLoaded(){this.documentsManager=new s.default,this.trigger("components:init"),new h.default}}window.elementorFrontend=new Frontend,elementorFrontend.isEditMode()||jQuery((()=>elementorFrontend.init()))},4058:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class BackgroundSlideshow extends elementorModules.frontend.handlers.SwiperBase{getDefaultSettings(){return{classes:{swiperContainer:"elementor-background-slideshow swiper-container",swiperWrapper:"swiper-wrapper",swiperSlide:"elementor-background-slideshow__slide swiper-slide",slideBackground:"elementor-background-slideshow__slide__image",kenBurns:"elementor-ken-burns",kenBurnsActive:"elementor-ken-burns--active",kenBurnsIn:"elementor-ken-burns--in",kenBurnsOut:"elementor-ken-burns--out"}}}getSwiperOptions(){const e=this.getElementSettings(),t={grabCursor:!1,slidesPerView:1,slidesPerGroup:1,loop:"yes"===e.background_slideshow_loop,speed:e.background_slideshow_transition_duration,autoplay:{delay:e.background_slideshow_slide_duration,stopOnLastSlide:!e.background_slideshow_loop},handleElementorBreakpoints:!0,on:{slideChange:()=>{e.background_slideshow_ken_burns&&this.handleKenBurns()}}};switch("yes"===e.background_slideshow_loop&&(t.loopedSlides=this.getSlidesCount()),e.background_slideshow_slide_transition){case"fade":t.effect="fade",t.fadeEffect={crossFade:!0};break;case"slide_down":t.autoplay.reverseDirection=!0;case"slide_up":t.direction="vertical"}return t}buildSwiperElements(){const e=this.getSettings("classes"),t=this.getElementSettings(),n="slide_left"===t.background_slideshow_slide_transition?"ltr":"rtl",i=jQuery("<div>",{class:e.swiperContainer,dir:n}),s=jQuery("<div>",{class:e.swiperWrapper}),o=t.background_slideshow_ken_burns;let r=e.slideBackground;if(o){r+=" "+e.kenBurns;const n="in"===t.background_slideshow_ken_burns_zoom_direction?"kenBurnsIn":"kenBurnsOut";r+=" "+e[n]}this.elements.$slides=jQuery(),t.background_slideshow_gallery.forEach((t=>{const n=jQuery("<div>",{class:e.swiperSlide}),i=jQuery("<div>",{class:r,style:'background-image: url("'+t.url+'");'});n.append(i),s.append(n),this.elements.$slides=this.elements.$slides.add(n)})),i.append(s),this.$element.prepend(i),this.elements.$backgroundSlideShowContainer=i}async initSlider(){if(1>=this.getSlidesCount())return;const e=this.getElementSettings(),t=elementorFrontend.utils.swiper;this.swiper=await new t(this.elements.$backgroundSlideShowContainer,this.getSwiperOptions()),this.elements.$backgroundSlideShowContainer.data("swiper",this.swiper),e.background_slideshow_ken_burns&&this.handleKenBurns()}activate(){this.buildSwiperElements(),this.initSlider()}deactivate(){this.swiper&&(this.swiper.destroy(),this.elements.$backgroundSlideShowContainer.remove())}run(){"slideshow"===this.getElementSettings("background_background")?this.activate():this.deactivate()}onInit(){super.onInit(),this.getElementSettings("background_slideshow_gallery")&&this.run()}onDestroy(){super.onDestroy(),this.deactivate()}onElementChange(e){"background_background"===e&&this.run()}}t.default=BackgroundSlideshow},7537:(e,t,n)=>{var i=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var s=[i(n(4058)).default];t.default=s},6397:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class GlobalHandler extends elementorModules.frontend.handlers.Base{getWidgetType(){return"global"}animate(){const e=this.$element,t=this.getAnimation();if("none"===t)return void e.removeClass("elementor-invisible");const n=this.getElementSettings(),i=n._animation_delay||n.animation_delay||0;e.removeClass(t),this.currentAnimation&&e.removeClass(this.currentAnimation),this.currentAnimation=t,setTimeout((()=>{e.removeClass("elementor-invisible").addClass("animated "+t)}),i)}getAnimation(){return this.getCurrentDeviceSetting("animation")||this.getCurrentDeviceSetting("_animation")}onInit(...e){if(super.onInit(...e),this.getAnimation()){const e=elementorModules.utils.Scroll.scrollObserver({callback:t=>{t.isInViewport&&(this.animate(),e.unobserve(this.$element[0]))}});e.observe(this.$element[0])}}onElementChange(e){/^_?animation/.test(e)&&this.animate()}}t.default=e=>{elementorFrontend.elementsHandler.addHandler(GlobalHandler,{$element:e})}},2987:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class BackgroundVideo extends elementorModules.frontend.handlers.Base{getDefaultSettings(){return{selectors:{backgroundVideoContainer:".elementor-background-video-container",backgroundVideoEmbed:".elementor-background-video-embed",backgroundVideoHosted:".elementor-background-video-hosted"}}}getDefaultElements(){const e=this.getSettings("selectors"),t={$backgroundVideoContainer:this.$element.find(e.backgroundVideoContainer)};return t.$backgroundVideoEmbed=t.$backgroundVideoContainer.children(e.backgroundVideoEmbed),t.$backgroundVideoHosted=t.$backgroundVideoContainer.children(e.backgroundVideoHosted),t}calcVideosSize(e){let t="16:9";"vimeo"===this.videoType&&(t=e[0].width+":"+e[0].height);const n=this.elements.$backgroundVideoContainer.outerWidth(),i=this.elements.$backgroundVideoContainer.outerHeight(),s=t.split(":"),o=s[0]/s[1],r=n/i>o;return{width:r?n:i*o,height:r?n/o:i}}changeVideoSize(){if("hosted"!==this.videoType&&!this.player)return;let e;if("youtube"===this.videoType?e=jQuery(this.player.getIframe()):"vimeo"===this.videoType?e=jQuery(this.player.element):"hosted"===this.videoType&&(e=this.elements.$backgroundVideoHosted),!e)return;const t=this.calcVideosSize(e);e.width(t.width).height(t.height)}startVideoLoop(e){if(!this.player.getIframe().contentWindow)return;const t=this.getElementSettings(),n=t.background_video_start||0,i=t.background_video_end;if(!t.background_play_once||e){if(this.player.seekTo(n),i){setTimeout((()=>{this.startVideoLoop(!1)}),1e3*(i-n+1))}}else this.player.stopVideo()}prepareVimeoVideo(e,t){const n=this.getElementSettings(),i={url:t,width:this.elements.$backgroundVideoContainer.outerWidth().width,autoplay:!0,loop:!n.background_play_once,transparent:!1,background:!0,muted:!0};this.player=new e.Player(this.elements.$backgroundVideoContainer,i),this.handleVimeoStartEndTimes(n),this.player.ready().then((()=>{jQuery(this.player.element).addClass("elementor-background-video-embed"),this.changeVideoSize()}))}handleVimeoStartEndTimes(e){e.background_video_start&&this.player.on("play",(t=>{0===t.seconds&&this.player.setCurrentTime(e.background_video_start)})),this.player.on("timeupdate",(t=>{e.background_video_end&&e.background_video_end<t.seconds&&(e.background_play_once?this.player.pause():this.player.setCurrentTime(e.background_video_start)),this.player.getDuration().then((n=>{e.background_video_start&&!e.background_video_end&&t.seconds>n-.5&&this.player.setCurrentTime(e.background_video_start)}))}))}prepareYTVideo(e,t){const n=this.elements.$backgroundVideoContainer,i=this.getElementSettings();let s=e.PlayerState.PLAYING;window.chrome&&(s=e.PlayerState.UNSTARTED);const o={videoId:t,events:{onReady:()=>{this.player.mute(),this.changeVideoSize(),this.startVideoLoop(!0),this.player.playVideo()},onStateChange:t=>{switch(t.data){case s:n.removeClass("elementor-invisible elementor-loading");break;case e.PlayerState.ENDED:this.player.seekTo(i.background_video_start||0),i.background_play_once&&this.player.destroy()}}},playerVars:{controls:0,rel:0,playsinline:1}};i.background_privacy_mode&&(o.host="https://www.youtube-nocookie.com",o.origin=window.location.hostname),n.addClass("elementor-loading elementor-invisible"),this.player=new e.Player(this.elements.$backgroundVideoEmbed[0],o)}activate(){let e,t=this.getElementSettings("background_video_link");const n=this.getElementSettings("background_play_once");if(-1!==t.indexOf("vimeo.com")?(this.videoType="vimeo",this.apiProvider=elementorFrontend.utils.vimeo):t.match(/^(?:https?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com)/)&&(this.videoType="youtube",this.apiProvider=elementorFrontend.utils.youtube),this.apiProvider)e=this.apiProvider.getVideoIDFromURL(t),this.apiProvider.onApiReady((n=>{"youtube"===this.videoType&&this.prepareYTVideo(n,e),"vimeo"===this.videoType&&this.prepareVimeoVideo(n,t)}));else{this.videoType="hosted";const e=this.getElementSettings("background_video_start"),i=this.getElementSettings("background_video_end");(e||i)&&(t+="#t="+(e||0)+(i?","+i:"")),this.elements.$backgroundVideoHosted.attr("src",t).one("canplay",this.changeVideoSize.bind(this)),n&&this.elements.$backgroundVideoHosted.on("ended",(()=>{this.elements.$backgroundVideoHosted.hide()}))}elementorFrontend.elements.$window.on("resize",this.changeVideoSize)}deactivate(){"youtube"===this.videoType&&this.player.getIframe()||"vimeo"===this.videoType?this.player.destroy():this.elements.$backgroundVideoHosted.removeAttr("src").off("ended"),elementorFrontend.elements.$window.off("resize",this.changeVideoSize)}run(){const e=this.getElementSettings();(e.background_play_on_mobile||"mobile"!==elementorFrontend.getCurrentDeviceMode())&&("video"===e.background_background&&e.background_video_link?this.activate():this.deactivate())}onInit(...e){super.onInit(...e),this.changeVideoSize=this.changeVideoSize.bind(this),this.run()}onElementChange(e){"background_background"===e&&this.run()}}t.default=BackgroundVideo},355:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class HandlesPosition extends elementorModules.frontend.handlers.Base{isActive(){return elementorFrontend.isEditMode()}isFirstSection(){return this.$element[0]===document.querySelector(".elementor-edit-mode .elementor-top-section")}isOverflowHidden(){return"hidden"===this.$element.css("overflow")}getOffset(){if("body"===elementor.config.document.container)return this.$element.offset().top;const e=jQuery(elementor.config.document.container);return this.$element.offset().top-e.offset().top}setHandlesPosition(){const e=elementor.documents.getCurrent();if(!e||!e.container.isEditable())return;const t="elementor-section--handles-inside",n=this.$element.find("> .elementor-element-overlay > .elementor-editor-section-settings");if(elementor.settings.page.model.attributes.scroll_snap)return void this.$element.addClass(t);const i=this.isOverflowHidden();if(!i&&!this.isFirstSection())return;const s=i?0:this.getOffset();s<25?(this.$element.addClass(t),s<-5?n.css("top",-s):n.css("top","")):this.$element.removeClass(t)}onInit(){this.isActive()&&(this.setHandlesPosition(),this.$element.on("mouseenter",this.setHandlesPosition.bind(this)))}}t.default=HandlesPosition},9320:(e,t,n)=>{var i=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var s=i(n(4058)),o=i(n(2987)),r=i(n(355)),a=i(n(2804)),l=i(n(3384)),d=[a.default,s.default,o.default,r.default,l.default];t.default=d},3384:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class Shapes extends elementorModules.frontend.handlers.Base{getDefaultSettings(){return{selectors:{container:"> .elementor-shape-%s"},svgURL:elementorFrontend.config.urls.assets+"shapes/"}}getDefaultElements(){const e={},t=this.getSettings("selectors");return e.$topContainer=this.$element.find(t.container.replace("%s","top")),e.$bottomContainer=this.$element.find(t.container.replace("%s","bottom")),e}isActive(){return elementorFrontend.isEditMode()}getSvgURL(e,t){let n=this.getSettings("svgURL")+t+".svg";return elementor.config.additional_shapes&&e in elementor.config.additional_shapes&&(n=elementor.config.additional_shapes[e],-1<t.indexOf("-negative")&&(n=n.replace(".svg","-negative.svg"))),n}buildSVG(e){const t="shape_divider_"+e,n=this.getElementSettings(t),i=this.elements["$"+e+"Container"];if(i.attr("data-shape",n),!n)return void i.empty();let s=n;this.getElementSettings(t+"_negative")&&(s+="-negative");const o=this.getSvgURL(n,s);jQuery.get(o,(e=>{i.empty().append(e.childNodes[0])})),this.setNegative(e)}setNegative(e){this.elements["$"+e+"Container"].attr("data-negative",!!this.getElementSettings("shape_divider_"+e+"_negative"))}onInit(...e){this.isActive(this.getSettings())&&(super.onInit(...e),["top","bottom"].forEach((e=>{this.getElementSettings("shape_divider_"+e)&&this.buildSVG(e)})))}onElementChange(e){const t=e.match(/^shape_divider_(top|bottom)$/);if(t)return void this.buildSVG(t[1]);const n=e.match(/^shape_divider_(top|bottom)_negative$/);n&&(this.buildSVG(n[1]),this.setNegative(n[1]))}}t.default=Shapes},2804:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class StretchedSection extends elementorModules.frontend.handlers.Base{bindEvents(){const e=this.getUniqueHandlerID();elementorFrontend.addListenerOnce(e,"resize",this.stretch),elementorFrontend.addListenerOnce(e,"sticky:stick",this.stretch,this.$element),elementorFrontend.addListenerOnce(e,"sticky:unstick",this.stretch,this.$element),elementorFrontend.isEditMode()&&(this.onKitChangeStretchContainerChange=this.onKitChangeStretchContainerChange.bind(this),elementor.channels.editor.on("kit:change:stretchContainer",this.onKitChangeStretchContainerChange))}unbindEvents(){elementorFrontend.removeListeners(this.getUniqueHandlerID(),"resize",this.stretch),elementorFrontend.isEditMode()&&elementor.channels.editor.off("kit:change:stretchContainer",this.onKitChangeStretchContainerChange)}isActive(e){return elementorFrontend.isEditMode()||e.$element.hasClass("elementor-section-stretched")}initStretch(){this.stretch=this.stretch.bind(this),this.stretchElement=new elementorModules.frontend.tools.StretchElement({element:this.$element,selectors:{container:this.getStretchContainer()}})}getStretchContainer(){return elementorFrontend.getKitSettings("stretched_section_container")||window}stretch(){this.getElementSettings("stretch_section")&&this.stretchElement.stretch()}onInit(...e){this.isActive(this.getSettings())&&(this.initStretch(),super.onInit(...e),this.stretch())}onElementChange(e){"stretch_section"===e&&(this.getElementSettings("stretch_section")?this.stretch():this.stretchElement.reset())}onKitChangeStretchContainerChange(){this.stretchElement.setSettings("selectors.container",this.getStretchContainer()),this.stretch()}}t.default=StretchedSection},3346:(e,t,n)=>{var i=n(6028);e.exports=elementorModules.ViewModule.extend({getDefaultSettings:function(){return{scrollDuration:500,selectors:{links:'a[href*="#"]',targets:".elementor-element, .elementor-menu-anchor",scrollable:(0,i.isScrollSnapActive)()?"body":"html, body"}}},getDefaultElements:function(){return{$scrollable:jQuery(this.getSettings("selectors").scrollable)}},bindEvents:function(){elementorFrontend.elements.$document.on("click",this.getSettings("selectors.links"),this.handleAnchorLinks)},handleAnchorLinks:function(e){var t,n=e.currentTarget,s=location.pathname===n.pathname;if(location.hostname===n.hostname&&s&&!(n.hash.length<2)){try{t=jQuery(n.hash).filter(this.getSettings("selectors.targets"))}catch(e){return}if(t.length){var o=t.offset().top,r=elementorFrontend.elements.$wpAdminBar,a=jQuery(".elementor-section.elementor-sticky--active:visible");r.length>0&&(o-=r.height()),a.length>0&&(o-=Math.max.apply(null,a.map((function(){return jQuery(this).outerHeight()})).get())),e.preventDefault(),o=elementorFrontend.hooks.applyFilters("frontend/handlers/menu_anchor/scroll_top_distance",o),(0,i.isScrollSnapActive)()&&elementorFrontend.elements.$body.css("scroll-snap-type","none"),this.elements.$scrollable.animate({scrollTop:o},this.getSettings("scrollDuration"),"linear",(()=>{(0,i.isScrollSnapActive)()&&elementorFrontend.elements.$body.css("scroll-snap-type","")}))}}},onInit:function(){elementorModules.ViewModule.prototype.onInit.apply(this,arguments)}})},6866:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class AssetsLoader{getScriptElement(e){const t=document.createElement("script");return t.src=e,t}getStyleElement(e){const t=document.createElement("link");return t.rel="stylesheet",t.href=e,t}load(e,t){const n=AssetsLoader.assets[e][t];return n.loader||(n.loader=new Promise((t=>{const i="style"===e?this.getStyleElement(n.src):this.getScriptElement(n.src);i.onload=()=>t(!0);const s="head"===n.parent?n.parent:"body";document[s].appendChild(i)}))),n.loader}}t.default=AssetsLoader;const n=elementorFrontendConfig.environmentMode.isScriptDebug?"":".min";AssetsLoader.assets={script:{dialog:{src:`${elementorFrontendConfig.urls.assets}lib/dialog/dialog${n}.js?ver=4.9.0`},"share-link":{src:`${elementorFrontendConfig.urls.assets}lib/share-link/share-link${n}.js?ver=${elementorFrontendConfig.version}`},swiper:{src:`${elementorFrontendConfig.urls.assets}lib/swiper/swiper${n}.js?ver=5.3.6`}},style:{}}},8646:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class LightboxManager extends elementorModules.ViewModule{static getLightbox(){const e=new Promise((e=>{n.e(723).then(n.t.bind(n,3896,23)).then((({default:t})=>e(new t)))})),t=elementorFrontend.utils.assetsLoader.load("script","dialog"),i=elementorFrontend.utils.assetsLoader.load("script","share-link");return Promise.all([e,t,i]).then((()=>e))}getDefaultSettings(){return{selectors:{links:"a, [data-elementor-lightbox]"}}}getDefaultElements(){return{$links:jQuery(this.getSettings("selectors.links"))}}isLightboxLink(e){if("a"===e.tagName.toLowerCase()&&(e.hasAttribute("download")||!/^[^?]+\.(png|jpe?g|gif|svg|webp)(\?.*)?$/i.test(e.href))&&!e.dataset.elementorLightboxVideo)return!1;const t=elementorFrontend.getKitSettings("global_image_lightbox"),n=e.dataset.elementorOpenLightbox;return"yes"===n||t&&"no"!==n}async onLinkClick(e){const t=e.currentTarget,n=jQuery(e.target),i=elementorFrontend.isEditMode(),s=i&&elementor.$previewContents.find("body").hasClass("elementor-editor__ui-state__color-picker"),o=!!n.closest(".elementor-edit-area").length;if(!this.isLightboxLink(t))return void(i&&o&&e.preventDefault());if(e.preventDefault(),i&&!elementor.getPreferences("lightbox_in_editor"))return;if(s)return;(this.isOptimizedAssetsLoading()?await LightboxManager.getLightbox():elementorFrontend.utils.lightbox).createLightbox(t)}isOptimizedAssetsLoading(){return elementorFrontend.config.experimentalFeatures.e_optimized_assets_loading}bindEvents(){elementorFrontend.elements.$document.on("click",this.getSettings("selectors.links"),(e=>this.onLinkClick(e)))}onInit(...e){super.onInit(...e),this.isOptimizedAssetsLoading()&&!elementorFrontend.isEditMode()&&this.elements.$links.each(((e,t)=>{if(this.isLightboxLink(t))return LightboxManager.getLightbox(),!1}))}}t.default=LightboxManager},8628:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;t.default=class Swiper{constructor(e,t){return this.config=t,this.config.breakpoints&&(this.config=this.adjustConfig(t)),e.closest(".elementor-widget-wrap").addClass("e-swiper-container"),new Promise((t=>{if(!elementorFrontend.config.experimentalFeatures.e_optimized_assets_loading)return t(this.createSwiperInstance(e,this.config));elementorFrontend.utils.assetsLoader.load("script","swiper").then((()=>t(this.createSwiperInstance(e,this.config))))}))}createSwiperInstance(e,t){const n=window.Swiper;return n.prototype.adjustConfig=this.adjustConfig,new n(e,t)}adjustConfig(e){if(!e.handleElementorBreakpoints)return e;const t=elementorFrontend.config.responsive.activeBreakpoints,n=elementorFrontend.breakpoints.getBreakpointValues();return Object.keys(e.breakpoints).forEach((i=>{const s=parseInt(i);let o;if(s===t.mobile.value||s+1===t.mobile.value)o=0;else if(!t.widescreen||s!==t.widescreen.value&&s+1!==t.widescreen.value){const e=n.findIndex((e=>s===e||s+1===e));o=n[e-1]}else o=s;e.breakpoints[o]=e.breakpoints[i],e.breakpoints[i]={slidesPerView:e.slidesPerView,slidesPerGroup:e.slidesPerGroup?e.slidesPerGroup:1}})),e}}},2064:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class _default extends elementorModules.ViewModule{getDefaultSettings(){return{selectors:{links:'a[href^="%23elementor-action"], a[href^="#elementor-action"]'}}}bindEvents(){elementorFrontend.elements.$document.on("click",this.getSettings("selectors.links"),this.runLinkAction.bind(this))}initActions(){this.actions={lightbox:async e=>{const t=await elementorFrontend.utils.lightbox;e.id?t.openSlideshow(e.id,e.url):(e.html&&delete e.html,t.showModal(e))}}}addAction(e,t){this.actions[e]=t}runAction(e,...t){const n=(e=decodeURIComponent(e)).match(/action=(.+?)&/),i=e.match(/settings=(.+)/);if(!n)return;const s=this.actions[n[1]];if(!s)return;let o={};i&&(o=JSON.parse(atob(i[1]))),s(o,...t)}runLinkAction(e){e.preventDefault(),this.runAction(jQuery(e.currentTarget).attr("href"),e)}runHashAction(){location.hash&&this.runAction(location.hash)}createActionHash(e,t){return encodeURIComponent(`#elementor-action:action=${e}&settings=${btoa(JSON.stringify(t))}`)}onInit(){super.onInit(),this.initActions(),elementorFrontend.on("components:init",this.runHashAction.bind(this))}}t.default=_default},6028:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.isScrollSnapActive=t.escapeHTML=void 0;t.escapeHTML=e=>{const t={"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"};return e.replace(/[&<>'"]/g,(e=>t[e]||e))};t.isScrollSnapActive=()=>{var e,t;return"yes"===(elementorFrontend.isEditMode()?null===(e=elementor.settings.page.model.attributes)||void 0===e?void 0:e.scroll_snap:null===(t=elementorFrontend.config.settings.page)||void 0===t?void 0:t.scroll_snap)}},4773:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class BaseLoader extends elementorModules.ViewModule{getDefaultSettings(){return{isInserted:!1,selectors:{firstScript:"script:first"}}}getDefaultElements(){return{$firstScript:jQuery(this.getSettings("selectors.firstScript"))}}insertAPI(){this.elements.$firstScript.before(jQuery("<script>",{src:this.getApiURL()})),this.setSettings("isInserted",!0)}getVideoIDFromURL(e){const t=e.match(this.getURLRegex());return t&&t[1]}onApiReady(e){this.getSettings("isInserted")||this.insertAPI(),this.isApiLoaded()?e(this.getApiObject()):setTimeout((()=>{this.onApiReady(e)}),350)}getAutoplayURL(e){return e.replace("&autoplay=0","")+"&autoplay=1"}}t.default=BaseLoader},1911:(e,t,n)=>{var i=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var s=i(n(4773));class VimeoLoader extends s.default{getApiURL(){return"https://player.vimeo.com/api/player.js"}getURLRegex(){return/^(?:https?:\/\/)?(?:www|player\.)?(?:vimeo\.com\/)?(?:video\/|external\/)?(\d+)([^.?&#"'>]?)/}isApiLoaded(){return window.Vimeo}getApiObject(){return Vimeo}getAutoplayURL(e){const t=(e=super.getAutoplayURL(e)).match(/#t=[^&]*/);return e.replace(t[0],"")+t}}t.default=VimeoLoader},1604:(e,t,n)=>{var i=n(7914);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var s=i(n(4773));class YoutubeLoader extends s.default{getApiURL(){return"https://www.youtube.com/iframe_api"}getURLRegex(){return/^(?:https?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?vi?=|(?:embed|v|vi|user)\/))([^?&"'>]+)/}isApiLoaded(){return window.YT&&YT.loaded}getApiObject(){return YT}}t.default=YoutubeLoader},59:(e,t,n)=>{n.p=elementorFrontendConfig.urls.assets+"js/"},4375:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class Breakpoints extends elementorModules.Module{constructor(e){super(),this.responsiveConfig=e}getActiveBreakpointsList(e={}){e={largeToSmall:!1,withDesktop:!1,...e};const t=Object.keys(this.responsiveConfig.activeBreakpoints);if(e.withDesktop){const e=-1===t.indexOf("widescreen")?t.length:t.length-1;t.splice(e,0,"desktop")}return e.largeToSmall&&t.reverse(),t}getBreakpointValues(){const{activeBreakpoints:e}=this.responsiveConfig,t=[];return Object.values(e).forEach((e=>{t.push(e.value)})),t}getDesktopPreviousDeviceKey(){let e="";const{activeBreakpoints:t}=this.responsiveConfig,n=Object.keys(t),i=n.length;return e="min"===t[n[i-1]].direction?n[i-2]:n[i-1],e}getDesktopMinPoint(){const{activeBreakpoints:e}=this.responsiveConfig;return e[this.getDesktopPreviousDeviceKey()].value+1}getDeviceMinBreakpoint(e){if("desktop"===e)return this.getDesktopMinPoint();const{activeBreakpoints:t}=this.responsiveConfig,n=Object.keys(t);let i;if(n[0]===e)i=320;else if("widescreen"===e)i=t[e]?t[e].value:this.responsiveConfig.breakpoints.widescreen;else{const s=n.indexOf(e);i=t[n[s-1]].value+1}return i}getActiveMatchRegex(){return new RegExp(this.getActiveBreakpointsList().map((e=>"_"+e)).join("|")+"$")}}t.default=Breakpoints},6404:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=t.Events=void 0;class Events{static dispatch(e,t,n=null,i=null){e=e instanceof jQuery?e[0]:e,i&&e.dispatchEvent(new CustomEvent(i,{detail:n})),e.dispatchEvent(new CustomEvent(t,{detail:n}))}}t.Events=Events;var n=Events;t.default=n},9469:e=>{e.exports=function(){var e,t=Array.prototype.slice,n={actions:{},filters:{}};function _removeHook(e,t,i,s){var o,r,a;if(n[e][t])if(i)if(o=n[e][t],s)for(a=o.length;a--;)(r=o[a]).callback===i&&r.context===s&&o.splice(a,1);else for(a=o.length;a--;)o[a].callback===i&&o.splice(a,1);else n[e][t]=[]}function _addHook(e,t,i,s,o){var r={callback:i,priority:s,context:o},a=n[e][t];if(a){var l=!1;if(jQuery.each(a,(function(){if(this.callback===i)return l=!0,!1})),l)return;a.push(r),a=function _hookInsertSort(e){for(var t,n,i,s=1,o=e.length;s<o;s++){for(t=e[s],n=s;(i=e[n-1])&&i.priority>t.priority;)e[n]=e[n-1],--n;e[n]=t}return e}(a)}else a=[r];n[e][t]=a}function _runHook(e,t,i){var s,o,r=n[e][t];if(!r)return"filters"===e&&i[0];if(o=r.length,"filters"===e)for(s=0;s<o;s++)i[0]=r[s].callback.apply(r[s].context,i);else for(s=0;s<o;s++)r[s].callback.apply(r[s].context,i);return"filters"!==e||i[0]}return e={removeFilter:function removeFilter(t,n){return"string"==typeof t&&_removeHook("filters",t,n),e},applyFilters:function applyFilters(){var n=t.call(arguments),i=n.shift();return"string"==typeof i?_runHook("filters",i,n):e},addFilter:function addFilter(t,n,i,s){return"string"==typeof t&&"function"==typeof n&&_addHook("filters",t,n,i=parseInt(i||10,10),s),e},removeAction:function removeAction(t,n){return"string"==typeof t&&_removeHook("actions",t,n),e},doAction:function doAction(){var n=t.call(arguments),i=n.shift();return"string"==typeof i&&_runHook("actions",i,n),e},addAction:function addAction(t,n,i,s){return"string"==typeof t&&"function"==typeof n&&_addHook("actions",t,n,i=parseInt(i||10,10),s),e}},e}},3308:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;const matchUserAgent=e=>n.indexOf(e)>=0,n=navigator.userAgent,i=!!window.opr&&!!opr.addons||!!window.opera||matchUserAgent(" OPR/"),s=matchUserAgent("Firefox"),o=/^((?!chrome|android).)*safari/i.test(n)||/constructor/i.test(window.HTMLElement)||"[object SafariRemoteNotification]"===(!window.safari||"undefined"!=typeof safari&&safari.pushNotification).toString(),r=/Trident|MSIE/.test(n)&&!!document.documentMode,a=!r&&!!window.StyleMedia||matchUserAgent("Edg"),l=!!window.chrome&&matchUserAgent("Chrome")&&!(a||i),d=matchUserAgent("Chrome")&&!!window.CSS;var c={appleWebkit:matchUserAgent("AppleWebKit")&&!d,blink:d,chrome:l,edge:a,firefox:s,ie:r,mac:matchUserAgent("Macintosh"),opera:i,safari:o,webkit:matchUserAgent("AppleWebKit")};t.default=c},5107:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class _default extends elementorModules.Module{get(e,t){let n;t=t||{};try{n=t.session?sessionStorage:localStorage}catch(t){return e?void 0:{}}let i=n.getItem("elementor");i=i?JSON.parse(i):{},i.__expiration||(i.__expiration={});const s=i.__expiration;let o=[];e?s[e]&&(o=[e]):o=Object.keys(s);let r=!1;return o.forEach((e=>{new Date(s[e])<new Date&&(delete i[e],delete s[e],r=!0)})),r&&this.save(i,t.session),e?i[e]:i}set(e,t,n){n=n||{};const i=this.get(null,n);if(i[e]=t,n.lifetimeInSeconds){const t=new Date;t.setTime(t.getTime()+1e3*n.lifetimeInSeconds),i.__expiration[e]=t.getTime()}this.save(i,n.session)}save(e,t){let n;try{n=t?sessionStorage:localStorage}catch(e){return}n.setItem("elementor",JSON.stringify(e))}}t.default=_default},6046:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;class _default extends elementorModules.Module{constructor(){super(),elementorFrontend.elementsHandler.attachHandler("text-path",(()=>n.e(48).then(n.bind(n,6468))))}}t.default=_default}},e=>{e.O(0,[354],(()=>{return t=5654,e(e.s=t);var t}));e.O()}]);
